/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.marker;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.PointF;
import org.oscim.renderer.atlas.TextureRegion;

public class MarkerSymbol {
    final boolean mBillboard;
    final Bitmap mBitmap;
    final PointF mOffset;
    final TextureRegion mTextureRegion;
    float rotation = 0.0f;

    public MarkerSymbol(Bitmap bitmap, float f, float f2) {
        this(bitmap, f, f2, true);
    }

    public MarkerSymbol(Bitmap bitmap, float f, float f2, boolean bl) {
        this.mBitmap = bitmap;
        this.mOffset = new PointF(f, f2);
        this.mBillboard = bl;
        this.mTextureRegion = null;
    }

    public MarkerSymbol(Bitmap bitmap, HotspotPlace hotspotPlace) {
        this(bitmap, hotspotPlace, true);
    }

    public MarkerSymbol(Bitmap bitmap, HotspotPlace hotspotPlace, boolean bl) {
        switch (1.$SwitchMap$org$oscim$layers$marker$MarkerSymbol$HotspotPlace[hotspotPlace.ordinal()]) {
            default: {
                this.mOffset = new PointF(0.5f, 0.5f);
                break;
            }
            case 8: {
                this.mOffset = new PointF(0.0f, 1.0f);
                break;
            }
            case 7: {
                this.mOffset = new PointF(0.0f, 0.0f);
                break;
            }
            case 6: {
                this.mOffset = new PointF(1.0f, 1.0f);
                break;
            }
            case 5: {
                this.mOffset = new PointF(1.0f, 0.0f);
                break;
            }
            case 4: {
                this.mOffset = new PointF(0.0f, 0.5f);
                break;
            }
            case 3: {
                this.mOffset = new PointF(1.0f, 0.5f);
                break;
            }
            case 2: {
                this.mOffset = new PointF(0.5f, 0.0f);
                break;
            }
            case 1: {
                this.mOffset = new PointF(0.5f, 1.0f);
            }
        }
        this.mBitmap = bitmap;
        this.mBillboard = bl;
        this.mTextureRegion = null;
    }

    public MarkerSymbol(TextureRegion textureRegion, float f, float f2) {
        this(textureRegion, f, f2, true);
    }

    public MarkerSymbol(TextureRegion textureRegion, float f, float f2, boolean bl) {
        this.mBitmap = null;
        this.mTextureRegion = textureRegion;
        this.mOffset = new PointF(f, f2);
        this.mBillboard = bl;
    }

    public MarkerSymbol(TextureRegion textureRegion, HotspotPlace hotspotPlace) {
        this(textureRegion, hotspotPlace, true);
    }

    public MarkerSymbol(TextureRegion textureRegion, HotspotPlace hotspotPlace, boolean bl) {
        this.mBitmap = null;
        this.mTextureRegion = textureRegion;
        switch (1.$SwitchMap$org$oscim$layers$marker$MarkerSymbol$HotspotPlace[hotspotPlace.ordinal()]) {
            default: {
                this.mOffset = new PointF(0.5f, 0.5f);
                break;
            }
            case 8: {
                this.mOffset = new PointF(0.0f, 1.0f);
                break;
            }
            case 7: {
                this.mOffset = new PointF(0.0f, 0.0f);
                break;
            }
            case 6: {
                this.mOffset = new PointF(1.0f, 1.0f);
                break;
            }
            case 5: {
                this.mOffset = new PointF(1.0f, 0.0f);
                break;
            }
            case 4: {
                this.mOffset = new PointF(0.0f, 0.5f);
                break;
            }
            case 3: {
                this.mOffset = new PointF(1.0f, 0.5f);
                break;
            }
            case 2: {
                this.mOffset = new PointF(0.5f, 0.0f);
                break;
            }
            case 1: {
                this.mOffset = new PointF(0.5f, 1.0f);
            }
        }
        this.mBillboard = bl;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public PointF getHotspot() {
        return this.mOffset;
    }

    public float getRotation() {
        return this.rotation;
    }

    public TextureRegion getTextureRegion() {
        return this.mTextureRegion;
    }

    public boolean isBillboard() {
        return this.mBillboard;
    }

    public boolean isBitmap() {
        boolean bl = this.mBitmap != null;
        return bl;
    }

    public boolean isInside(float f, float f2) {
        int n;
        int n2;
        if (this.isBitmap()) {
            n2 = this.mBitmap.getWidth();
            n = this.mBitmap.getHeight();
        } else {
            n2 = this.mTextureRegion.rect.w;
            n = this.mTextureRegion.rect.h;
        }
        float f3 = (float)(-n2) * this.mOffset.x;
        float f4 = (float)(-n) * (1.0f - this.mOffset.y);
        boolean bl = f >= f3 && f2 >= f4 && f <= f3 + (float)n2 && f2 <= f4 + (float)n;
        return bl;
    }

    public void setRotation(float f) {
        this.rotation = f;
    }

    public static final class HotspotPlace
    extends Enum<HotspotPlace> {
        private static final /* synthetic */ HotspotPlace[] $VALUES;
        public static final /* enum */ HotspotPlace BOTTOM_CENTER;
        public static final /* enum */ HotspotPlace CENTER;
        public static final /* enum */ HotspotPlace LEFT_CENTER;
        public static final /* enum */ HotspotPlace LOWER_LEFT_CORNER;
        public static final /* enum */ HotspotPlace LOWER_RIGHT_CORNER;
        public static final /* enum */ HotspotPlace NONE;
        public static final /* enum */ HotspotPlace RIGHT_CENTER;
        public static final /* enum */ HotspotPlace TOP_CENTER;
        public static final /* enum */ HotspotPlace UPPER_LEFT_CORNER;
        public static final /* enum */ HotspotPlace UPPER_RIGHT_CORNER;

        static {
            HotspotPlace hotspotPlace;
            HotspotPlace hotspotPlace2;
            HotspotPlace hotspotPlace3;
            HotspotPlace hotspotPlace4;
            HotspotPlace hotspotPlace5;
            HotspotPlace hotspotPlace6;
            HotspotPlace hotspotPlace7;
            HotspotPlace hotspotPlace8;
            HotspotPlace hotspotPlace9;
            HotspotPlace hotspotPlace10;
            NONE = hotspotPlace10 = new HotspotPlace();
            CENTER = hotspotPlace9 = new HotspotPlace();
            BOTTOM_CENTER = hotspotPlace8 = new HotspotPlace();
            TOP_CENTER = hotspotPlace7 = new HotspotPlace();
            RIGHT_CENTER = hotspotPlace6 = new HotspotPlace();
            LEFT_CENTER = hotspotPlace5 = new HotspotPlace();
            UPPER_RIGHT_CORNER = hotspotPlace4 = new HotspotPlace();
            LOWER_RIGHT_CORNER = hotspotPlace3 = new HotspotPlace();
            UPPER_LEFT_CORNER = hotspotPlace2 = new HotspotPlace();
            LOWER_LEFT_CORNER = hotspotPlace = new HotspotPlace();
            $VALUES = new HotspotPlace[]{hotspotPlace10, hotspotPlace9, hotspotPlace8, hotspotPlace7, hotspotPlace6, hotspotPlace5, hotspotPlace4, hotspotPlace3, hotspotPlace2, hotspotPlace};
        }

        public static HotspotPlace valueOf(String string2) {
            return Enum.valueOf(HotspotPlace.class, string2);
        }

        public static HotspotPlace[] values() {
            return (HotspotPlace[])$VALUES.clone();
        }
    }
}

