/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.marker.utils;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Paint;

public class ScreenUtils {
    public static int getPixels(float f) {
        return (int)(CanvasAdapter.getScale() * f);
    }

    public static class ClusterDrawable {
        private Paint mPaintBorder;
        private Paint mPaintCircle;
        private Paint mPaintText = CanvasAdapter.newPaint();
        private int mSize;
        private String mText;

        public ClusterDrawable(int n, int n2, int n3, String string2) {
            this.mPaintCircle = CanvasAdapter.newPaint();
            this.mPaintBorder = CanvasAdapter.newPaint();
            this.setup(n, n2, n3);
            this.setText(string2);
        }

        private void draw(Canvas canvas) {
            int n = this.mSize >> 1;
            int n2 = ScreenUtils.getPixels(2.0f);
            float f = n;
            float f2 = n - n2;
            canvas.drawCircle(f, f, f2, this.mPaintCircle);
            canvas.drawCircle(f, f, f2, this.mPaintBorder);
            canvas.drawText(this.mText, ((float)canvas.getWidth() - this.mPaintText.getTextWidth(this.mText)) * 0.5f, ((float)canvas.getHeight() + this.mPaintText.getTextHeight(this.mText)) * 0.5f, this.mPaintText);
        }

        private void setText(String string2) {
            this.mText = string2;
        }

        private void setup(int n, int n2, int n3) {
            this.mSize = ScreenUtils.getPixels(n);
            this.mPaintText.setTextSize(ScreenUtils.getPixels((int)((double)n * 0.6666666)));
            this.mPaintText.setColor(n2);
            this.mPaintCircle.setColor(n3);
            this.mPaintCircle.setStyle(Paint.Style.FILL);
            this.mPaintBorder.setColor(n2);
            this.mPaintBorder.setStyle(Paint.Style.STROKE);
            this.mPaintBorder.setStrokeWidth(CanvasAdapter.getScale() * 2.0f);
        }

        public Bitmap getBitmap() {
            int n = this.mSize;
            int n2 = n > 0 ? n : 1;
            if (n <= 0) {
                n = 1;
            }
            Bitmap bitmap = CanvasAdapter.newBitmap(n2, n, 0);
            Canvas canvas = CanvasAdapter.newCanvas();
            canvas.setBitmap(bitmap);
            this.draw(canvas);
            return bitmap;
        }
    }
}

