/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.marker.utils;

import org.oscim.layers.marker.utils.GrowingArrayUtils;

public class SparseIntArray
implements Cloneable {
    private int[] mKeys;
    private int mSize;
    private int[] mValues;

    public SparseIntArray(int n) {
        int n2 = n;
        if (n == 0) {
            n2 = 100;
        }
        int[] nArray = new int[n2];
        this.mKeys = nArray;
        this.mValues = new int[nArray.length];
        this.mSize = 0;
    }

    public void append(int n, int n2) {
        int n3 = this.mSize;
        if (n3 != 0 && n <= this.mKeys[n3 - 1]) {
            this.put(n, n2);
            return;
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, n3, n);
        this.mValues = GrowingArrayUtils.append(this.mValues, this.mSize, n2);
        ++this.mSize;
    }

    public void clear() {
        this.mSize = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SparseIntArray clone() {
        SparseIntArray sparseIntArray;
        Object var1_1 = null;
        try {
            sparseIntArray = (SparseIntArray)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return var1_1;
        }
        try {
            sparseIntArray.mKeys = (int[])this.mKeys.clone();
            sparseIntArray.mValues = (int[])this.mValues.clone();
            return sparseIntArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return sparseIntArray;
    }

    public void delete(int n) {
        if ((n = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n)) >= 0) {
            this.removeAt(n);
        }
    }

    public int get(int n) {
        return this.get(n, 0);
    }

    public int get(int n, int n2) {
        if ((n = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n)) < 0) {
            return n2;
        }
        return this.mValues[n];
    }

    public int indexOfKey(int n) {
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
    }

    public int indexOfValue(int n) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != n) continue;
            return i;
        }
        return -1;
    }

    public int keyAt(int n) {
        return this.mKeys[n];
    }

    public void put(int n, int n2) {
        int n3 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n3 >= 0) {
            this.mValues[n3] = n2;
        } else {
            this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, n3, n);
            this.mValues = GrowingArrayUtils.insert(this.mValues, this.mSize, n3, n2);
            ++this.mSize;
        }
    }

    public void removeAt(int n) {
        int[] nArray = this.mKeys;
        int n2 = n + 1;
        System.arraycopy(nArray, n2, nArray, n, this.mSize - n2);
        nArray = this.mValues;
        System.arraycopy(nArray, n2, nArray, n, this.mSize - n2);
        --this.mSize;
    }

    public void setValueAt(int n, int n2) {
        this.mValues[n] = n2;
    }

    public int size() {
        return this.mSize;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(this.mSize * 28);
        stringBuilder.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyAt(i));
            stringBuilder.append('=');
            stringBuilder.append(this.valueAt(i));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public int valueAt(int n) {
        return this.mValues[n];
    }

    static class ContainerHelpers {
        ContainerHelpers() {
        }

        static int binarySearch(int[] nArray, int n, int n2) {
            --n;
            int n3 = 0;
            while (n3 <= n) {
                int n4 = n3 + n >>> 1;
                int n5 = nArray[n4];
                if (n5 < n2) {
                    n3 = n4 + 1;
                    continue;
                }
                if (n5 > n2) {
                    n = n4 - 1;
                    continue;
                }
                return n4;
            }
            return n3;
        }

        static int binarySearch(long[] lArray, int n, long l) {
            --n;
            int n2 = 0;
            while (n2 <= n) {
                int n3 = n2 + n >>> 1;
                long l2 = lArray[n3] - l;
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                if (l3 < 0) {
                    n2 = n3 + 1;
                    continue;
                }
                if (l3 > 0) {
                    n = n3 - 1;
                    continue;
                }
                return n3;
            }
            return n2;
        }
    }
}

