/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileDistanceSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobQueue {
    static final Logger log = LoggerFactory.getLogger(JobQueue.class);
    private int mCurrentJob = 0;
    private MapTile[] mJobs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        synchronized (this) {
            MapTile[] mapTileArray = this.mJobs;
            if (mapTileArray == null) {
                this.mCurrentJob = 0;
                return;
            }
            int n = this.mCurrentJob;
            int n2 = mapTileArray.length;
            while (true) {
                if (n >= n2) {
                    this.mCurrentJob = 0;
                    this.mJobs = null;
                    return;
                }
                MapTile mapTile = mapTileArray[n];
                if (mapTile.state(18)) {
                    mapTile.setState((byte)1);
                } else {
                    log.error("Wrong tile in queue {} {}", (Object)mapTile, (Object)mapTile.state());
                }
                mapTileArray[n] = null;
                ++n;
            }
        }
    }

    public boolean isEmpty() {
        synchronized (this) {
            MapTile[] mapTileArray = this.mJobs;
            boolean bl = mapTileArray == null;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MapTile poll() {
        synchronized (this) {
            int n;
            MapTile[] mapTileArray = this.mJobs;
            if (mapTileArray == null) {
                return null;
            }
            if (this.mCurrentJob == 0 && (n = mapTileArray.length) > 1) {
                TileDistanceSort.sort(mapTileArray, 0, n);
            }
            mapTileArray = this.mJobs;
            n = this.mCurrentJob;
            MapTile mapTile = mapTileArray[n];
            mapTileArray[n] = null;
            this.mCurrentJob = ++n;
            if (n == mapTileArray.length) {
                this.mJobs = null;
            }
            return mapTile;
        }
    }

    public void setJobs(MapTile[] mapTileArray) {
        synchronized (this) {
            this.mJobs = mapTileArray;
            this.mCurrentJob = 0;
            return;
        }
    }
}

