/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.core.MercatorProjection;
import org.oscim.core.Tile;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.quadtree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTile
extends Tile {
    public static final int PROXY_CHILD00 = 1;
    public static final int PROXY_CHILD01 = 2;
    public static final int PROXY_CHILD10 = 4;
    public static final int PROXY_CHILD11 = 8;
    public static final int PROXY_GRAMPA = 32;
    public static final int PROXY_HOLDER = 64;
    public static final int PROXY_PARENT = 16;
    static final Logger log = LoggerFactory.getLogger(MapTile.class);
    public TileData data;
    public float distance;
    public long fadeTime;
    MapTile holder;
    public boolean isVisible;
    int lastDraw = 0;
    private int locked = 0;
    public final TileNode node;
    private int proxy = 0;
    private int refs = 0;
    byte state = (byte)1;
    public final double x;
    public final double y;

    public MapTile(int n, int n2, int n3) {
        this(null, n, n2, n3);
    }

    public MapTile(TileNode tileNode, int n, int n2, int n3) {
        super(n, n2, (byte)n3);
        double d = n;
        double d2 = 1 << n3;
        this.x = d / d2;
        this.y = (double)n2 / d2;
        this.node = tileNode;
    }

    public static int depthOffset(MapTile mapTile) {
        return mapTile.tileX % 4 + mapTile.tileY % 4 * 4 + 1;
    }

    public void addData(Object object, TileData tileData) {
        tileData.id = object;
        object = this.data;
        if (object != null) {
            tileData.next = ((TileData)object).next;
            this.data.next = tileData;
        } else {
            this.data = tileData;
        }
    }

    protected void clear() {
        TileData tileData;
        while ((tileData = this.data) != null) {
            tileData.dispose();
            this.data = (TileData)this.data.next;
        }
        this.setState((byte)1);
    }

    public RenderBuckets getBuckets() {
        TileData tileData = this.data;
        if (!(tileData instanceof RenderBuckets)) {
            return null;
        }
        return (RenderBuckets)tileData;
    }

    public TileData getData(Object object) {
        TileData tileData = this.data;
        while (tileData != null) {
            if (tileData.id == object) {
                return tileData;
            }
            tileData = (TileData)tileData.next;
        }
        return null;
    }

    public float getGroundScale() {
        return (float)MercatorProjection.groundResolutionWithScale(MercatorProjection.toLatitude(this.y), 1 << this.zoomLevel);
    }

    public MapTile getParent() {
        if ((this.proxy & 0x10) == 0) {
            return null;
        }
        return (MapTile)((TileNode)this.node.parent).item;
    }

    public MapTile getProxy(int n, byte by) {
        if ((this.proxy & n) == 0) {
            return null;
        }
        Object object = n != 1 ? (n != 2 ? (n != 4 ? (n != 8 ? (n != 16 ? (n != 32 ? (n != 64 ? null : this.holder) : (MapTile)((TileNode)this.node.parent).parent()) : (MapTile)this.node.parent()) : (MapTile)this.node.child(3)) : (MapTile)this.node.child(2)) : (MapTile)this.node.child(1)) : (MapTile)this.node.child(0);
        if (object != null && (by & ((MapTile)object).state) != 0) {
            return object;
        }
        return null;
    }

    public MapTile getProxyChild(int n, byte by) {
        if ((this.proxy & 1 << n) == 0) {
            return null;
        }
        MapTile mapTile = (MapTile)this.node.child(n);
        if (mapTile != null && (by & mapTile.state) != 0) {
            return mapTile;
        }
        return null;
    }

    public int getState() {
        return this.state;
    }

    public boolean hasProxy(int n) {
        boolean bl = (n & this.proxy) != 0;
        return bl;
    }

    public boolean isActive() {
        byte by = this.state;
        boolean bl = true;
        if (by <= 1) {
            bl = false;
        }
        return bl;
    }

    boolean isLocked() {
        boolean bl = this.locked > 0 || this.refs > 0;
        return bl;
    }

    void lock() {
        MapTile mapTile;
        if (this.state == 64) {
            log.debug("Locking dead tile {}", (Object)this);
            return;
        }
        int n = this.locked;
        this.locked = n + 1;
        if (n > 0) {
            return;
        }
        for (n = 0; n < 4; ++n) {
            mapTile = (MapTile)this.node.child(n);
            if (mapTile == null || !mapTile.state(12)) continue;
            this.proxy |= 1 << n;
            ++mapTile.refs;
        }
        if (this.node.isRoot()) {
            return;
        }
        mapTile = (MapTile)this.node.parent();
        if (mapTile != null && mapTile.state(12)) {
            this.proxy |= 0x10;
            ++mapTile.refs;
        }
        if (((TileNode)this.node.parent).isRoot()) {
            return;
        }
        mapTile = (MapTile)((TileNode)this.node.parent).parent();
        if (mapTile != null && mapTile.state(12)) {
            this.proxy |= 0x20;
            ++mapTile.refs;
        }
    }

    public TileData removeData(Object object) {
        TileData tileData = this.data;
        if (tileData == null) {
            return null;
        }
        if (tileData.id == object) {
            this.data = (TileData)this.data.next;
            return tileData;
        }
        Inlist inlist = this.data.next;
        while (true) {
            TileData tileData2 = tileData;
            tileData = (TileData)inlist;
            if (tileData == null) break;
            if (tileData.id == object) {
                tileData2.next = tileData.next;
                return tileData;
            }
            inlist = tileData.next;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setState(byte by) {
        synchronized (this) {
            byte by2 = this.state;
            if (by2 == by) {
                return;
            }
            if (by2 == 64) {
                return;
            }
            if (by == 1) {
                this.state = by;
                return;
            }
            if (by != 2) {
                if (by != 4) {
                    if (by != 8) {
                        if (by != 16) {
                            if (by != 64) {
                                return;
                            }
                            this.state = by;
                            return;
                        }
                        if (by2 == 2) {
                            this.state = by;
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Cancel <= ");
                        stringBuilder.append(this.state());
                        stringBuilder.append(" ");
                        stringBuilder.append(this);
                        IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
                        throw illegalStateException;
                    }
                    if (by2 == 4) {
                        this.state = by;
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Ready <= ");
                    stringBuilder.append(this.state());
                    stringBuilder.append(" ");
                    stringBuilder.append(this);
                    IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
                    throw illegalStateException;
                }
                if (by2 == 2) {
                    this.state = by;
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("NewData <= ");
                stringBuilder.append(this.state());
                stringBuilder.append(" ");
                stringBuilder.append(this);
                IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
                throw illegalStateException;
            }
            if (by2 == 1) {
                this.state = by;
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Loading <= ");
            stringBuilder.append(this.state());
            stringBuilder.append(" ");
            stringBuilder.append(this);
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
            throw illegalStateException;
        }
    }

    public String state() {
        byte by = this.state;
        if (by != 1) {
            if (by != 2) {
                if (by != 4) {
                    if (by != 8) {
                        if (by != 16) {
                            if (by != 64) {
                                return "";
                            }
                            return "Dead";
                        }
                        return "Cancel";
                    }
                    return "Ready";
                }
                return "Data";
            }
            return "Loading";
        }
        return "None";
    }

    public boolean state(int n) {
        boolean bl = (n & this.state) != 0;
        return bl;
    }

    void unlock() {
        MapTile mapTile;
        int n;
        this.locked = n = this.locked - 1;
        if (n > 0) {
            return;
        }
        TileNode tileNode = (TileNode)this.node.parent;
        if ((this.proxy & 0x10) != 0) {
            mapTile = (MapTile)tileNode.item;
            --mapTile.refs;
        }
        if ((this.proxy & 0x20) != 0) {
            mapTile = (MapTile)((TileNode)tileNode.parent).item;
            --mapTile.refs;
        }
        for (n = 0; n < 4; ++n) {
            if ((this.proxy & 1 << n) == 0) continue;
            mapTile = (MapTile)this.node.child(n);
            --mapTile.refs;
        }
        this.proxy = 0;
        if (this.state == 64) {
            log.debug("Unlock dead tile {}", (Object)this);
            this.clear();
        }
    }

    public static final class State {
        public static final byte CANCEL = 16;
        public static final byte DEADBEEF = 64;
        public static final byte LOADING = 2;
        public static final byte NEW_DATA = 4;
        public static final byte NONE = 1;
        public static final byte READY = 8;
    }

    public static abstract class TileData
    extends Inlist<TileData> {
        Object id;

        protected abstract void dispose();

        @Override
        public TileData next() {
            return (TileData)this.next;
        }
    }

    public static class TileNode
    extends TreeNode<TileNode, MapTile> {
    }
}

