/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import java.util.Comparator;
import org.oscim.layers.tile.MapTile;
import org.oscim.utils.TimSort;

public class TileDistanceSort
extends TimSort<MapTile> {
    static final Comparator<MapTile> DistanceComparator;
    static TileDistanceSort INSTANCE;

    static {
        INSTANCE = new TileDistanceSort();
        DistanceComparator = new Comparator<MapTile>(){

            @Override
            public int compare(MapTile mapTile, MapTile mapTile2) {
                if (mapTile == null) {
                    if (mapTile2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (mapTile2 == null) {
                    return -1;
                }
                if (mapTile.distance < mapTile2.distance) {
                    return -1;
                }
                if (mapTile.distance > mapTile2.distance) {
                    return 1;
                }
                return 0;
            }
        };
    }

    private TileDistanceSort() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void sort(MapTile[] mapTileArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        TileDistanceSort tileDistanceSort = INSTANCE;
        synchronized (tileDistanceSort) {
            INSTANCE.doSort(mapTileArray, DistanceComparator, n, n2);
            return;
        }
    }
}

