/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.layers.Layer;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.TileRenderer;
import org.oscim.map.Map;
import org.oscim.utils.PausableThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TileLayer
extends Layer
implements Map.UpdateListener {
    static final Logger log = LoggerFactory.getLogger(TileLayer.class);
    private int mNumLoaders = 4;
    protected TileLoader[] mTileLoader;
    protected final TileManager mTileManager;

    public TileLayer(Map map, TileManager tileManager) {
        super(map);
        this.mTileManager = tileManager;
    }

    public TileLayer(Map map, TileManager tileManager, TileRenderer tileRenderer) {
        super(map);
        tileRenderer.setTileManager(tileManager);
        this.mTileManager = tileManager;
        this.mRenderer = tileRenderer;
    }

    protected abstract TileLoader createLoader();

    public TileManager getManager() {
        return this.mTileManager;
    }

    protected int getNumLoaders() {
        return this.mNumLoaders;
    }

    protected void initLoader(int n) {
        this.mTileLoader = new TileLoader[n];
        for (int i = 0; i < n; ++i) {
            this.mTileLoader[i] = this.createLoader();
            this.mTileLoader[i].start();
        }
    }

    void notifyLoaders() {
        TileLoader[] tileLoaderArray = this.mTileLoader;
        int n = tileLoaderArray.length;
        for (int i = 0; i < n; ++i) {
            tileLoaderArray[i].go();
        }
    }

    @Override
    public void onDetach() {
        for (TileLoader tileLoader : this.mTileLoader) {
            tileLoader.pause();
            tileLoader.finish();
            tileLoader.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onMapEvent(Event object, MapPosition mapPosition) {
        if (object == Map.CLEAR_EVENT) {
            object = this.mRenderer;
            synchronized (object) {
                this.tileRenderer().clearTiles();
                this.mTileManager.init();
            }
            if (!this.mTileManager.update(mapPosition)) return;
            this.notifyLoaders();
            return;
        }
        if (object != Map.POSITION_EVENT) return;
        if (!this.mTileManager.update(mapPosition)) return;
        this.notifyLoaders();
    }

    protected void pauseLoaders(boolean bl) {
        TileLoader[] tileLoaderArray;
        int n;
        Object object = this.mTileLoader;
        int n2 = ((TileLoader[])object).length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            tileLoaderArray = object[n];
            tileLoaderArray.cancel();
            if (tileLoaderArray.isPausing()) continue;
            tileLoaderArray.pause();
        }
        if (!bl) {
            return;
        }
        tileLoaderArray = this.mTileLoader;
        n2 = tileLoaderArray.length;
        for (n = n3; n < n2; ++n) {
            object = tileLoaderArray[n];
            if (((PausableThread)object).isPausing()) continue;
            ((PausableThread)object).awaitPausing();
        }
    }

    protected void resumeLoaders() {
        TileLoader[] tileLoaderArray = this.mTileLoader;
        int n = tileLoaderArray.length;
        for (int i = 0; i < n; ++i) {
            tileLoaderArray[i].proceed();
        }
    }

    public void setNumLoaders(int n) {
        this.mNumLoaders = n;
    }

    protected void setRenderer(TileRenderer tileRenderer) {
        tileRenderer.setTileManager(this.mTileManager);
        this.mRenderer = tileRenderer;
    }

    public TileRenderer tileRenderer() {
        return (TileRenderer)this.mRenderer;
    }
}

