/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.MapElement;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileManager;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.QueryResult;
import org.oscim.utils.PausableThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TileLoader
extends PausableThread
implements ITileDataSink {
    private static int id;
    static final Logger log;
    private final String THREAD_NAME;
    protected MapTile mTile;
    private final TileManager mTileManager;

    static {
        log = LoggerFactory.getLogger(TileLoader.class);
    }

    public TileLoader(TileManager object) {
        this.mTileManager = object;
        object = new StringBuilder();
        ((StringBuilder)object).append("TileLoader");
        int n = id;
        id = n + 1;
        ((StringBuilder)object).append(n);
        this.THREAD_NAME = ((StringBuilder)object).toString();
    }

    public abstract void cancel();

    @Override
    public void completed(QueryResult queryResult) {
        QueryResult queryResult2;
        block2: {
            block3: {
                boolean bl = queryResult == QueryResult.SUCCESS;
                queryResult2 = queryResult;
                if (!bl) break block2;
                if (this.isCanceled()) break block3;
                queryResult2 = queryResult;
                if (!this.isInterrupted()) break block2;
            }
            queryResult2 = QueryResult.FAILED;
        }
        this.mTileManager.jobCompleted(this.mTile, queryResult2);
        this.mTile = null;
    }

    public abstract void dispose();

    @Override
    protected void doWork() {
        MapTile mapTile;
        this.mTile = mapTile = this.mTileManager.getTileJob();
        if (mapTile == null) {
            return;
        }
        try {
            this.loadTile(mapTile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.completed(QueryResult.FAILED);
        }
    }

    @Override
    protected String getThreadName() {
        return this.THREAD_NAME;
    }

    @Override
    protected int getThreadPriority() {
        return 3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void go() {
        synchronized (this) {
            this.notify();
            return;
        }
    }

    @Override
    protected boolean hasWork() {
        return this.mTileManager.hasTileJobs();
    }

    protected abstract boolean loadTile(MapTile var1);

    @Override
    public void process(MapElement mapElement) {
    }

    @Override
    public void setTileImage(Bitmap bitmap) {
    }
}

