/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import java.util.ArrayList;
import java.util.Arrays;
import org.oscim.core.MapPosition;
import org.oscim.core.Tile;
import org.oscim.event.Event;
import org.oscim.event.EventDispatcher;
import org.oscim.event.EventListener;
import org.oscim.layers.tile.JobQueue;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileDistanceSort;
import org.oscim.layers.tile.TileSet;
import org.oscim.map.Map;
import org.oscim.map.Viewport;
import org.oscim.renderer.BufferObject;
import org.oscim.tiling.QueryResult;
import org.oscim.utils.FastMath;
import org.oscim.utils.ScanBox;
import org.oscim.utils.quadtree.TileIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileManager {
    private static final int CACHE_CLEAR_THRESHOLD = 10;
    private static final int CACHE_THRESHOLD = 25;
    private static final int MAX_TILES_IN_QUEUE = 20;
    public static final Event TILE_LOADED;
    public static final Event TILE_REMOVED;
    static final boolean dbg = false;
    static final Logger log;
    public final EventDispatcher<Listener, MapTile> events;
    private final JobQueue jobQueue;
    private final int mCacheLimit;
    private int mCacheReduce;
    private TileSet mCurrentTiles;
    private final TileIndex<MapTile.TileNode, MapTile> mIndex;
    private final ArrayList<MapTile> mJobs;
    private double mLevelDownThreshold = 2.0;
    private double mLevelUpThreshold = 1.0;
    private boolean mLoadParent;
    private final Map mMap;
    private final float[] mMapPlane;
    private int mMaxZoom;
    private int mMinZoom;
    TileSet mNewTiles;
    private int mPrevZoomlevel;
    private final ScanBox mScanBox;
    private final Object mTilelock = new Object();
    private MapTile[] mTiles;
    private int mTilesCount;
    private int mTilesEnd;
    private int mTilesToUpload;
    private int mUpdateSerial;
    private final Viewport mViewport;
    private int[] mZoomTable;

    static {
        log = LoggerFactory.getLogger(TileManager.class);
        TILE_LOADED = new Event();
        TILE_REMOVED = new Event();
    }

    public TileManager(Map map, int n) {
        this.mMapPlane = new float[8];
        this.mIndex = new TileIndex<MapTile.TileNode, MapTile>(){

            @Override
            public MapTile.TileNode create() {
                return new MapTile.TileNode();
            }

            @Override
            public void removeItem(MapTile mapTile) {
                if (mapTile.node != null) {
                    super.remove(mapTile.node);
                    mapTile.node.item = null;
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Already removed: ");
                stringBuilder.append(mapTile);
                throw new IllegalStateException(stringBuilder.toString());
            }
        };
        this.events = new EventDispatcher<Listener, MapTile>(){

            @Override
            public void tell(Listener listener, Event event, MapTile mapTile) {
                listener.onTileManagerEvent(event, mapTile);
            }
        };
        this.mScanBox = new ScanBox(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            protected void setVisible(int n, int n2, int n3) {
                MapTile[] mapTileArray = TileManager.this.mNewTiles.tiles;
                int n4 = TileManager.this.mNewTiles.cnt;
                int n5 = mapTileArray.length;
                int n6 = 1 << this.mZoom;
                while (true) {
                    int n7;
                    block8: {
                        MapTile mapTile;
                        int n8;
                        int n9;
                        MapTile mapTile2;
                        block7: {
                            block4: {
                                block6: {
                                    block5: {
                                        if (n2 >= n3) break block4;
                                        mapTile2 = null;
                                        if (n4 != n5) break block5;
                                        log.debug("too many tiles {}", (Object)n5);
                                        break block4;
                                    }
                                    if (n2 < 0 || n2 >= n6) break block6;
                                    n9 = n2;
                                    break block7;
                                }
                                n8 = n2 < 0 ? n6 + n2 : n2 - n6;
                                n7 = n4;
                                if (n8 < 0) break block8;
                                n9 = n8;
                                if (n8 < n6) break block7;
                                n7 = n4;
                                break block8;
                            }
                            TileManager.this.mNewTiles.cnt = n4;
                            return;
                        }
                        n8 = 0;
                        while (true) {
                            mapTile = mapTile2;
                            if (n8 >= n4) break;
                            if (mapTileArray[n8].tileX == n9 && mapTileArray[n8].tileY == n) {
                                mapTile = mapTileArray[n8];
                                break;
                            }
                            ++n8;
                        }
                        n7 = n4;
                        if (mapTile == null) {
                            mapTileArray[n4] = TileManager.this.addTile(n9, n, this.mZoom);
                            n7 = n4 + 1;
                        }
                    }
                    ++n2;
                    n4 = n7;
                }
            }
        };
        this.mMap = map;
        this.mMaxZoom = 20;
        this.mMinZoom = 0;
        this.mCacheLimit = n;
        this.mCacheReduce = 0;
        this.mViewport = map.viewport();
        this.jobQueue = new JobQueue();
        this.mJobs = new ArrayList();
        this.mTiles = new MapTile[n];
        this.mTilesEnd = 0;
        this.mTilesToUpload = 0;
        this.mUpdateSerial = 0;
    }

    static /* synthetic */ int access$008(TileManager tileManager) {
        int n = tileManager.mTilesToUpload;
        tileManager.mTilesToUpload = n + 1;
        return n;
    }

    private void addToCache(MapTile mapTile) {
        int n = this.mTilesEnd;
        MapTile[] mapTileArray = this.mTiles;
        if (n == mapTileArray.length) {
            if (n > this.mTilesCount) {
                TileDistanceSort.sort(mapTileArray, 0, n);
                this.mTilesEnd = this.mTilesCount;
            }
            if ((n = this.mTilesEnd) == this.mTiles.length) {
                log.debug("realloc tiles {}", (Object)n);
                mapTileArray = this.mTiles;
                MapTile[] mapTileArray2 = new MapTile[mapTileArray.length + 20];
                System.arraycopy(mapTileArray, 0, mapTileArray2, 0, this.mTilesCount);
                this.mTiles = mapTileArray2;
            }
        }
        mapTileArray = this.mTiles;
        n = this.mTilesEnd;
        this.mTilesEnd = n + 1;
        mapTileArray[n] = mapTile;
        ++this.mTilesCount;
    }

    private void limitCache(MapPosition object, int n) {
        int n2;
        int n3;
        MapTile[] mapTileArray = this.mTiles;
        int n4 = 0;
        int n5 = n;
        n = n4;
        for (n3 = 0; n3 < (n4 = this.mTilesEnd); ++n3) {
            MapTile mapTile = mapTileArray[n3];
            if (mapTile == null) {
                n2 = n5;
            } else {
                n4 = n;
                if (mapTile.state(4)) {
                    n4 = n + 1;
                }
                if (mapTile.state(64)) {
                    log.debug("found DEADBEEF {}", (Object)mapTile);
                    mapTile.clear();
                    mapTileArray[n3] = null;
                    n = n4;
                    n2 = n5;
                } else {
                    n = n4;
                    n2 = n5;
                    if (mapTile.state(1)) {
                        n = n4;
                        n2 = n5;
                        if (this.removeFromCache(mapTile)) {
                            mapTileArray[n3] = null;
                            n2 = n5 - 1;
                            n = n4;
                        }
                    }
                }
            }
            n5 = n2;
        }
        if (n5 < 10 && n < 20) {
            return;
        }
        TileManager.updateDistances(mapTileArray, n4, (MapPosition)object);
        TileDistanceSort.sort(mapTileArray, 0, this.mTilesEnd);
        n4 = this.mTilesCount;
        this.mTilesEnd = n4--;
        n3 = n5;
        while (n4 >= 0 && n3 > 0) {
            object = mapTileArray[n4];
            if (((MapTile)object).isLocked()) {
                n2 = n3;
            } else if (((MapTile)object).state(16)) {
                n2 = n3;
            } else if (((MapTile)object).state(2)) {
                ((MapTile)object).setState((byte)16);
                n2 = n3;
            } else {
                n5 = n;
                if (((MapTile)object).state(4)) {
                    n5 = n - 1;
                }
                if (!((MapTile)object).state(12)) {
                    log.error("stuff that should be here! {} {}", object, (Object)((MapTile)object).state());
                }
                n = n5;
                n2 = n3;
                if (this.removeFromCache((MapTile)object)) {
                    mapTileArray[n4] = null;
                    n2 = n3 - 1;
                    n = n5;
                }
            }
            --n4;
            n3 = n2;
        }
        n4 = n;
        for (n5 = this.mTilesCount - 1; n5 >= 0 && n4 > 20; --n5) {
            object = mapTileArray[n5];
            n = n4;
            if (object != null) {
                n = n4;
                if (((MapTile)object).state(4)) {
                    n = n4;
                    if (this.removeFromCache((MapTile)object)) {
                        mapTileArray[n5] = null;
                        n = n4 - 1;
                    }
                }
            }
            n4 = n;
        }
        this.mTilesToUpload = n4;
    }

    private boolean removeFromCache(MapTile mapTile) {
        if (mapTile.isLocked()) {
            return false;
        }
        if (mapTile.state(12)) {
            this.events.fire(TILE_REMOVED, mapTile);
        }
        mapTile.clear();
        this.mIndex.removeItem(mapTile);
        --this.mTilesCount;
        return true;
    }

    private static void updateDistances(MapTile[] mapTileArray, int n, MapPosition mapPosition) {
        double d = mapPosition.x;
        double d2 = 0x100000;
        long l = (long)(d * d2);
        long l2 = (long)(mapPosition.y * d2);
        for (int i = 0; i < n; ++i) {
            long l3;
            long l4;
            MapTile mapTile = mapTileArray[i];
            if (mapTile == null) continue;
            int n2 = 20 - mapTile.zoomLevel;
            if (n2 == 0) {
                l4 = (long)mapTile.tileX - l;
                l3 = (long)mapTile.tileY - l2;
            } else {
                l4 = (long)mapTile.tileX - (l >> n2);
                l3 = (long)mapTile.tileY - (l2 >> n2);
            }
            int n3 = mapPosition.zoomLevel - mapTile.zoomLevel;
            if (n3 == 0) {
                n2 = 1;
            } else {
                n2 = n3;
                if (n3 < -1) {
                    n2 = (int)((double)n3 * 0.75);
                }
            }
            mapTile.distance = (l4 * l4 + l3 * l3) * (long)(n2 * n2);
        }
    }

    MapTile addTile(int n, int n2, int n3) {
        Object object;
        Object object2 = this.mIndex.getTile(n, n2, n3);
        if (object2 == null) {
            object2 = this.mIndex.add(n, n2, n3);
            ((MapTile.TileNode)object2).item = object = new MapTile((MapTile.TileNode)object2, n, n2, n3);
            object2 = (MapTile)object;
            ((MapTile)object).setState((byte)2);
            this.mJobs.add((MapTile)object);
            this.addToCache((MapTile)object);
        } else {
            object = object2;
            if (!((MapTile)object2).isActive()) {
                ((MapTile)object2).setState((byte)2);
                this.mJobs.add((MapTile)object2);
                object = object2;
            }
        }
        if (this.mLoadParent && n3 > this.mMinZoom && this.mZoomTable == null) {
            object2 = (MapTile)((MapTile)object).node.parent();
            if (object2 == null) {
                object2 = this.mIndex;
                Object object3 = ((TileIndex)object2).add(n >>= 1, n2 >>= 1, --n3);
                ((MapTile.TileNode)object3).item = object2 = new MapTile((MapTile.TileNode)object3, n, n2, n3);
                object3 = (MapTile)object2;
                this.addToCache((MapTile)object2);
                ((MapTile)object2).setState((byte)2);
                this.mJobs.add((MapTile)object2);
            } else if (!((MapTile)object2).isActive()) {
                ((MapTile)object2).setState((byte)2);
                this.mJobs.add((MapTile)object2);
            }
        }
        return object;
    }

    public void clearJobs() {
        this.jobQueue.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getActiveTiles(TileSet tileSet) {
        if (this.mCurrentTiles == null) {
            return false;
        }
        if (tileSet == null) {
            return false;
        }
        if (tileSet.serial == this.mUpdateSerial) {
            return false;
        }
        Object object = this.mTilelock;
        synchronized (object) {
            tileSet.setTiles(this.mCurrentTiles);
            tileSet.serial = this.mUpdateSerial;
            return true;
        }
    }

    public MapTile getTile(int n, int n2, byte by) {
        return this.mIndex.getTile(n, n2, by);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MapTile getTile(int n, int n2, int n3) {
        Object object = this.mTilelock;
        synchronized (object) {
            return this.mIndex.getTile(n, n2, n3);
        }
    }

    public MapTile getTileJob() {
        return this.jobQueue.poll();
    }

    public boolean hasTileJobs() {
        return this.jobQueue.isEmpty() ^ true;
    }

    public void init() {
        int n;
        Object object = this.mCurrentTiles;
        if (object != null) {
            ((TileSet)object).releaseTiles();
        }
        this.mIndex.drop();
        for (n = 0; n < this.mTilesEnd; ++n) {
            object = this.mTiles[n];
            if (object == null) continue;
            if (!((MapTile)object).isLocked()) {
                ((MapTile)object).clear();
            }
            ((MapTile)object).setState((byte)64);
        }
        Arrays.fill(this.mTiles, null);
        this.mTilesEnd = 0;
        this.mTilesCount = 0;
        n = Math.max(this.mMap.getWidth(), this.mMap.getHeight());
        int n2 = Tile.SIZE >> 1;
        n = n * n / (n2 * n2) * 4;
        this.mNewTiles = new TileSet(n);
        this.mCurrentTiles = new TileSet(n);
    }

    public void jobCompleted(MapTile mapTile, QueryResult queryResult) {
        this.mMap.post(new JobCompletedEvent(mapTile, queryResult));
        if (mapTile.isLocked()) {
            if (queryResult == QueryResult.DELAYED && mapTile.isLocked()) {
                this.mMap.updateMap(false);
            } else {
                this.mMap.render();
            }
        }
    }

    public void setZoomLevel(int n, int n2) {
        this.mMinZoom = n;
        this.mMaxZoom = n2;
    }

    public void setZoomTable(int[] nArray) {
        this.mZoomTable = nArray;
    }

    public void setZoomThresholds(float f, float f2) {
        this.mLevelDownThreshold = FastMath.clamp(f, 1.0f, 2.0f);
        this.mLevelUpThreshold = FastMath.clamp(f2, 1.0f, 2.0f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean update(MapPosition mapPosition) {
        int n;
        Object object;
        int n2;
        int n3;
        Object object2;
        block25: {
            block23: {
                block26: {
                    double d;
                    block24: {
                        object2 = this.mNewTiles;
                        if (object2 == null || object2.tiles.length == 0) {
                            this.mPrevZoomlevel = mapPosition.zoomLevel;
                            this.init();
                        }
                        this.jobQueue.clear();
                        if (mapPosition.zoomLevel < this.mMinZoom) {
                            if (this.mCurrentTiles.cnt > 0 && mapPosition.zoomLevel < this.mMinZoom - 4) {
                                object2 = this.mTilelock;
                                synchronized (object2) {
                                    this.mCurrentTiles.releaseTiles();
                                }
                            }
                            return false;
                        }
                        n3 = FastMath.clamp(mapPosition.zoomLevel, this.mMinZoom, this.mMaxZoom);
                        object2 = this.mZoomTable;
                        if (object2 != null) break block23;
                        d = mapPosition.scale / (double)(1 << n3);
                        boolean bl = d < 1.5;
                        this.mLoadParent = bl;
                        n2 = this.mPrevZoomlevel;
                        object = n3 - n2;
                        if (object != 1) break block24;
                        n = n3;
                        if (!(d < this.mLevelUpThreshold)) break block25;
                        this.mLoadParent = false;
                        break block26;
                    }
                    n = n3;
                    if (object != -1) break block25;
                    n = n3;
                    if (!(d > this.mLevelDownThreshold)) break block25;
                    this.mLoadParent = true;
                }
                n = n2;
                break block25;
            }
            this.mLoadParent = false;
            int n4 = ((Object)object2).length;
            n = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                Object object3 = object2[n2];
                object = n;
                if (object3 <= n3) {
                    object = n;
                    if (object3 > n) {
                        object = object3;
                    }
                }
                n = object;
            }
            if (n == 0) {
                return false;
            }
        }
        this.mPrevZoomlevel = n;
        this.mViewport.getMapExtents(this.mMapPlane, Tile.SIZE / 2);
        this.mNewTiles.cnt = 0;
        this.mScanBox.scan(mapPosition.x, mapPosition.y, mapPosition.scale, n, this.mMapPlane);
        Object object4 = this.mNewTiles.tiles;
        n3 = this.mNewTiles.cnt;
        object2 = this.mCurrentTiles.tiles;
        n = n3 != this.mCurrentTiles.cnt ? 1 : 0;
        Arrays.sort(object4, 0, n3, TileSet.coordComparator);
        object = n;
        if (n == 0) {
            n2 = 0;
            while (true) {
                object = n;
                if (n2 >= n3) break;
                if (object4[n2] != object2[n2]) {
                    object = 1;
                    break;
                }
                ++n2;
            }
        }
        if (object != 0) {
            object2 = this.mTilelock;
            synchronized (object2) {
                this.mNewTiles.lockTiles();
                this.mCurrentTiles.releaseTiles();
                object4 = this.mCurrentTiles;
                this.mCurrentTiles = this.mNewTiles;
                this.mNewTiles = object4;
                ++this.mUpdateSerial;
            }
            this.mMap.render();
        }
        if (this.mJobs.isEmpty()) {
            return false;
        }
        object2 = new MapTile[this.mJobs.size()];
        object2 = this.mJobs.toArray((T[])object2);
        TileManager.updateDistances(object2, ((MapTile[])object2).length, mapPosition);
        this.jobQueue.setJobs((MapTile[])object2);
        this.mJobs.clear();
        if (this.mCacheReduce < this.mCacheLimit / 2) {
            this.mCacheReduce = BufferObject.isMaxFill() ? (this.mCacheReduce += 10) : 0;
        }
        if ((n = this.mTilesCount - (this.mCacheLimit - this.mCacheReduce)) > 25 || this.mTilesToUpload > 20) {
            object2 = this.mTilelock;
            synchronized (object2) {
                this.limitCache(mapPosition, n);
            }
        }
        return true;
    }

    class JobCompletedEvent
    implements Runnable {
        final QueryResult result;
        final MapTile tile;

        public JobCompletedEvent(MapTile mapTile, QueryResult queryResult) {
            this.tile = mapTile;
            this.result = queryResult;
        }

        @Override
        public void run() {
            if (this.result == QueryResult.SUCCESS && this.tile.state(2)) {
                this.tile.setState((byte)4);
                TileManager.this.events.fire(TILE_LOADED, this.tile);
                TileManager.access$008(TileManager.this);
                return;
            }
            Logger logger = log;
            MapTile mapTile = this.tile;
            logger.debug("Load: {} {} state:{}", new Object[]{mapTile, this.result, mapTile.state()});
            if (this.tile.state(64)) {
                this.tile.clear();
                return;
            }
            this.tile.clear();
        }
    }

    public static interface Listener
    extends EventListener {
        public void onTileManagerEvent(Event var1, MapTile var2);
    }
}

