/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.TileSet;
import org.oscim.renderer.BufferObject;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.utils.ScanBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TileRenderer
extends LayerRenderer {
    protected static final float FADE_TIME = 500.0f;
    protected static final int MAX_TILE_LOAD = 8;
    static final Logger log = LoggerFactory.getLogger(TileRenderer.class);
    private float mAlpha = 1.0f;
    protected final TileSet mDrawTiles;
    protected float mLayerAlpha;
    private int mOverdraw = 0;
    protected int mOverdrawColor;
    protected int mProxyTileCnt;
    private final ScanBox mScanBox;
    private TileManager mTileManager;
    private int mUploadSerial = 0;
    private final Object tilelock = new Object();

    public TileRenderer() {
        this.mScanBox = new ScanBox(){

            @Override
            protected void setVisible(int n, int n2, int n3) {
                Object object;
                int n4;
                MapTile[] mapTileArray = TileRenderer.this.mDrawTiles.tiles;
                int n5 = TileRenderer.this.mDrawTiles.cnt;
                for (n4 = 0; n4 < n5; ++n4) {
                    object = mapTileArray[n4];
                    if (((MapTile)object).tileY != n || ((MapTile)object).tileX < n2 || ((MapTile)object).tileX >= n3) continue;
                    ((MapTile)object).isVisible = true;
                }
                int n6 = 1 << this.mZoom;
                n4 = n2;
                if (n2 >= 0) {
                    n4 = n2;
                    if (n3 < n6) {
                        return;
                    }
                }
                while (n4 < n3) {
                    block9: {
                        if ((n4 < 0 || n4 >= n6) && (n2 = n4 < 0 ? n6 + n4 : n4 - n6) >= 0 && n2 < n6) {
                            block10: {
                                int n7;
                                for (n7 = n5; n7 < TileRenderer.this.mProxyTileCnt + n5; ++n7) {
                                    if (mapTileArray[n7].tileX != n4 || mapTileArray[n7].tileY != n) {
                                        continue;
                                    }
                                    break block9;
                                }
                                for (n7 = 0; n7 < n5; ++n7) {
                                    if (mapTileArray[n7].tileX != n2 || mapTileArray[n7].tileY != n) continue;
                                    object = mapTileArray[n7];
                                    break block10;
                                }
                                object = null;
                            }
                            if (object != null) {
                                if (TileRenderer.this.mProxyTileCnt + n5 >= mapTileArray.length) break;
                                MapTile mapTile = new MapTile(null, n4, n, (byte)this.mZoom);
                                mapTile.isVisible = true;
                                mapTile.holder = object;
                                mapTile.state = ((MapTile)object).state;
                                ((MapTile)object).isVisible = true;
                                object = TileRenderer.this;
                                n2 = ((TileRenderer)object).mProxyTileCnt;
                                ((TileRenderer)object).mProxyTileCnt = n2 + 1;
                                mapTileArray[n2 + n5] = mapTile;
                            }
                        }
                    }
                    ++n4;
                }
            }
        };
        this.mDrawTiles = new TileSet();
    }

    /*
     * Unable to fully structure code
     */
    private static int compileTileLayers(MapTile[] var0, int var1_1) {
        var2_2 = 0;
        var3_3 = 0;
        while (true) {
            var4_4 = var3_3;
            if (var2_2 >= var1_1) break;
            var5_5 = var0[var2_2];
            if (!var5_5.isVisible) {
                var4_4 = var3_3;
            } else if (var5_5.state(8)) {
                var4_4 = var3_3;
            } else if (var5_5.state(4)) {
                var4_4 = TileRenderer.uploadTileData(var5_5);
lbl15:
                // 2 sources

                while (true) {
                    var4_4 = var3_3 + var4_4;
                    break;
                }
            } else {
                var6_6 = var5_5.holder;
                if (var6_6 != null && var6_6.state(4)) {
                    var4_4 = var3_3 + TileRenderer.uploadTileData(var6_6);
                    var5_5.state = var6_6.state;
                } else {
                    var6_6 = var5_5.getProxy(16, (byte)4);
                    if (var6_6 != null) {
                        var4_4 = TileRenderer.uploadTileData(var6_6);
                        ** continue;
                    }
                    for (var4_4 = 0; var4_4 < 4; ++var4_4) {
                        var6_6 = var5_5.getProxyChild(var4_4, (byte)4);
                        var7_7 = var3_3;
                        if (var6_6 != null) {
                            var7_7 = var3_3 + TileRenderer.uploadTileData(var6_6);
                        }
                        var3_3 = var7_7;
                    }
                    var4_4 = var3_3;
                    if (var3_3 >= 8) {
                        var4_4 = var3_3;
                        break;
                    }
                }
            }
            ++var2_2;
            var3_3 = var4_4;
        }
        return var4_4;
    }

    public static long getMinFade(MapTile object, int n) {
        long l;
        long l2 = l = MapRenderer.frametime - 50L;
        if (n <= 0) {
            int n2 = 0;
            while (true) {
                l2 = l;
                if (n2 >= 4) break;
                MapTile mapTile = (MapTile)((MapTile)object).node.child(n2);
                if (mapTile != null) {
                    l2 = l;
                    if (mapTile.fadeTime > 0L) {
                        l2 = l;
                        if (mapTile.fadeTime < l) {
                            l2 = mapTile.fadeTime;
                        }
                    }
                    l = l2;
                    if (n >= -1) {
                        long l3 = TileRenderer.getMinFade(mapTile, n - 1);
                        l = l2;
                        if (l3 < l2) {
                            l = l3;
                        }
                    }
                }
                ++n2;
            }
        }
        object = (MapTile.TileNode)((MapTile)object).node.parent;
        while (n >= -1 && object != null) {
            l = l2;
            if (((MapTile.TileNode)object).item != null) {
                l = l2;
                if (((MapTile)((MapTile.TileNode)object).item).fadeTime > 0L) {
                    l = l2;
                    if (((MapTile)((MapTile.TileNode)object).item).fadeTime < l2) {
                        l = ((MapTile)((MapTile.TileNode)object).item).fadeTime;
                    }
                }
            }
            object = (MapTile.TileNode)((MapTile.TileNode)object).parent;
            --n;
            l2 = l;
        }
        return l2;
    }

    private static int uploadTileData(MapTile object) {
        ((MapTile)object).setState((byte)8);
        object = ((MapTile)object).getBuckets();
        if (object == null) {
            return 0;
        }
        if (!((RenderBuckets)object).compile(true)) {
            ((RenderBuckets)object).clear();
            return 0;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearTiles() {
        Object object = this.tilelock;
        synchronized (object) {
            this.mDrawTiles.releaseTiles();
            this.mDrawTiles.tiles = new MapTile[1];
            this.mDrawTiles.cnt = 0;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getVisibleTiles(TileSet tileSet) {
        boolean bl = false;
        if (tileSet == null) {
            return false;
        }
        if (this.mDrawTiles == null) {
            this.releaseTiles(tileSet);
            return false;
        }
        int n = tileSet.serial;
        Object object = this.tilelock;
        synchronized (object) {
            MapTile mapTile;
            int n2;
            MapTile[] mapTileArray = this.mDrawTiles.tiles;
            int n3 = this.mDrawTiles.cnt;
            if (tileSet.tiles.length != mapTileArray.length) {
                tileSet.tiles = new MapTile[mapTileArray.length];
            }
            tileSet.cnt = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                mapTile = mapTileArray[n2];
                if (!mapTile.isVisible || !mapTile.state(8)) continue;
                mapTile.lock();
            }
            tileSet.releaseTiles();
            for (n2 = 0; n2 < n3; ++n2) {
                mapTile = mapTileArray[n2];
                if (!mapTile.isVisible || !mapTile.state(8)) continue;
                MapTile[] mapTileArray2 = tileSet.tiles;
                int n4 = tileSet.cnt;
                tileSet.cnt = n4 + 1;
                mapTileArray2[n4] = mapTile;
            }
            tileSet.serial = this.mUploadSerial;
        }
        if (n == tileSet.serial) return bl;
        return true;
    }

    public void releaseTiles(TileSet tileSet) {
        tileSet.releaseTiles();
    }

    public void setBitmapAlpha(float f) {
        synchronized (this) {
            this.mAlpha = f;
            return;
        }
    }

    public void setOverdrawColor(int n) {
        synchronized (this) {
            this.mOverdraw = n;
            return;
        }
    }

    protected void setTileManager(TileManager tileManager) {
        this.mTileManager = tileManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void update(GLViewport gLViewport) {
        // MONITORENTER : this
        float f = this.mAlpha;
        if (f == 0.0f) {
            this.mDrawTiles.releaseTiles();
            this.setReady(false);
            // MONITOREXIT : this
            return;
        }
        this.mLayerAlpha = f;
        this.mOverdrawColor = this.mOverdraw;
        Object object = this.tilelock;
        // MONITORENTER : object
        boolean bl = this.mTileManager.getActiveTiles(this.mDrawTiles);
        if (this.mDrawTiles.cnt == 0) {
            this.setReady(false);
            this.mProxyTileCnt = 0;
            // MONITOREXIT : object
            // MONITOREXIT : this
            return;
        }
        if (bl || gLViewport.changed()) {
            this.mProxyTileCnt = 0;
            MapTile[] mapTileArray = this.mDrawTiles.tiles;
            byte by = mapTileArray[0].zoomLevel;
            for (int i = 0; i < this.mDrawTiles.cnt; ++i) {
                mapTileArray[i].isVisible = false;
            }
            this.mScanBox.scan(gLViewport.pos.x, gLViewport.pos.y, gLViewport.pos.scale, by, gLViewport.plane);
        }
        // MONITOREXIT : object
        if (TileRenderer.compileTileLayers(this.mDrawTiles.tiles, this.mDrawTiles.cnt + this.mProxyTileCnt) > 0) {
            ++this.mUploadSerial;
            BufferObject.checkBufferUsage(false);
        }
        this.setReady(true);
        // MONITOREXIT : this
    }
}

