/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import java.util.Arrays;
import java.util.Comparator;
import org.oscim.layers.tile.MapTile;

public final class TileSet {
    public static Comparator<MapTile> coordComparator = new CoordComparator();
    public int cnt = 0;
    int serial;
    public MapTile[] tiles;

    public TileSet() {
        this.tiles = new MapTile[1];
    }

    public TileSet(int n) {
        this.tiles = new MapTile[n];
    }

    public boolean contains(MapTile mapTile) {
        for (int i = 0; i < this.cnt; ++i) {
            if (!this.tiles[i].equals(mapTile)) continue;
            return true;
        }
        return false;
    }

    public MapTile getTile(int n, int n2) {
        for (int i = 0; i < this.cnt; ++i) {
            if (this.tiles[i].tileX != n || this.tiles[i].tileY != n2) continue;
            return this.tiles[i];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lockTiles() {
        synchronized (TileSet.class) {
            int n = 0;
            while (n < this.cnt) {
                this.tiles[n].lock();
                ++n;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseTiles() {
        synchronized (TileSet.class) {
            int n = 0;
            while (true) {
                if (n >= this.cnt) {
                    // MONITOREXIT @DISABLED, blocks:[3, 4, 5] lbl5 : MonitorExitStatement: MONITOREXIT : org.oscim.layers.tile.TileSet.class
                    Arrays.fill(this.tiles, null);
                    this.cnt = 0;
                    this.serial = 0;
                    return;
                }
                this.tiles[n].unlock();
                ++n;
            }
        }
    }

    public void setTiles(TileSet tileSet) {
        tileSet.lockTiles();
        this.releaseTiles();
        MapTile[] mapTileArray = tileSet.tiles;
        if (mapTileArray.length != this.tiles.length) {
            this.tiles = new MapTile[mapTileArray.length];
        }
        System.arraycopy(tileSet.tiles, 0, this.tiles, 0, tileSet.cnt);
        this.cnt = tileSet.cnt;
    }

    public static class CoordComparator
    implements Comparator<MapTile> {
        @Override
        public int compare(MapTile mapTile, MapTile mapTile2) {
            if (mapTile.tileX == mapTile2.tileX) {
                if (mapTile.tileY == mapTile2.tileY) {
                    return 0;
                }
                if (mapTile.tileY < mapTile2.tileY) {
                    return 1;
                }
                return -1;
            }
            if (mapTile.tileX < mapTile2.tileX) {
                return 1;
            }
            return -1;
        }
    }
}

