/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.backend.GLAdapter;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileRenderer;
import org.oscim.renderer.GLMatrix;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.BitmapBucket;
import org.oscim.renderer.bucket.CircleBucket;
import org.oscim.renderer.bucket.HairLineBucket;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.LineTexBucket;
import org.oscim.renderer.bucket.MeshBucket;
import org.oscim.renderer.bucket.PolygonBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.utils.FastMath;

public class VectorTileRenderer
extends TileRenderer {
    static final boolean debugOverdraw = false;
    protected GLMatrix mClipMVP;
    protected int mClipMode;
    protected GLMatrix mClipProj = new GLMatrix();
    protected int mDrawSerial;

    public VectorTileRenderer() {
        this.mClipMVP = new GLMatrix();
    }

    private void drawTile(MapTile mapTile, GLViewport gLViewport, int n) {
        int n2 = mapTile.lastDraw;
        int n3 = this.mDrawSerial;
        if (n2 == n3) {
            return;
        }
        mapTile.lastDraw = n3;
        RenderBuckets renderBuckets = mapTile.holder == null ? mapTile.getBuckets() : mapTile.holder.getBuckets();
        if (renderBuckets != null && renderBuckets.vbo != null) {
            long l;
            double d = (double)Tile.SIZE * gLViewport.pos.scale;
            float f = (float)((mapTile.x - gLViewport.pos.x) * d);
            float f2 = (float)((mapTile.y - gLViewport.pos.y) * d);
            float f3 = (float)(gLViewport.pos.scale / (double)(1 << mapTile.zoomLevel));
            gLViewport.mvp.setTransScale(f, f2, f3 / MapRenderer.COORD_SCALE);
            gLViewport.mvp.multiplyLhs(gLViewport.viewproj);
            this.mClipMVP.setTransScale(f, f2, f3 / MapRenderer.COORD_SCALE);
            this.mClipMVP.multiplyLhs(this.mClipProj);
            f2 = FastMath.pow(mapTile.zoomLevel - gLViewport.pos.zoomLevel);
            renderBuckets.bind();
            PolygonBucket.Renderer.clip(this.mClipMVP, this.mClipMode);
            RenderBucket renderBucket = renderBuckets.get();
            boolean bl = true;
            while (renderBucket != null) {
                n3 = renderBucket.type;
                if (n3 != 0) {
                    if (n3 != 1) {
                        if (n3 != 2) {
                            if (n3 != 3) {
                                if (n3 != 5) {
                                    if (n3 != 7) {
                                        if (n3 != 8) {
                                            log.error("unknown layer {}", (Object)renderBucket.type);
                                            renderBucket = (RenderBucket)renderBucket.next;
                                        } else {
                                            renderBucket = CircleBucket.Renderer.draw(renderBucket, gLViewport);
                                        }
                                    } else {
                                        renderBucket = BitmapBucket.Renderer.draw(renderBucket, gLViewport, 1.0f, this.mLayerAlpha);
                                    }
                                } else {
                                    renderBucket = HairLineBucket.Renderer.draw(renderBucket, gLViewport);
                                }
                            } else {
                                renderBucket = MeshBucket.Renderer.draw(renderBucket, gLViewport);
                            }
                        } else {
                            renderBucket = PolygonBucket.Renderer.draw(renderBucket, gLViewport, f2, bl);
                            GLAdapter.gl.stencilFunc(514, 128, 128);
                            bl = false;
                        }
                    } else {
                        renderBucket = LineTexBucket.Renderer.draw(renderBucket, gLViewport, f2, renderBuckets);
                    }
                } else {
                    renderBucket = LineBucket.Renderer.draw(renderBucket, gLViewport, f3, renderBuckets);
                }
                renderBuckets.bind();
            }
            long l2 = l = mapTile.fadeTime;
            if (l == 0L) {
                if (mapTile.holder == null) {
                    l2 = VectorTileRenderer.getMinFade(mapTile, n);
                } else {
                    l2 = l = mapTile.holder.fadeTime;
                    if (l == 0L) {
                        l2 = VectorTileRenderer.getMinFade(mapTile.holder, n);
                    }
                }
                mapTile.fadeTime = l2;
            }
            l = MapRenderer.frametime;
            if (this.mOverdrawColor != 0 && !((f3 = (float)(l - l2)) > 500.0f)) {
                f3 = 1.0f - f3 / 500.0f;
                PolygonBucket.Renderer.drawOver(this.mClipMVP, this.mOverdrawColor, f3 * f3);
                MapRenderer.animate();
                return;
            }
            PolygonBucket.Renderer.drawOver(this.mClipMVP, 0, 1.0f);
        }
    }

    protected boolean drawChildren(MapTile mapTile, GLViewport gLViewport) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            MapTile mapTile2 = mapTile.getProxyChild(i, (byte)8);
            if (mapTile2 == null) continue;
            this.drawTile(mapTile2, gLViewport, 1);
            ++n;
        }
        if (n == 4) {
            mapTile.lastDraw = this.mDrawSerial;
            return true;
        }
        return false;
    }

    protected void drawGrandParent(MapTile mapTile, GLViewport gLViewport) {
        MapTile mapTile2 = mapTile.getProxy(32, (byte)8);
        if (mapTile2 != null) {
            this.drawTile(mapTile2, gLViewport, -2);
            mapTile.lastDraw = this.mDrawSerial;
        }
    }

    protected boolean drawParent(MapTile mapTile, GLViewport gLViewport) {
        MapTile mapTile2 = mapTile.getProxy(16, (byte)8);
        if (mapTile2 != null) {
            this.drawTile(mapTile2, gLViewport, -1);
            mapTile.lastDraw = this.mDrawSerial;
            return true;
        }
        return false;
    }

    @Override
    public void render(GLViewport gLViewport) {
        synchronized (this) {
            MapTile mapTile;
            int n;
            MapTile[] mapTileArray;
            int n2;
            block23: {
                block22: {
                    int n3;
                    block21: {
                        this.mClipProj.copy(gLViewport.proj);
                        this.mClipProj.setValue(10, 0.0f);
                        this.mClipProj.setValue(14, 0.0f);
                        this.mClipProj.multiplyRhs(gLViewport.view);
                        n3 = 1;
                        this.mClipMode = 1;
                        n2 = this.mDrawTiles.cnt + this.mProxyTileCnt;
                        mapTileArray = this.mDrawTiles.tiles;
                        ++this.mDrawSerial;
                        for (n = 0; n < n2; ++n) {
                            mapTile = mapTileArray[n];
                            if (!mapTile.isVisible || mapTile.state(8)) continue;
                            GLAdapter.gl.depthMask(true);
                            GLAdapter.gl.clear(256);
                            GLAdapter.gl.depthFunc(519);
                            this.mClipMode = 2;
                            n = 1;
                            break block21;
                        }
                        n = 0;
                    }
                    for (int i = 0; i < n2; ++i) {
                        mapTile = mapTileArray[i];
                        if (!mapTile.isVisible || !mapTile.state(8)) continue;
                        this.drawTile(mapTile, gLViewport, 0);
                        continue;
                    }
                    if (n == 0) {
                        return;
                    }
                    GLAdapter.gl.depthFunc(513);
                    n = n3;
                    if (!(gLViewport.pos.getZoomScale() < 1.5)) {
                        n = gLViewport.pos.zoomLevel < mapTileArray[0].zoomLevel ? n3 : 0;
                    }
                    if (n == 0) break block22;
                    for (n = 0; n < n2; ++n) {
                        mapTile = mapTileArray[n];
                        if (!mapTile.isVisible || mapTile.lastDraw == this.mDrawSerial || this.drawParent(mapTile, gLViewport)) continue;
                        this.drawChildren(mapTile, gLViewport);
                        continue;
                    }
                    break block23;
                }
                for (n = 0; n < n2; ++n) {
                    mapTile = mapTileArray[n];
                    if (!mapTile.isVisible || mapTile.lastDraw == this.mDrawSerial) continue;
                    this.drawChildren(mapTile, gLViewport);
                    continue;
                }
                for (n = 0; n < n2; ++n) {
                    mapTile = mapTileArray[n];
                    if (!mapTile.isVisible || mapTile.lastDraw == this.mDrawSerial) continue;
                    this.drawParent(mapTile, gLViewport);
                    continue;
                }
            }
            for (n = 0; n < n2; ++n) {
                mapTile = mapTileArray[n];
                if (!mapTile.isVisible || mapTile.lastDraw == this.mDrawSerial) continue;
                this.drawGrandParent(mapTile, gLViewport);
                continue;
            }
            GLAdapter.gl.depthMask(false);
            return;
        }
    }
}

