/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.bitmap;

import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.layers.tile.TileLayer;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.VectorTileRenderer;
import org.oscim.layers.tile.bitmap.BitmapTileLoader;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.tiling.TileSource;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapTileLayer
extends TileLayer {
    private static final int CACHE_LIMIT = 40;
    static final int POOL_FILL = 20;
    protected static final Logger log = LoggerFactory.getLogger(BitmapTileLayer.class);
    private float mBitmapAlpha = 1.0f;
    protected final TileSource mTileSource;
    final TextureItem.TexturePool pool = new TextureItem.TexturePool(20){};

    public BitmapTileLayer(Map map, TileSource tileSource) {
        this(map, tileSource, 40);
    }

    public BitmapTileLayer(Map map, TileSource tileSource, float f) {
        this(map, tileSource, 40, f);
    }

    public BitmapTileLayer(Map map, TileSource tileSource, int n) {
        this(map, tileSource, n, 1.0f);
    }

    public BitmapTileLayer(Map map, TileSource tileSource, int n, float f) {
        super(map, new TileManager(map, n), new VectorTileRenderer());
        this.mTileManager.setZoomLevel(tileSource.getZoomLevelMin(), tileSource.getZoomLevelMax());
        this.mTileSource = tileSource;
        this.mBitmapAlpha = f;
        this.tileRenderer().setBitmapAlpha(this.mBitmapAlpha);
        this.initLoader(this.getNumLoaders());
        this.setFade(map.getMapPosition());
    }

    private void setFade(MapPosition mapPosition) {
        float f;
        block4: {
            FadeStep[] fadeStepArray = this.mTileSource.getFadeSteps();
            if (fadeStepArray == null) {
                return;
            }
            for (FadeStep fadeStep : fadeStepArray) {
                if (mapPosition.scale < fadeStep.scaleStart || mapPosition.scale > fadeStep.scaleEnd) continue;
                if (fadeStep.alphaStart == fadeStep.alphaEnd) {
                    f = fadeStep.alphaStart;
                } else {
                    double d = fadeStep.scaleEnd;
                    double d2 = fadeStep.scaleStart;
                    f = FastMath.clamp((float)((mapPosition.scale - fadeStep.scaleStart) / (d - d2)), 0.0f, 1.0f);
                    float f2 = fadeStep.alphaStart;
                    f = f * fadeStep.alphaEnd + (1.0f - f) * f2;
                }
                break block4;
            }
            f = 0.0f;
        }
        f = FastMath.clamp(f, 0.0f, this.mBitmapAlpha);
        this.tileRenderer().setBitmapAlpha(f);
    }

    @Override
    protected TileLoader createLoader() {
        return new BitmapTileLoader(this, this.mTileSource);
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.pool.clear();
    }

    @Override
    public void onMapEvent(Event event, MapPosition mapPosition) {
        super.onMapEvent(event, mapPosition);
        if (event != Map.POSITION_EVENT) {
            return;
        }
        this.setFade(mapPosition);
    }

    public void setBitmapAlpha(float f) {
        this.mBitmapAlpha = f;
        this.tileRenderer().setBitmapAlpha(this.mBitmapAlpha);
        this.map().updateMap(true);
    }

    public static class FadeStep {
        public final float alphaEnd;
        public final float alphaStart;
        public final double scaleEnd;
        public final double scaleStart;

        public FadeStep(double d, double d2, float f, float f2) {
            this.scaleStart = d;
            this.scaleEnd = d2;
            this.alphaStart = f;
            this.alphaEnd = f2;
        }

        public FadeStep(int n, int n2, float f, float f2) {
            this.scaleStart = 1 << n;
            this.scaleEnd = 1 << n2;
            this.alphaStart = f;
            this.alphaEnd = f2;
        }
    }
}

