/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.bitmap;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.bitmap.BitmapTileLayer;
import org.oscim.renderer.bucket.BitmapBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.TileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapTileLoader
extends TileLoader {
    protected static final Logger log = LoggerFactory.getLogger(BitmapTileLoader.class);
    private final BitmapTileLayer mLayer;
    private final ITileDataSource mTileDataSource;

    public BitmapTileLoader(BitmapTileLayer bitmapTileLayer, TileSource tileSource) {
        super(bitmapTileLayer.getManager());
        this.mTileDataSource = tileSource.getDataSource();
        this.mLayer = bitmapTileLayer;
    }

    @Override
    public void cancel() {
        this.mTileDataSource.cancel();
    }

    @Override
    public void dispose() {
        this.mTileDataSource.cancel();
    }

    @Override
    protected boolean loadTile(MapTile mapTile) {
        try {
            this.mTileDataSource.query(mapTile, this);
            return true;
        }
        catch (Exception exception) {
            log.debug("{} {}", (Object)mapTile, (Object)exception.getMessage());
            return false;
        }
    }

    @Override
    public void setTileImage(Bitmap object) {
        if (!this.isCanceled() && this.mTile.state(2)) {
            BitmapBucket bitmapBucket = new BitmapBucket(false);
            bitmapBucket.setBitmap((Bitmap)object, Tile.SIZE, Tile.SIZE, this.mLayer.pool);
            object = new RenderBuckets();
            ((RenderBuckets)object).set(bitmapBucket);
            this.mTile.data = object;
            return;
        }
        object.recycle();
    }
}

