/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.oscim.core.MapElement;
import org.oscim.layers.Layer;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileRenderer;
import org.oscim.layers.tile.buildings.BuildingRenderer;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.map.Map;
import org.oscim.renderer.OffscreenRenderer;
import org.oscim.renderer.bucket.ExtrusionBuckets;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.theme.styles.RenderStyle;

public class BuildingLayer
extends Layer
implements VectorTileLayer.TileLoaderThemeHook {
    private static final Object BUILDING_DATA = BuildingLayer.class.getName();
    private static final int BUILDING_LEVEL_HEIGHT = 280;
    private static final int MAX_ZOOM = 17;
    private static final int MIN_ZOOM = 17;
    public static boolean POST_AA = false;
    public static boolean TRANSLUCENT = true;
    private HashMap<Integer, List<BuildingElement>> mBuildings = new HashMap();

    public BuildingLayer(Map map, VectorTileLayer vectorTileLayer) {
        this(map, vectorTileLayer, 17, 17, false);
    }

    public BuildingLayer(Map object, VectorTileLayer vectorTileLayer, int n, int n2, boolean bl) {
        super((Map)object);
        vectorTileLayer.addHook(this);
        object = vectorTileLayer.tileRenderer();
        boolean bl2 = !bl && TRANSLUCENT;
        this.mRenderer = new BuildingRenderer((TileRenderer)object, n, n2, bl, bl2);
        if (POST_AA) {
            this.mRenderer = new OffscreenRenderer(OffscreenRenderer.Mode.SSAO_FXAA, this.mRenderer);
        }
    }

    public BuildingLayer(Map map, VectorTileLayer vectorTileLayer, boolean bl) {
        this(map, vectorTileLayer, 17, 17, bl);
    }

    public static ExtrusionBuckets get(MapTile mapTile) {
        ExtrusionBuckets extrusionBuckets;
        Object object = BUILDING_DATA;
        ExtrusionBuckets extrusionBuckets2 = extrusionBuckets = (ExtrusionBuckets)mapTile.getData(object);
        if (extrusionBuckets == null) {
            extrusionBuckets2 = new ExtrusionBuckets(mapTile);
            mapTile.addData(object, extrusionBuckets2);
        }
        return extrusionBuckets2;
    }

    /*
     * Unable to fully structure code
     */
    private void processElement(MapElement var1_1, ExtrusionStyle var2_2, MapTile var3_3) {
        var4_4 = var1_1.tags.getValue("height");
        if (var4_4 != null) {
            var5_5 = Float.parseFloat(var4_4) * 100.0f;
lbl4:
            // 2 sources

            while (true) {
                var6_6 = (int)var5_5;
                break;
            }
        } else {
            var4_4 = var1_1.tags.getValue("building:levels");
            if (var4_4 != null) {
                var5_5 = Float.parseFloat(var4_4) * 280.0f;
                ** continue;
            }
            var6_6 = 0;
        }
        var4_4 = var1_1.tags.getValue("min_height");
        var7_7 = var4_4 != null ? (int)(Float.parseFloat(var4_4) * 100.0f) : ((var4_4 = var1_1.tags.getValue("building:min_level")) != null ? (int)(Float.parseFloat(var4_4) * 280.0f) : 0);
        var8_8 = var6_6;
        if (var6_6 == 0) {
            var8_8 = var2_2.defaultHeight * 100;
        }
        BuildingLayer.get(var3_3).addPolyElement(var1_1, var3_3.getGroundScale(), var2_2.colors, var8_8, var7_7);
    }

    private void processElements(MapTile mapTile) {
        if (!this.mBuildings.containsKey(mapTile.hashCode())) {
            return;
        }
        List<BuildingElement> list = this.mBuildings.get(mapTile.hashCode());
        HashSet<BuildingElement> hashSet = new HashSet<BuildingElement>();
        block0: for (BuildingElement buildingElement22 : list) {
            if (!buildingElement22.isPart) continue;
            String string2 = buildingElement22.element.tags.getValue("ref");
            Object object = string2;
            if (string2 == null) {
                object = buildingElement22.element.tags.getValue("root_id");
            }
            if (object == null) continue;
            for (BuildingElement buildingElement22 : list) {
                if (buildingElement22.isPart || !((String)object).equals(buildingElement22.element.tags.getValue("id"))) continue;
                hashSet.add(buildingElement22);
                continue block0;
            }
        }
        list.removeAll(hashSet);
        for (BuildingElement buildingElement : list) {
            this.processElement(buildingElement.element, buildingElement.style, mapTile);
        }
        this.mBuildings.remove(mapTile.hashCode());
    }

    @Override
    public void complete(MapTile mapTile, boolean bl) {
        if (bl) {
            this.processElements(mapTile);
            BuildingLayer.get(mapTile).prepare();
        } else {
            BuildingLayer.get(mapTile).resetBuckets(null);
        }
    }

    @Override
    public boolean process(MapTile mapTile, RenderBuckets arrayList, MapElement mapElement, RenderStyle object, int n) {
        ExtrusionStyle extrusionStyle;
        boolean bl;
        block7: {
            block6: {
                bl = object instanceof ExtrusionStyle;
                boolean bl2 = false;
                if (!bl) {
                    return false;
                }
                extrusionStyle = (ExtrusionStyle)((RenderStyle)object).current();
                if (mapElement.tags.containsKey("building:part")) break block6;
                bl = bl2;
                if (!mapElement.tags.containsKey("kind")) break block7;
                bl = bl2;
                if (!mapElement.tags.getValue("kind").equals("building_part")) break block7;
            }
            bl = true;
        }
        if (!(mapElement.tags.containsKey("building") || bl || mapElement.tags.containsKey("kind") && mapElement.tags.getValue("kind").equals("building"))) {
            this.processElement(mapElement, extrusionStyle, mapTile);
            return true;
        }
        object = this.mBuildings.get(mapTile.hashCode());
        arrayList = object;
        if (object == null) {
            arrayList = new ArrayList<BuildingElement>();
            this.mBuildings.put(mapTile.hashCode(), arrayList);
        }
        arrayList.add(new BuildingElement(new MapElement(mapElement), extrusionStyle, bl));
        return true;
    }

    class BuildingElement {
        MapElement element;
        boolean isPart;
        ExtrusionStyle style;

        BuildingElement(MapElement mapElement, ExtrusionStyle extrusionStyle, boolean bl) {
            this.element = mapElement;
            this.style = extrusionStyle;
            this.isPart = bl;
        }
    }
}

