/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileDistanceSort;
import org.oscim.layers.tile.TileRenderer;
import org.oscim.layers.tile.TileSet;
import org.oscim.layers.tile.buildings.BuildingLayer;
import org.oscim.renderer.ExtrusionRenderer;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.ExtrusionBuckets;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildingRenderer
extends ExtrusionRenderer {
    static final Logger log = LoggerFactory.getLogger(BuildingRenderer.class);
    private long mAnimTime;
    private final float mFadeInTime;
    private final float mFadeOutTime;
    private boolean mShow;
    private final TileRenderer mTileRenderer;
    private final TileSet mTileSet;
    private final int mZoomMax;
    private final int mZoomMin;

    public BuildingRenderer(TileRenderer tileRenderer, int n, int n2, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.mFadeInTime = 250.0f;
        this.mFadeOutTime = 400.0f;
        this.mZoomMax = n2;
        this.mZoomMin = n;
        this.mTileRenderer = tileRenderer;
        this.mTileSet = new TileSet();
    }

    private static ExtrusionBuckets getBuckets(MapTile mapTile) {
        if (mapTile.getBuckets() != null && !mapTile.state(12)) {
            return null;
        }
        return BuildingLayer.get(mapTile);
    }

    @Override
    public void render(GLViewport gLViewport) {
        super.render(gLViewport);
        this.mTileRenderer.releaseTiles(this.mTileSet);
    }

    @Override
    public boolean setup() {
        this.mAlpha = 0.0f;
        return super.setup();
    }

    @Override
    public void update(GLViewport mapTileArray) {
        int n;
        long l;
        int n2 = mapTileArray.pos.zoomLevel - this.mZoomMin;
        if (n2 < -1) {
            this.mAlpha = 0.0f;
            this.mShow = false;
            this.setReady(false);
            return;
        }
        if (n2 >= 0) {
            if (this.mAlpha < 1.0f) {
                l = System.currentTimeMillis();
                if (!this.mShow) {
                    this.mAnimTime = l - (long)(this.mAlpha * 250.0f);
                }
                this.mShow = true;
                this.mAlpha = FastMath.clamp((float)(l - this.mAnimTime) / 250.0f, 0.0f, 1.0f);
                MapRenderer.animate();
            }
        } else if (this.mAlpha > 0.0f) {
            l = System.currentTimeMillis();
            if (this.mShow) {
                this.mAnimTime = l - (long)((1.0f - this.mAlpha) * 400.0f);
            }
            this.mShow = false;
            this.mAlpha = FastMath.clamp(1.0f - (float)(l - this.mAnimTime) / 400.0f, 0.0f, 1.0f);
            MapRenderer.animate();
        }
        if (this.mAlpha == 0.0f) {
            this.setReady(false);
            return;
        }
        this.mTileRenderer.getVisibleTiles(this.mTileSet);
        if (this.mTileSet.cnt == 0) {
            this.mTileRenderer.releaseTiles(this.mTileSet);
            this.setReady(false);
            return;
        }
        mapTileArray = this.mTileSet.tiles;
        TileDistanceSort.sort(mapTileArray, 0, this.mTileSet.cnt);
        n2 = this.mTileSet.cnt * 4;
        if (this.mExtrusionBucketSet.length < n2) {
            this.mExtrusionBucketSet = new ExtrusionBuckets[n2];
        }
        if ((n = mapTileArray[0].zoomLevel) >= (n2 = this.mZoomMin) && n <= this.mZoomMax) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (true) {
                n = n4;
                n2 = n5;
                if (n3 < this.mTileSet.cnt) {
                    ExtrusionBuckets extrusionBuckets = BuildingRenderer.getBuckets(mapTileArray[n3]);
                    if (extrusionBuckets == null) {
                        n = n4;
                        n2 = n5;
                    } else if (extrusionBuckets.compiled) {
                        this.mExtrusionBucketSet[n5] = extrusionBuckets;
                        n2 = n5 + 1;
                        n = n4;
                    } else {
                        n = n4;
                        n2 = n5;
                        if (n4 == 0) {
                            n = n4;
                            n2 = n5;
                            if (extrusionBuckets.compile()) {
                                this.mExtrusionBucketSet[n5] = extrusionBuckets;
                                n2 = n5 + 1;
                                n = 1;
                            }
                        }
                    }
                    ++n3;
                    n4 = n;
                    n5 = n2;
                    continue;
                }
                break;
            }
        } else if (n == this.mZoomMax + 1) {
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (true) {
                n = n7;
                n2 = n8;
                if (n6 < this.mTileSet.cnt) {
                    Object object = (MapTile)mapTileArray[n6].node.parent();
                    if (object == null) {
                        n = n7;
                        n2 = n8;
                    } else if ((object = BuildingRenderer.getBuckets((MapTile)object)) == null) {
                        n = n7;
                        n2 = n8;
                    } else if (((ExtrusionBuckets)object).compiled) {
                        this.mExtrusionBucketSet[n8] = object;
                        n2 = n8 + 1;
                        n = n7;
                    } else {
                        n = n7;
                        n2 = n8;
                        if (n7 == 0) {
                            n = n7;
                            n2 = n8;
                            if (((ExtrusionBuckets)object).compile()) {
                                this.mExtrusionBucketSet[n8] = object;
                                n2 = n8 + 1;
                                n = 1;
                            }
                        }
                    }
                    ++n6;
                    n7 = n;
                    n8 = n2;
                    continue;
                }
                break;
            }
        } else if (n == n2 - 1) {
            n2 = 0;
            for (n = 0; n < this.mTileSet.cnt; ++n) {
                MapTile mapTile = mapTileArray[n];
                for (int n9 = 0; n9 < 4; n9 = (int)((byte)(n9 + 1))) {
                    int n10;
                    if (!mapTile.hasProxy(1 << n9)) {
                        n10 = n2;
                    } else {
                        ExtrusionBuckets extrusionBuckets = BuildingRenderer.getBuckets((MapTile)mapTile.node.child(n9));
                        n10 = n2;
                        if (extrusionBuckets != null) {
                            if (!extrusionBuckets.compiled) {
                                n10 = n2;
                            } else {
                                this.mExtrusionBucketSet[n2] = extrusionBuckets;
                                n10 = n2 + 1;
                            }
                        }
                    }
                    n2 = n10;
                }
            }
            n = 0;
        } else {
            n = 0;
            n2 = 0;
        }
        if (n != 0) {
            MapRenderer.animate();
        }
        this.mBucketsCnt = n2;
        if (n2 == 0) {
            this.mTileRenderer.releaseTiles(this.mTileSet);
            this.setReady(false);
            return;
        }
        this.setReady(true);
    }
}

