/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import org.oscim.layers.tile.TileLayer;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.TileRenderer;
import org.oscim.layers.tile.buildings.BuildingRenderer;
import org.oscim.layers.tile.buildings.S3DBTileLoader;
import org.oscim.map.Map;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.OffscreenRenderer;
import org.oscim.tiling.TileSource;

public class S3DBTileLayer
extends TileLayer {
    private static final int MAX_CACHE = 32;
    private static final int MAX_ZOOM = 16;
    private static final int MIN_ZOOM = 16;
    private final TileSource mTileSource;

    public S3DBTileLayer(Map map, TileSource tileSource) {
        this(map, tileSource, true, false);
    }

    public S3DBTileLayer(Map map, TileSource tileSource, boolean bl, boolean bl2) {
        super(map, new TileManager(map, 32));
        this.setRenderer(new S3DBTileRenderer(bl, bl2));
        this.mTileManager.setZoomLevel(16, 16);
        this.mTileSource = tileSource;
        this.initLoader(2);
    }

    @Override
    protected S3DBTileLoader createLoader() {
        return new S3DBTileLoader(this.getManager(), this.mTileSource);
    }

    public static class S3DBTileRenderer
    extends TileRenderer {
        LayerRenderer mRenderer = new BuildingRenderer(this, 16, 16, true, false);

        public S3DBTileRenderer(boolean bl, boolean bl2) {
            if (bl || bl2) {
                OffscreenRenderer.Mode mode = OffscreenRenderer.Mode.FXAA;
                if (bl && bl2) {
                    mode = OffscreenRenderer.Mode.SSAO_FXAA;
                } else if (bl2) {
                    mode = OffscreenRenderer.Mode.SSAO;
                }
                this.mRenderer = new OffscreenRenderer(mode, this.mRenderer);
            }
        }

        @Override
        public void render(GLViewport gLViewport) {
            synchronized (this) {
                this.mRenderer.render(gLViewport);
                return;
            }
        }

        @Override
        public boolean setup() {
            this.mRenderer.setup();
            return super.setup();
        }

        @Override
        public void update(GLViewport gLViewport) {
            synchronized (this) {
                super.update(gLViewport);
                this.mRenderer.update(gLViewport);
                this.setReady(this.mRenderer.isReady());
                return;
            }
        }
    }
}

