/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import org.oscim.backend.canvas.Color;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.buildings.BuildingLayer;
import org.oscim.layers.tile.buildings.S3DBUtils;
import org.oscim.renderer.bucket.ExtrusionBucket;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.oscim.tiling.TileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class S3DBTileLoader
extends TileLoader {
    private static final String OSCIM4_KEY_COLOR = "c";
    private static final String OSCIM4_KEY_MATERIAL = "m";
    static final Logger log;
    static MapElement mTilePlane;
    private float mGroundScale;
    private ExtrusionBucket mParts;
    private ExtrusionBucket mRoofs;
    private final ITileDataSource mTileDataSource;

    static {
        MapElement mapElement;
        log = LoggerFactory.getLogger(S3DBTileLoader.class);
        mTilePlane = new MapElement();
        mTilePlane = mapElement = new MapElement();
        mapElement.type = GeometryBuffer.GeometryType.TRIS;
        mapElement.points = new float[]{0.0f, 0.0f, 0.0f, 4096.0f, 0.0f, 0.0f, 0.0f, 4096.0f, 0.0f, 4096.0f, 4096.0f, 0.0f};
        mapElement.index = new int[]{0, 1, 2, 2, 1, 3};
        S3DBTileLoader.mTilePlane.tags.add(new Tag(OSCIM4_KEY_COLOR, "transparent"));
    }

    public S3DBTileLoader(TileManager tileManager, TileSource tileSource) {
        super(tileManager);
        this.mTileDataSource = tileSource.getDataSource();
    }

    private void initTile(MapTile mapTile) {
        ExtrusionBucket extrusionBucket;
        this.mGroundScale = mapTile.getGroundScale();
        this.mRoofs = new ExtrusionBucket(0, this.mGroundScale, Color.get(247, 249, 250));
        this.mParts = extrusionBucket = new ExtrusionBucket(0, this.mGroundScale, Color.get(255, 254, 252));
        this.mRoofs.next = extrusionBucket;
        BuildingLayer.get(mapTile).resetBuckets(this.mRoofs);
        this.process(mTilePlane);
    }

    @Override
    public void cancel() {
        this.mTileDataSource.cancel();
    }

    @Override
    public void completed(QueryResult queryResult) {
        this.mParts = null;
        this.mRoofs = null;
        super.completed(queryResult);
    }

    @Override
    public void dispose() {
        this.mTileDataSource.dispose();
    }

    @Override
    protected boolean loadTile(MapTile mapTile) {
        this.mTile = mapTile;
        try {
            this.mTileDataSource.query(this.mTile, this);
            return true;
        }
        catch (Exception exception) {
            log.debug("{}", exception);
            return false;
        }
    }

    @Override
    public void process(MapElement mapElement) {
        ExtrusionBucket extrusionBucket;
        if (mapElement.type != GeometryBuffer.GeometryType.TRIS) {
            Logger logger = log;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("wrong type ");
            stringBuilder.append((Object)mapElement.type);
            logger.debug(stringBuilder.toString());
            return;
        }
        if (this.mParts == null) {
            this.initTile(this.mTile);
        }
        boolean bl = mapElement.tags.containsKey("roof");
        int n = mapElement.tags.containsKey(OSCIM4_KEY_COLOR) ? S3DBUtils.getColor(mapElement.tags.getValue(OSCIM4_KEY_COLOR), bl) : 0;
        int n2 = n;
        if (n == 0) {
            n2 = n;
            if (mapElement.tags.containsKey(OSCIM4_KEY_MATERIAL)) {
                n2 = S3DBUtils.getMaterialColor(mapElement.tags.getValue(OSCIM4_KEY_MATERIAL), bl);
            }
        }
        if (n2 == 0) {
            String string2 = mapElement.tags.getValue("roof:shape");
            if (bl && (string2 == null || "flat".equals(string2))) {
                this.mRoofs.addMesh(mapElement);
            } else {
                this.mParts.addMesh(mapElement);
            }
            return;
        }
        for (extrusionBucket = this.mParts; extrusionBucket != null; extrusionBucket = extrusionBucket.next()) {
            if (extrusionBucket.getColor() != n2) continue;
            extrusionBucket.addMesh(mapElement);
            return;
        }
        extrusionBucket = new ExtrusionBucket(0, this.mGroundScale, n2);
        extrusionBucket.next = this.mParts.next;
        this.mParts.next = extrusionBucket;
        extrusionBucket.addMesh(mapElement);
    }
}

