/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import org.oscim.backend.canvas.Color;
import org.oscim.utils.ColorUtil;
import org.oscim.utils.ColorsCSS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3DBUtils {
    private static final double HSV_S = 0.7;
    private static final double HSV_V = 1.2;
    private static final Logger log = LoggerFactory.getLogger(S3DBUtils.class);

    private S3DBUtils() {
    }

    public static int getColor(String string2, boolean bl) {
        if (string2.charAt(0) == '#') {
            return ColorUtil.modHsv(Color.parseColor(string2, -16711681), 1.0, 0.4, 1.2, true);
        }
        if (bl) {
            if ("brown".equals(string2)) {
                return Color.get(120, 110, 110);
            }
            if ("red".equals(string2)) {
                return Color.get(235, 140, 130);
            }
            if ("green".equals(string2)) {
                return Color.get(150, 200, 130);
            }
            if ("blue".equals(string2)) {
                return Color.get(100, 50, 200);
            }
        }
        if ("white".equals(string2)) {
            return Color.get(240, 240, 240);
        }
        if ("black".equals(string2)) {
            return Color.get(86, 86, 86);
        }
        if (!"grey".equals(string2) && !"gray".equals(string2)) {
            if ("red".equals(string2)) {
                return Color.get(255, 190, 190);
            }
            if ("green".equals(string2)) {
                return Color.get(190, 255, 190);
            }
            if ("blue".equals(string2)) {
                return Color.get(190, 190, 255);
            }
            if ("yellow".equals(string2)) {
                return Color.get(255, 255, 175);
            }
            if (!"darkgray".equals(string2) && !"darkgrey".equals(string2)) {
                if (!"lightgray".equals(string2) && !"lightgrey".equals(string2)) {
                    if ("transparent".equals(string2)) {
                        return Color.get(0, 1, 1, 1);
                    }
                    Integer n = ColorsCSS.get(string2);
                    if (n != null) {
                        return ColorUtil.modHsv(n, 1.0, 0.7, 1.2, true);
                    }
                    log.debug("unknown color:{}", (Object)string2);
                    return 0;
                }
                return -3355444;
            }
            return -12303292;
        }
        return Color.get(120, 120, 120);
    }

    public static int getMaterialColor(String string2, boolean bl) {
        if (bl && "glass".equals(string2)) {
            return Color.fade(Color.get(130, 224, 255), 0.9f);
        }
        if ("roof_tiles".equals(string2)) {
            return Color.get(216, 167, 111);
        }
        if ("tile".equals(string2)) {
            return Color.get(216, 167, 111);
        }
        if (!"concrete".equals(string2) && !"cement_block".equals(string2)) {
            if ("metal".equals(string2)) {
                return -4144960;
            }
            if ("tar_paper".equals(string2)) {
                return -6907496;
            }
            if ("eternit".equals(string2)) {
                return Color.get(216, 167, 111);
            }
            if ("tin".equals(string2)) {
                return -4144960;
            }
            if ("asbestos".equals(string2)) {
                return Color.get(160, 152, 141);
            }
            if ("glass".equals(string2)) {
                return Color.get(130, 224, 255);
            }
            if ("slate".equals(string2)) {
                return -10462880;
            }
            if ("zink".equals(string2)) {
                return Color.get(180, 180, 180);
            }
            if ("gravel".equals(string2)) {
                return Color.get(170, 130, 80);
            }
            if ("copper".equals(string2)) {
                return Color.get(150, 200, 130);
            }
            if ("wood".equals(string2)) {
                return Color.get(170, 130, 80);
            }
            if ("grass".equals(string2)) {
                return -11490736;
            }
            if ("stone".equals(string2)) {
                return Color.get(206, 207, 181);
            }
            if ("plaster".equals(string2)) {
                return Color.get(236, 237, 181);
            }
            if ("brick".equals(string2)) {
                return Color.get(255, 217, 191);
            }
            if ("stainless_steel".equals(string2)) {
                return Color.get(153, 157, 160);
            }
            if ("gold".equals(string2)) {
                return -10496;
            }
            log.debug("unknown material:{}", (Object)string2);
            return 0;
        }
        return Color.get(210, 212, 212);
    }
}

