/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.example;

import org.oscim.backend.canvas.Paint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileLayer;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.VectorTileRenderer;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.theme.styles.LineStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTileLayer
extends TileLayer {
    static final Logger log = LoggerFactory.getLogger(TestTileLayer.class);

    public TestTileLayer(Map map) {
        super(map, new TileManager(map, 10), new VectorTileRenderer());
    }

    @Override
    protected TestTileLoader createLoader() {
        return new TestTileLoader(this);
    }

    static class TestTileLoader
    extends TileLoader {
        GeometryBuffer mGeom = new GeometryBuffer(128, 16);
        LineStyle mLineStyle = new LineStyle(-16776961, 2.0f, Paint.Cap.ROUND);

        public TestTileLoader(TileLayer tileLayer) {
            super(tileLayer.getManager());
        }

        @Override
        public void cancel() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean loadTile(MapTile object) {
            Object object2 = log;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("load tile ");
            stringBuilder.append(object);
            object2.debug(stringBuilder.toString());
            ((MapTile)object).data = object2 = new RenderBuckets();
            object2 = ((RenderBuckets)object2).getLineBucket(0);
            ((LineBucket)object2).line = this.mLineStyle;
            ((LineBucket)object2).scale = 2.0f;
            int n = Tile.SIZE;
            object = this.mGeom;
            ((GeometryBuffer)object).clear();
            ((GeometryBuffer)object).startLine();
            float f = 20;
            ((GeometryBuffer)object).addPoint(f, f);
            float f2 = n - 40;
            ((GeometryBuffer)object).addPoint(f, f2);
            ((GeometryBuffer)object).addPoint(f2, f2);
            ((GeometryBuffer)object).addPoint(f2, f);
            ((GeometryBuffer)object).addPoint(f, f);
            ((LineBucket)object2).addLine((GeometryBuffer)object);
            return true;
        }
    }
}

