/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector;

import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.layers.tile.vector.VectorTileLoader;
import org.oscim.map.Map;
import org.oscim.utils.Utils;

public class OsmTileLayer
extends VectorTileLayer {
    private static final int CACHE_LIMIT = 150;
    private static final int MAX_ZOOMLEVEL = 17;
    private static final int MIN_ZOOMLEVEL = 2;

    public OsmTileLayer(Map map) {
        this(map, 2, 17);
    }

    public OsmTileLayer(Map map, int n, int n2) {
        super(map, 150);
        this.mTileManager.setZoomLevel(n, n2);
    }

    @Override
    protected TileLoader createLoader() {
        return new OsmTileLoader(this);
    }

    private static class OsmTileLoader
    extends VectorTileLoader {
        private static final VectorTileLoader.TagReplacement[] mTagReplacement = new VectorTileLoader.TagReplacement[]{new VectorTileLoader.TagReplacement("name"), new VectorTileLoader.TagReplacement("addr:housenumber"), new VectorTileLoader.TagReplacement("ref"), new VectorTileLoader.TagReplacement("height"), new VectorTileLoader.TagReplacement("min_height")};
        private final TagSet mFilteredTags = new TagSet();

        OsmTileLoader(VectorTileLayer vectorTileLayer) {
            super(vectorTileLayer);
        }

        @Override
        protected TagSet filterTags(TagSet tagReplacementArray) {
            Tag[] tagArray = tagReplacementArray.getTags();
            this.mFilteredTags.clear();
            int n = tagReplacementArray.size();
            block0: for (int i = 0; i < n; ++i) {
                Tag tag = tagArray[i];
                for (VectorTileLoader.TagReplacement tagReplacement : mTagReplacement) {
                    if (!Utils.equals(tag.key, tagReplacement.key)) continue;
                    this.mFilteredTags.add(tagReplacement.tag);
                    continue block0;
                }
                this.mFilteredTags.add(tag);
            }
            return this.mFilteredTags;
        }
    }
}

