/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector;

import org.oscim.core.MapElement;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileLayer;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.VectorTileRenderer;
import org.oscim.layers.tile.vector.VectorTileLoader;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.tiling.TileSource;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.LList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorTileLayer
extends TileLayer {
    static final Logger log = LoggerFactory.getLogger(VectorTileLayer.class);
    private Inlist.List<LList<TileLoaderProcessHook>> mLoaderProcessHooks = new Inlist.List();
    private Inlist.List<LList<TileLoaderThemeHook>> mLoaderThemeHooks = new Inlist.List();
    private IRenderTheme mTheme;
    protected TileSource mTileSource;

    public VectorTileLayer(Map map, int n) {
        this(map, new TileManager(map, n), new VectorTileRenderer());
    }

    public VectorTileLayer(Map map, TileManager tileManager, VectorTileRenderer vectorTileRenderer) {
        super(map, tileManager, vectorTileRenderer);
        this.initLoader(this.getNumLoaders());
    }

    public VectorTileLayer(Map map, TileSource tileSource) {
        this(map, new TileManager(map, 100), new VectorTileRenderer());
        this.setTileSource(tileSource);
    }

    public void addHook(TileLoaderProcessHook tileLoaderProcessHook) {
        this.mLoaderProcessHooks.append(new LList<TileLoaderProcessHook>(tileLoaderProcessHook));
    }

    public void addHook(TileLoaderThemeHook tileLoaderThemeHook) {
        this.mLoaderThemeHooks.append(new LList<TileLoaderThemeHook>(tileLoaderThemeHook));
    }

    public void callHooksComplete(MapTile mapTile, boolean bl) {
        LList lList = this.mLoaderThemeHooks.head();
        while (lList != null) {
            ((TileLoaderThemeHook)lList.data).complete(mapTile, bl);
            lList = (LList)lList.next;
        }
        lList = this.mLoaderProcessHooks.head();
        while (lList != null) {
            ((TileLoaderProcessHook)lList.data).complete(mapTile, bl);
            lList = (LList)lList.next;
        }
    }

    public boolean callProcessHooks(MapTile mapTile, RenderBuckets renderBuckets, MapElement mapElement) {
        LList lList = this.mLoaderProcessHooks.head();
        while (lList != null) {
            if (((TileLoaderProcessHook)lList.data).process(mapTile, renderBuckets, mapElement)) {
                return true;
            }
            lList = (LList)lList.next;
        }
        return false;
    }

    public void callThemeHooks(MapTile mapTile, RenderBuckets renderBuckets, MapElement mapElement, RenderStyle renderStyle, int n) {
        LList lList = this.mLoaderThemeHooks.head();
        while (lList != null) {
            if (((TileLoaderThemeHook)lList.data).process(mapTile, renderBuckets, mapElement, renderStyle, n)) {
                return;
            }
            lList = (LList)lList.next;
        }
    }

    @Override
    protected TileLoader createLoader() {
        return new VectorTileLoader(this);
    }

    public IRenderTheme getTheme() {
        return this.mTheme;
    }

    @Override
    public void onDetach() {
        super.onDetach();
        TileSource tileSource = this.mTileSource;
        if (tileSource != null) {
            tileSource.close();
        }
    }

    public void setRenderTheme(IRenderTheme iRenderTheme) {
        this.pauseLoaders(true);
        this.mTileManager.clearJobs();
        this.mTheme = iRenderTheme;
        this.tileRenderer().setOverdrawColor(iRenderTheme.getMapBackground());
        this.resumeLoaders();
    }

    public boolean setTileSource(TileSource tileSource) {
        this.pauseLoaders(true);
        this.mTileManager.clearJobs();
        TileLoader[] tileLoaderArray = this.mTileSource;
        if (tileLoaderArray != null) {
            tileLoaderArray.close();
            this.mTileSource = null;
        }
        TileSource.OpenResult openResult = tileSource.open();
        tileLoaderArray = TileSource.OpenResult.SUCCESS;
        if (openResult != tileLoaderArray) {
            log.debug(openResult.getErrorMessage());
            return false;
        }
        this.mTileSource = tileSource;
        this.mTileManager.setZoomLevel(tileSource.getZoomLevelMin(), tileSource.getZoomLevelMax());
        tileLoaderArray = this.mTileLoader;
        int n = tileLoaderArray.length;
        for (int i = 0; i < n; ++i) {
            ((VectorTileLoader)tileLoaderArray[i]).setDataSource(tileSource.getDataSource());
        }
        this.mMap.clearMap();
        this.resumeLoaders();
        return true;
    }

    public static interface TileLoaderProcessHook {
        public void complete(MapTile var1, boolean var2);

        public boolean process(MapTile var1, RenderBuckets var2, MapElement var3);
    }

    public static interface TileLoaderThemeHook {
        public void complete(MapTile var1, boolean var2);

        public boolean process(MapTile var1, RenderBuckets var2, MapElement var3, RenderStyle var4, int var5);
    }
}

