/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector;

import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.renderer.bucket.CircleBucket;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.LineTexBucket;
import org.oscim.renderer.bucket.MeshBucket;
import org.oscim.renderer.bucket.PolygonBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.CircleStyle;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.theme.styles.TextStyle;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorTileLoader
extends TileLoader
implements RenderStyle.Callback {
    protected static final byte LAYERS = 11;
    protected static final double STROKE_INCREASE;
    public static final byte STROKE_MAX_ZOOM = 17;
    public static final byte STROKE_MIN_ZOOM = 12;
    public static boolean USE_MESH_POLY;
    static final Logger log;
    protected RenderBuckets mBuckets;
    protected int mCurBucket;
    protected LineBucket mCurLineBucket;
    protected MapElement mElement;
    protected float mLineScale = 1.0f;
    protected ITileDataSource mTileDataSource;
    private final VectorTileLayer mTileLayer;
    protected IRenderTheme renderTheme;

    static {
        log = LoggerFactory.getLogger(VectorTileLoader.class);
        STROKE_INCREASE = Math.sqrt(2.5);
        USE_MESH_POLY = false;
    }

    public VectorTileLoader(VectorTileLayer vectorTileLayer) {
        super(vectorTileLayer.getManager());
        this.mTileLayer = vectorTileLayer;
    }

    protected static int getValidLayer(int n) {
        if (n < 0) {
            return 0;
        }
        int n2 = n;
        if (n >= 11) {
            n2 = 10;
        }
        return n2;
    }

    @Override
    public void cancel() {
        ITileDataSource iTileDataSource = this.mTileDataSource;
        if (iTileDataSource != null) {
            iTileDataSource.cancel();
        }
    }

    protected void clearState() {
        this.mCurLineBucket = null;
        this.mElement = null;
    }

    @Override
    public void completed(QueryResult queryResult) {
        boolean bl = queryResult == QueryResult.SUCCESS;
        this.mTileLayer.callHooksComplete(this.mTile, bl);
        this.mBuckets.prepare();
        this.clearState();
        super.completed(queryResult);
    }

    @Override
    public void dispose() {
        ITileDataSource iTileDataSource = this.mTileDataSource;
        if (iTileDataSource != null) {
            iTileDataSource.dispose();
        }
    }

    protected TagSet filterTags(TagSet tagSet) {
        return tagSet;
    }

    @Override
    public boolean loadTile(MapTile mapTile) {
        float f;
        if (this.mTileDataSource == null) {
            log.error("no tile source is set");
            return false;
        }
        Object object = this.mTileLayer.getTheme();
        this.renderTheme = object;
        if (object == null) {
            log.error("no theme is set");
            return false;
        }
        double d = MercatorProjection.toLatitude(mapTile.y);
        this.mLineScale = f = (float)Math.pow(STROKE_INCREASE, mapTile.zoomLevel - 12);
        if (f < 1.0f) {
            this.mLineScale = 1.0f;
        }
        this.mLineScale *= (float)Math.sin(Math.abs(d) * (Math.PI / 180)) * 0.6f + 0.4f;
        this.mBuckets = object = new RenderBuckets();
        mapTile.data = object;
        try {
            this.mTileDataSource.query(mapTile, this);
        }
        catch (Exception exception) {
            log.debug("{} {}", (Object)mapTile, (Object)exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        catch (NullPointerException nullPointerException) {
            log.debug("NPE {} {}", (Object)mapTile, (Object)nullPointerException.getMessage());
            nullPointerException.printStackTrace();
        }
        return true;
    }

    @Override
    public void process(MapElement mapElement) {
        if (!this.isCanceled() && this.mTile.state(2)) {
            if (this.mTileLayer.callProcessHooks(this.mTile, this.mBuckets, mapElement)) {
                return;
            }
            TagSet tagSet = this.filterTags(mapElement.tags);
            if (tagSet == null) {
                return;
            }
            this.mElement = mapElement;
            if (mapElement.type == GeometryBuffer.GeometryType.POINT) {
                this.renderNode(this.renderTheme.matchElement(mapElement.type, tagSet, this.mTile.zoomLevel));
            } else {
                this.mCurBucket = VectorTileLoader.getValidLayer(mapElement.layer) * this.renderTheme.getLevels();
                this.renderWay(this.renderTheme.matchElement(mapElement.type, tagSet, this.mTile.zoomLevel));
            }
            this.clearState();
        }
    }

    @Override
    public void renderArea(AreaStyle areaStyle, int n) {
        if (this.mTile.zoomLevel < areaStyle.fadeScale) {
            return;
        }
        n = this.mCurBucket + n;
        this.mTileLayer.callThemeHooks(this.mTile, this.mBuckets, this.mElement, areaStyle, n);
        if (!USE_MESH_POLY && !areaStyle.mesh) {
            PolygonBucket polygonBucket = this.mBuckets.getPolygonBucket(n);
            polygonBucket.area = areaStyle;
            polygonBucket.addPolygon(this.mElement.points, this.mElement.index);
        } else {
            MeshBucket meshBucket = this.mBuckets.getMeshBucket(n);
            meshBucket.area = areaStyle;
            meshBucket.addMesh(this.mElement);
        }
    }

    @Override
    public void renderCircle(CircleStyle circleStyle, int n) {
        int n2 = this.mCurBucket;
        CircleBucket circleBucket = this.mBuckets.getCircleBucket(n2 + n);
        circleBucket.circle = circleStyle;
        circleBucket.addCircle(this.mElement);
    }

    @Override
    public void renderExtrusion(ExtrusionStyle extrusionStyle, int n) {
        this.mTileLayer.callThemeHooks(this.mTile, this.mBuckets, this.mElement, extrusionStyle, n);
    }

    protected void renderNode(RenderStyle[] renderStyleArray) {
        if (renderStyleArray == null) {
            return;
        }
        int n = renderStyleArray.length;
        for (int i = 0; i < n; ++i) {
            renderStyleArray[i].renderNode(this);
        }
    }

    @Override
    public void renderSymbol(SymbolStyle symbolStyle) {
        this.mTileLayer.callThemeHooks(this.mTile, this.mBuckets, this.mElement, symbolStyle, 0);
    }

    @Override
    public void renderText(TextStyle textStyle) {
        this.mTileLayer.callThemeHooks(this.mTile, this.mBuckets, this.mElement, textStyle, 0);
    }

    @Override
    public void renderWay(LineStyle object, int n) {
        int n2 = this.mCurBucket + n;
        if (((LineStyle)object).outline && this.mCurLineBucket == null) {
            object = log;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("missing line for outline! ");
            stringBuilder.append(this.mElement.tags);
            stringBuilder.append(" lvl:");
            stringBuilder.append(n);
            stringBuilder.append(" layer:");
            stringBuilder.append(this.mElement.layer);
            object.debug(stringBuilder.toString());
            return;
        }
        n = ((LineStyle)object).stipple;
        float f = 1.0f;
        if (n == 0 && ((LineStyle)object).texture == null) {
            LineBucket lineBucket = this.mBuckets.getLineBucket(n2);
            if (lineBucket.line == null) {
                lineBucket.line = object;
                if (!((LineStyle)object).fixed) {
                    f = this.mLineScale;
                }
                lineBucket.scale = f;
                lineBucket.setExtents(-16, Tile.SIZE + 16);
            }
            if (((LineStyle)object).outline) {
                lineBucket.addOutline(this.mCurLineBucket);
                return;
            }
            lineBucket.addLine(this.mElement);
            this.mCurLineBucket = lineBucket;
        } else {
            LineTexBucket lineTexBucket = this.mBuckets.getLineTexBucket(n2);
            if (lineTexBucket.line == null) {
                lineTexBucket.line = object;
                if (!((LineStyle)object).fixed) {
                    f = this.mLineScale;
                }
                lineTexBucket.scale = f;
                lineTexBucket.setExtents(-16, Tile.SIZE + 16);
            }
            lineTexBucket.addLine(this.mElement);
        }
    }

    protected void renderWay(RenderStyle[] renderStyleArray) {
        if (renderStyleArray == null) {
            return;
        }
        int n = renderStyleArray.length;
        for (int i = 0; i < n; ++i) {
            renderStyleArray[i].renderWay(this);
        }
    }

    public void setDataSource(ITileDataSource iTileDataSource) {
        this.dispose();
        this.mTileDataSource = iTileDataSource;
    }

    static class TagReplacement {
        String key;
        Tag tag;

        public TagReplacement(String string2) {
            this.key = string2;
            this.tag = new Tag(string2, null);
        }
    }
}

