/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector.labeling;

import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.layers.Layer;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.layers.tile.vector.labeling.LabelPlacement;
import org.oscim.layers.tile.vector.labeling.LabelTask;
import org.oscim.layers.tile.vector.labeling.LabelTileLoaderHook;
import org.oscim.layers.tile.vector.labeling.TextRenderer;
import org.oscim.map.Map;
import org.oscim.utils.async.SimpleWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelLayer
extends Layer
implements Map.UpdateListener,
TileManager.Listener {
    static final String LABEL_DATA;
    private static final long MAX_RELABEL_DELAY = 100L;
    static final Logger log;
    private final LabelPlacement mLabelPlacer;
    private final Worker mWorker;

    static {
        log = LoggerFactory.getLogger(LabelLayer.class);
        LABEL_DATA = LabelLayer.class.getName();
    }

    public LabelLayer(Map map, VectorTileLayer vectorTileLayer) {
        this(map, vectorTileLayer, new LabelTileLoaderHook());
    }

    public LabelLayer(Map object, VectorTileLayer vectorTileLayer, VectorTileLayer.TileLoaderThemeHook tileLoaderThemeHook) {
        super((Map)object);
        vectorTileLayer.getManager().events.bind(this);
        vectorTileLayer.addHook(tileLoaderThemeHook);
        this.mLabelPlacer = new LabelPlacement((Map)object, vectorTileLayer.tileRenderer());
        this.mWorker = object = new Worker((Map)object);
        this.mRenderer = new TextRenderer((Worker)object);
    }

    public void clearLabels() {
        this.mWorker.cancel(true);
    }

    @Override
    public void onDetach() {
        this.mWorker.cancel(true);
        super.onDetach();
    }

    @Override
    public void onMapEvent(Event event, MapPosition mapPosition) {
        if (event == Map.CLEAR_EVENT) {
            this.mWorker.cancel(true);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (event == Map.POSITION_EVENT) {
            this.mWorker.submit(100L);
        }
    }

    @Override
    public void onTileManagerEvent(Event event, MapTile mapTile) {
        if (event == TileManager.TILE_LOADED) {
            if (mapTile.isVisible && this.isEnabled()) {
                this.mWorker.submit(25L);
            }
        } else {
            event = TileManager.TILE_REMOVED;
        }
    }

    public void update() {
        if (!this.isEnabled()) {
            return;
        }
        this.mWorker.submit(100L);
    }

    class Worker
    extends SimpleWorker<LabelTask> {
        public Worker(Map map) {
            super(map, 50L, new LabelTask(), new LabelTask());
        }

        @Override
        public void cleanup(LabelTask labelTask) {
        }

        @Override
        public boolean doWork(LabelTask labelTask) {
            if (LabelLayer.this.mLabelPlacer.updateLabels(labelTask)) {
                this.mMap.render();
                return true;
            }
            return false;
        }

        @Override
        public void finish() {
            LabelLayer.this.mLabelPlacer.cleanup();
        }

        @Override
        public boolean isRunning() {
            synchronized (this) {
                boolean bl = this.mRunning;
                return bl;
            }
        }
    }
}

