/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector.labeling;

import java.util.Iterator;
import org.oscim.core.MapPosition;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileRenderer;
import org.oscim.layers.tile.TileSet;
import org.oscim.layers.tile.vector.labeling.Label;
import org.oscim.layers.tile.vector.labeling.LabelLayer;
import org.oscim.layers.tile.vector.labeling.LabelPool;
import org.oscim.layers.tile.vector.labeling.LabelTask;
import org.oscim.layers.tile.vector.labeling.LabelTileData;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.renderer.bucket.TextItem;
import org.oscim.utils.FastMath;
import org.oscim.utils.geom.OBB2D;
import org.oscim.utils.pool.Inlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelPlacement {
    private static final float MIN_CAPTION_DIST = 5.0f;
    private static final float MIN_WAY_DIST = 3.0f;
    static final boolean dbg = false;
    static final Logger log = LoggerFactory.getLogger(LabelPlacement.class);
    private Label mLabels;
    private final Map mMap;
    private final LabelPool mPool = new LabelPool();
    private int mRelabelCnt;
    private float mSquareRadius;
    private final TileRenderer mTileRenderer;
    private final TileSet mTileSet = new TileSet();

    public LabelPlacement(Map map, TileRenderer tileRenderer) {
        this.mMap = map;
        this.mTileRenderer = tileRenderer;
    }

    private Label addNodeLabels(MapTile mapTile, Label label, float f, float f2, double d, float f3, float f4) {
        Inlist inlist = LabelPlacement.getLabels(mapTile);
        if (inlist == null) {
            return label;
        }
        Iterator<TextItem> iterator2 = ((LabelTileData)inlist).labels.iterator();
        inlist = label;
        block0: while (iterator2.hasNext()) {
            TextItem textItem = iterator2.next();
            if (!textItem.text.caption) continue;
            Inlist inlist2 = inlist;
            if (inlist == null) {
                inlist2 = this.getLabel();
            }
            ((Label)inlist2).clone(textItem);
            ((Label)inlist2).x = (float)((double)(f + textItem.x) * d);
            ((Label)inlist2).y = (float)((double)(f2 + textItem.y) * d);
            if (!this.isVisible(((Label)inlist2).x, ((Label)inlist2).y)) {
                inlist = inlist2;
                continue;
            }
            if (((Label)inlist2).bbox == null) {
                ((Label)inlist2).bbox = new OBB2D();
            }
            ((Label)inlist2).bbox.setNormalized(((Label)inlist2).x, ((Label)inlist2).y, f3, -f4, ((Label)inlist2).width + 5.0f, ((Label)inlist2).text.fontHeight + 5.0f, ((Label)inlist2).text.dy);
            label = this.mLabels;
            while (label != null) {
                if (((Label)inlist2).bbox.overlaps(label.bbox)) {
                    inlist = inlist2;
                    if (((Label)inlist2).text.priority >= label.text.priority) continue block0;
                    label = this.removeLabel(label);
                    continue;
                }
                label = (Label)label.next;
            }
            this.addLabel((Label)inlist2);
            ((Label)inlist2).item = TextItem.copy(textItem);
            ((Label)inlist2).tileX = mapTile.tileX;
            ((Label)inlist2).tileY = mapTile.tileY;
            ((Label)inlist2).tileZ = mapTile.zoomLevel;
            ((Label)inlist2).active = this.mRelabelCnt;
            inlist = null;
        }
        return inlist;
    }

    private Label addWayLabels(MapTile mapTile, Label inlist, float f, float f2, double d) {
        Inlist inlist2 = LabelPlacement.getLabels(mapTile);
        if (inlist2 == null) {
            return inlist;
        }
        for (TextItem textItem : ((LabelTileData)inlist2).labels) {
            if (textItem.text.caption) continue;
            inlist2 = inlist;
            if (inlist == null) {
                inlist2 = this.getLabel();
            }
            if ((double)textItem.width > (double)textItem.length * d) {
                inlist = inlist2;
                continue;
            }
            ((Label)inlist2).clone(textItem);
            ((Label)inlist2).x = (float)((double)(f + textItem.x) * d);
            ((Label)inlist2).y = (float)((double)(f2 + textItem.y) * d);
            this.placeLabelFrom((Label)inlist2, textItem);
            if (!this.wayIsVisible((Label)inlist2)) {
                inlist = inlist2;
                continue;
            }
            int n = -1;
            if (((Label)inlist2).bbox == null) {
                ((Label)inlist2).bbox = new OBB2D(((Label)inlist2).x, ((Label)inlist2).y, ((Label)inlist2).x1, ((Label)inlist2).y1, ((Label)inlist2).width + 3.0f, ((Label)inlist2).text.fontHeight + 3.0f);
            } else {
                ((Label)inlist2).bbox.set(((Label)inlist2).x, ((Label)inlist2).y, ((Label)inlist2).x1, ((Label)inlist2).y1, ((Label)inlist2).width + 3.0f, ((Label)inlist2).text.fontHeight + 3.0f);
            }
            if ((double)textItem.width < (double)textItem.length * d) {
                n = this.checkOverlap((Label)inlist2);
            }
            inlist = inlist2;
            if (n != 0) continue;
            this.addLabel((Label)inlist2);
            ((Label)inlist2).item = TextItem.copy(textItem);
            ((Label)inlist2).tileX = mapTile.tileX;
            ((Label)inlist2).tileY = mapTile.tileY;
            ((Label)inlist2).tileZ = mapTile.zoomLevel;
            ((Label)inlist2).active = this.mRelabelCnt;
            inlist = null;
        }
        return inlist;
    }

    private byte checkOverlap(Label label) {
        Label label2 = this.mLabels;
        while (label2 != null) {
            if (!Label.bboxOverlaps(label, label2, 100.0f)) {
                label2 = (Label)label2.next;
                continue;
            }
            if (Label.shareText(label, label2)) {
                if (label2.active <= label.active) {
                    return 1;
                }
                if (label2.length < label.length) {
                    label2 = this.removeLabel(label2);
                    continue;
                }
                return 2;
            }
            if (label.bbox.overlaps(label2.bbox)) {
                if (label2.active <= label.active) {
                    return 1;
                }
                if (!(label2.text.caption || label2.text.priority <= label.text.priority && label2.length >= label.length)) {
                    label2 = this.removeLabel(label2);
                    continue;
                }
                return 1;
            }
            label2 = (Label)label2.next;
        }
        return 0;
    }

    private static float flipLongitude(float f, int n) {
        float f2;
        if (f > (float)n) {
            f2 = f - (float)(n * 2);
        } else {
            f2 = f;
            if (f < (float)(-n)) {
                f2 = f + (float)(n * 2);
            }
        }
        return f2;
    }

    private Label getLabel() {
        Label label = (Label)this.mPool.get();
        label.active = Integer.MAX_VALUE;
        return label;
    }

    public static final LabelTileData getLabels(MapTile mapTile) {
        return (LabelTileData)mapTile.getData(LabelLayer.LABEL_DATA);
    }

    private boolean isVisible(float f, float f2) {
        return !(f * f + f2 * f2 > this.mSquareRadius);
    }

    private void placeLabelFrom(Label label, TextItem textItem) {
        float f = (textItem.x2 - textItem.x1) / 2.0f;
        float f2 = (textItem.y2 - textItem.y1) / 2.0f;
        label.x1 = label.x - f;
        label.y1 = label.y - f2;
        label.x2 = label.x + f;
        label.y2 = label.y + f2;
    }

    private Label removeLabel(Label label) {
        Label label2 = (Label)label.next;
        this.mLabels = this.mPool.release(this.mLabels, label);
        return label2;
    }

    private boolean wayIsVisible(Label label) {
        if (label.x * label.x + label.y * label.y < this.mSquareRadius) {
            return true;
        }
        if (label.x1 * label.x1 + label.y1 * label.y1 < this.mSquareRadius) {
            return true;
        }
        return label.x2 * label.x2 + label.y2 * label.y2 < this.mSquareRadius;
    }

    public void addLabel(Label label) {
        label.next = this.mLabels;
        this.mLabels = label;
    }

    public void cleanup() {
        this.mLabels = this.mPool.releaseAll(this.mLabels);
        this.mTileSet.releaseTiles();
    }

    /*
     * Unable to fully structure code
     */
    protected Label groupLabels(Label var1_1) {
        var2_2 = var1_1;
        while (var2_2 != null) {
            var3_3 = var2_2.text;
            var4_4 = var2_2.width;
            var5_5 = (Label)var2_2.next;
            var6_6 = var2_2;
            while (var5_5 != null) {
                if (var4_4 != var5_5.width || var3_3 != var5_5.text || !var2_2.label.equals(var5_5.label)) ** GOTO lbl18
                if (var2_2.next != var5_5) {
                    var5_5.label = var2_2.label;
                    var7_7 = (Label)var2_2.next;
                    var2_2.next = var5_5;
                    var6_6.next = var5_5.next;
                    var5_5.next = var7_7;
                    var2_2 = var5_5;
                } else {
                    var5_5.label = var2_2.label;
lbl18:
                    // 2 sources

                    var6_6 = var5_5;
                }
                var5_5 = (Label)var6_6.next;
            }
            var2_2 = (Label)var2_2.next;
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    boolean updateLabels(LabelTask var1_1) {
        var2_2 = this.mTileRenderer.getVisibleTiles(this.mTileSet);
        if (this.mTileSet.cnt == 0) {
            return false;
        }
        var3_3 = var1_1.pos;
        var4_4 = this.mMap.viewport().getMapPosition((MapPosition)var3_3);
        if (!var2_2 && !var4_4) {
            return false;
        }
        ++this.mRelabelCnt;
        var5_5 = this.mTileSet.tiles;
        var6_6 = var5_5[0].zoomLevel;
        var7_7 = (this.mMap.getWidth() + Tile.SIZE) / 2;
        var8_8 = (this.mMap.getHeight() + Tile.SIZE) / 2;
        this.mSquareRadius = var7_7 * var7_7 + var8_8 * var8_8;
        var9_9 = var3_3.scale / (double)(1 << var6_6);
        var11_10 = Math.toRadians(var3_3.bearing);
        var13_11 = (float)Math.cos(var11_10);
        var14_12 = (float)Math.sin(var11_10);
        var8_8 = Tile.SIZE << var6_6 - 1;
        var15_13 = var1_1.symbolLayer;
        var15_13.clearItems();
        var11_10 = var3_3.x;
        var11_10 = (double)(Tile.SIZE << var6_6) * var11_10;
        var16_14 = var3_3.y;
        var7_7 = Tile.SIZE;
        var18_15 = var16_14 * (double)(var7_7 << var6_6);
        var20_16 = this.mLabels;
        this.mLabels = null;
        while (var20_16 != null) {
            if (var20_16.text.caption) {
                var20_16 = this.mPool.releaseAndGetNext((Label)var20_16);
                continue;
            }
            var7_7 = var20_16.tileZ - var6_6;
            if (var7_7 <= 1 && var7_7 >= -1) {
                var21_17 = FastMath.pow(var7_7);
                var22_18 = (float)(var3_3.scale / (double)(1 << var20_16.tileZ));
                if (var20_16.width > (float)(var20_16.length + 10) * var22_18) {
                    var20_16 = this.mPool.releaseAndGetNext((Label)var20_16);
                    continue;
                }
                var16_14 = var20_16.tileX * Tile.SIZE;
                var23_19 = var3_3;
                var24_20 = var21_17;
                var21_17 = (float)(var16_14 - var11_10 * var24_20);
                var26_21 = (float)((double)(var20_16.tileY * Tile.SIZE) - var24_20 * var18_15);
                var20_16.x = (LabelPlacement.flipLongitude(var21_17, var8_8) + var20_16.item.x) * var22_18;
                var20_16.y = (var26_21 + var20_16.item.y) * var22_18;
                this.placeLabelFrom((Label)var20_16, var20_16.item);
                if (!this.wayIsVisible((Label)var20_16)) {
                    var20_16 = this.mPool.releaseAndGetNext((Label)var20_16);
                    continue;
                }
                var20_16.bbox.set(var20_16.x, var20_16.y, var20_16.x1, var20_16.y1, var20_16.width + 3.0f, var20_16.text.fontHeight + 3.0f);
                if (this.checkOverlap((Label)var20_16) == 0) {
                    var3_3 = (Label)var20_16.next;
                    var20_16.next = null;
                    this.addLabel((Label)var20_16);
                    var20_16 = var3_3;
                    var3_3 = var23_19;
                    continue;
                }
                var20_16 = this.mPool.releaseAndGetNext((Label)var20_16);
                var3_3 = var23_19;
                continue;
            }
            var20_16 = this.mPool.releaseAndGetNext((Label)var20_16);
        }
        var27_22 = this.mTileSet.cnt;
        var3_3 = var15_13;
        var6_6 = var8_8;
        for (var7_7 = 0; var7_7 < var27_22; ++var7_7) {
            var15_13 = var5_5[var7_7];
            if (!var15_13.state(12)) continue;
            var21_17 = (float)((double)(var15_13.tileX * Tile.SIZE) - var11_10);
            var22_18 = (float)((double)(var15_13.tileY * Tile.SIZE) - var18_15);
            var20_16 = this.addWayLabels((MapTile)var15_13, (Label)var20_16, LabelPlacement.flipLongitude(var21_17, var6_6), var22_18, var9_9);
        }
        var15_13 = var3_3;
        var7_7 = this.mTileSet.cnt;
        var3_3 = var20_16;
        for (var8_8 = 0; var8_8 < var7_7; ++var8_8) {
            var20_16 = var5_5[var8_8];
            if (!var20_16.state(12)) continue;
            var21_17 = (float)((double)(var20_16.tileX * Tile.SIZE) - var11_10);
            var22_18 = (float)((double)(var20_16.tileY * Tile.SIZE) - var18_15);
            var3_3 = this.addNodeLabels((MapTile)var20_16, (Label)var3_3, LabelPlacement.flipLongitude(var21_17, var6_6), var22_18, var9_9, var13_11, var14_12);
        }
        var20_16 = this.mLabels;
        while (var20_16 != null) {
            if (var20_16.text.caption) {
                if (var20_16.text.bitmap != null || var20_16.text.texture != null) {
                    var23_19 = SymbolItem.pool.get();
                    if (var20_16.text.bitmap != null) {
                        var23_19.bitmap = var20_16.text.bitmap;
                    } else {
                        var23_19.texRegion = var20_16.text.texture;
                    }
                    var23_19.x = var20_16.x;
                    var23_19.y = var20_16.y;
                    var23_19.billboard = true;
                    var15_13.addSymbol((SymbolItem)var23_19);
                }
            } else if (var13_11 * (var20_16.x2 - var20_16.x1) - var14_12 * (var20_16.y2 - var20_16.y1) < 0.0f) {
                var22_18 = var20_16.x1;
                var20_16.x1 = var20_16.x2;
                var20_16.x2 = var22_18;
                var22_18 = var20_16.y1;
                var20_16.y1 = var20_16.y2;
                var20_16.y2 = var22_18;
            }
            var20_16 = (Label)var20_16.next;
        }
        var7_7 = this.mTileSet.cnt;
        var8_8 = var6_6;
        var6_6 = var7_7;
        block4: for (var27_22 = 0; var27_22 < var6_6; ++var27_22) {
            var20_16 = var5_5[var27_22];
            if (!var20_16.state(12)) continue;
            var13_11 = (float)((double)(var20_16.tileX * Tile.SIZE) - var11_10);
            var14_12 = (float)((double)(var20_16.tileY * Tile.SIZE) - var18_15);
            var13_11 = LabelPlacement.flipLongitude(var13_11, var8_8);
            if ((var20_16 = LabelPlacement.getLabels((MapTile)var20_16)) == null) {
                var7_7 = var6_6;
                while (true) {
                    var6_6 = var7_7;
                    continue block4;
                    break;
                }
            }
            var20_16 = var20_16.symbols.iterator();
            while (true) {
                var7_7 = var6_6;
                if (!var20_16.hasNext()) ** continue;
                var23_19 = var20_16.next();
                if (var23_19.bitmap == null && var23_19.texRegion == null || !this.isVisible(var22_18 = (float)(var28_23 = (int)((double)(var23_19.x + var13_11) * var9_9)), var21_17 = (float)(var7_7 = (int)((double)(var23_19.y + var14_12) * var9_9)))) continue;
                var29_24 = SymbolItem.pool.get();
                if (var23_19.bitmap != null) {
                    var29_24.bitmap = var23_19.bitmap;
                } else {
                    var29_24.texRegion = var23_19.texRegion;
                }
                var29_24.x = var22_18;
                var29_24.y = var21_17;
                var29_24.billboard = true;
                var15_13.addSymbol(var29_24);
            }
        }
        var20_16 = (Label)this.mPool.release(var3_3);
        var1_1.textLayer.labels = this.groupLabels(this.mLabels);
        var1_1.textLayer.prepare();
        var1_1.textLayer.labels = null;
        this.mTileRenderer.releaseTiles(this.mTileSet);
        return true;
    }
}

