/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector.labeling;

import org.oscim.layers.tile.vector.labeling.LabelLayer;
import org.oscim.layers.tile.vector.labeling.LabelTask;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.TextureBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TextRenderer
extends BucketRenderer {
    static final boolean dbg = false;
    static final Logger log = LoggerFactory.getLogger(TextRenderer.class);
    long lastDraw = 0L;
    private final LabelLayer.Worker mWorker;

    public TextRenderer(LabelLayer.Worker worker) {
        this.mWorker = worker;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void render(GLViewport gLViewport) {
        synchronized (this) {
            GLState.test(false, false);
            this.buckets.vbo.bind();
            float f = (float)(gLViewport.pos.scale / this.mMapPosition.scale);
            this.setMatrix(gLViewport, false);
            RenderBucket renderBucket = this.buckets.get();
            while (renderBucket != null) {
                renderBucket = TextureBucket.Renderer.draw(renderBucket, gLViewport, f);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void update(GLViewport object) {
        synchronized (this) {
            object = this.mWorker;
            synchronized (object) {
                LabelTask labelTask = (LabelTask)this.mWorker.poll();
                if (labelTask != null) {
                    this.buckets.clear();
                    // MONITOREXIT @DISABLED, blocks:[5, 6, 8] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.buckets.set(labelTask.layers);
                    this.mMapPosition = labelTask.pos;
                    this.compile();
                    return;
                }
                if (!this.mWorker.isRunning()) {
                    this.mWorker.submit(50L);
                }
                return;
            }
        }
    }
}

