/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.vector;

import org.oscim.core.Box;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.map.Viewport;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.utils.async.SimpleWorker;
import org.oscim.utils.geom.TileClipper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVectorLayer<T>
extends Layer
implements Map.UpdateListener {
    protected static final double UNSCALE_COORD = 4.0;
    public static final Logger log = LoggerFactory.getLogger(AbstractVectorLayer.class);
    protected final TileClipper mClipper;
    protected final GeometryBuffer mGeom = new GeometryBuffer(128, 4);
    protected boolean mUpdate = true;
    protected long mUpdateDelay = 50L;
    protected final Worker mWorker;

    public AbstractVectorLayer(Map map) {
        super(map);
        this.mClipper = new TileClipper(-1024.0f, -1024.0f, 1024.0f, 1024.0f);
        this.mWorker = new Worker(this.mMap);
        this.mRenderer = new Renderer();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.mWorker.cancel(true);
    }

    @Override
    public void onMapEvent(Event event, MapPosition mapPosition) {
        if (this.mUpdate) {
            this.mUpdate = false;
            this.mWorker.submit(0L);
        } else if (event == Map.POSITION_EVENT || event == Map.CLEAR_EVENT) {
            this.mWorker.submit(this.mUpdateDelay);
        }
    }

    protected abstract void processFeatures(Task var1, Box var2);

    public void update() {
        this.mWorker.submit(0L);
    }

    public class Renderer
    extends BucketRenderer {
        MapPosition mTmpPos = new MapPosition();

        public Renderer() {
            this.mFlipOnDateLine = true;
        }

        @Override
        public void update(GLViewport object) {
            object = (Task)AbstractVectorLayer.this.mWorker.poll();
            if (object == null) {
                return;
            }
            this.mMapPosition.copy(((Task)object).position);
            this.mMapPosition.setScale(this.mMapPosition.scale / 4.0);
            this.buckets.setFrom(((Task)object).buckets);
            this.compile();
        }
    }

    protected static class Task {
        public final RenderBuckets buckets = new RenderBuckets();
        public final MapPosition position = new MapPosition();

        protected Task() {
        }
    }

    protected class Worker
    extends SimpleWorker<Task> {
        public Worker(Map map) {
            super(map, 50L, new Task(), new Task());
        }

        @Override
        public void cleanup(Task task) {
            if (task.buckets != null) {
                task.buckets.clear();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean doWork(Task task) {
            Box box;
            float[] fArray = new float[8];
            Viewport viewport = this.mMap.viewport().getSyncViewport();
            synchronized (viewport) {
                box = viewport.getBBox(null, 0);
                viewport.getMapExtents(fArray, 0.0f);
                viewport.getMapPosition(task.position);
            }
            box.map2mercator();
            AbstractVectorLayer.this.processFeatures(task, box);
            task.buckets.prepare();
            this.mMap.render();
            return true;
        }
    }
}

