/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.vector;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MercatorProjection;

public class JtsConverter {
    private final Coordinate mTmpCoord = new Coordinate();
    final double outScale;
    double scale;
    double x;
    double y;

    public JtsConverter(double d) {
        this.outScale = d;
    }

    public void addPoint(GeometryBuffer geometryBuffer, double d, double d2) {
        geometryBuffer.addPoint((float)((MercatorProjection.longitudeToX(d) - this.x) * this.scale), (float)((MercatorProjection.latitudeToY(d2) - this.y) * this.scale));
    }

    public void addPoint(GeometryBuffer geometryBuffer, Coordinate coordinate) {
        geometryBuffer.addPoint((float)((MercatorProjection.longitudeToX(coordinate.x) - this.x) * this.scale), (float)((MercatorProjection.latitudeToY(coordinate.y) - this.y) * this.scale));
    }

    public void setPosition(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.scale = d3 * this.outScale;
    }

    public void transformLineString(GeometryBuffer geometryBuffer, LineString lineString) {
        Coordinate coordinate = this.mTmpCoord;
        lineString = lineString.getCoordinateSequence();
        geometryBuffer.startLine();
        int n = lineString.size();
        for (int i = 0; i < n; ++i) {
            lineString.getCoordinate(i, coordinate);
            this.addPoint(geometryBuffer, coordinate);
        }
    }

    public void transformPoint(GeometryBuffer geometryBuffer, Point point) {
        Coordinate coordinate = this.mTmpCoord;
        geometryBuffer.startPoints();
        coordinate.x = point.getX();
        coordinate.y = point.getY();
        this.addPoint(geometryBuffer, coordinate);
    }

    public void transformPolygon(GeometryBuffer geometryBuffer, Polygon polygon) {
        int n;
        Coordinate coordinate = this.mTmpCoord;
        CoordinateSequence coordinateSequence = polygon.getExteriorRing().getCoordinateSequence();
        geometryBuffer.startPolygon();
        for (n = 0; n < coordinateSequence.size() - 1; ++n) {
            coordinateSequence.getCoordinate(n, coordinate);
            this.addPoint(geometryBuffer, coordinate);
        }
        int n2 = polygon.getNumInteriorRing();
        for (n = 0; n < n2; ++n) {
            geometryBuffer.startHole();
            coordinateSequence = polygon.getInteriorRingN(n).getCoordinateSequence();
            for (int i = 0; i < coordinateSequence.size() - 1; ++i) {
                coordinateSequence.getCoordinate(i, coordinate);
                this.addPoint(geometryBuffer, coordinate);
            }
        }
    }
}

