/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.vector;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.oscim.backend.CanvasAdapter;
import org.oscim.core.GeoPoint;
import org.oscim.core.Point;
import org.oscim.layers.vector.VectorLayer;
import org.oscim.layers.vector.geometries.Drawable;
import org.oscim.layers.vector.geometries.LineDrawable;
import org.oscim.layers.vector.geometries.Style;
import org.oscim.map.Map;
import org.oscim.map.ViewController;
import org.oscim.utils.GeoPointUtils;
import org.oscim.utils.geom.GeomBuilder;

public class PathLayer
extends VectorLayer {
    protected LineDrawable mDrawable;
    private final Point mPoint1 = new Point();
    private final Point mPoint2 = new Point();
    protected final ArrayList<GeoPoint> mPoints;
    protected Style mStyle;

    public PathLayer(Map map, int n) {
        this(map, n, 2.0f);
    }

    public PathLayer(Map map, int n, float f) {
        this(map, Style.builder().fixed(true).strokeColor(n).strokeWidth(f).build());
    }

    public PathLayer(Map map, Style style2) {
        super(map);
        this.mStyle = style2;
        this.mPoints = new ArrayList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updatePoints() {
        synchronized (this) {
            LineDrawable lineDrawable = this.mDrawable;
            if (lineDrawable != null) {
                this.remove(lineDrawable);
                this.mDrawable = null;
            }
            if (!this.mPoints.isEmpty()) {
                this.mDrawable = lineDrawable = new LineDrawable(this.mPoints, this.mStyle);
                if (lineDrawable.getGeometry() == null) {
                    this.mDrawable = null;
                } else {
                    this.add(this.mDrawable);
                }
            }
        }
        this.mWorker.submit(0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addGreatCircle(GeoPoint geoPoint, GeoPoint geoPoint2) {
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            int n = (int)(geoPoint.sphericalDistance(geoPoint2) / 100000.0);
            if (n == 0) {
                return;
            }
            this.addGreatCircle(geoPoint, geoPoint2, n);
            return;
        }
    }

    public void addGreatCircle(GeoPoint geoPoint, GeoPoint geoPoint2, int n) {
        GeomBuilder geomBuilder = new GeomBuilder();
        double d = geoPoint.getLatitude() * Math.PI / 180.0;
        double d2 = geoPoint.getLongitude() * Math.PI / 180.0;
        double d3 = geoPoint2.getLatitude() * Math.PI / 180.0;
        double d4 = geoPoint2.getLongitude() * Math.PI / 180.0;
        double d5 = Math.pow(Math.sin((d - d3) / 2.0), 2.0);
        double d6 = Math.cos(d);
        double d7 = Math.cos(d3);
        double d8 = d2 - d4;
        d7 = Math.asin(Math.sqrt(d5 + d6 * d7 * Math.pow(Math.sin(d8 / 2.0), 2.0))) * 2.0;
        Math.atan2(Math.sin(d8) * Math.cos(d3), Math.cos(d) * Math.sin(d3) - Math.sin(d) * Math.cos(d3) * Math.cos(d8));
        for (int i = 0; i < n + 1; ++i) {
            d6 = 1.0 / (double)n * (double)i;
            d8 = Math.sin((1.0 - d6) * d7) / Math.sin(d7);
            double d9 = Math.sin(d6 * d7) / Math.sin(d7);
            d6 = Math.cos(d) * d8 * Math.cos(d2) + Math.cos(d3) * d9 * Math.cos(d4);
            d5 = Math.cos(d) * d8 * Math.sin(d2) + Math.cos(d3) * d9 * Math.sin(d4);
            d8 = Math.atan2(d8 * Math.sin(d) + d9 * Math.sin(d3), Math.sqrt(Math.pow(d6, 2.0) + Math.pow(d5, 2.0)));
            d6 = Math.atan2(d5, d6);
            geomBuilder.point(d8 / (Math.PI / 180), d6 / (Math.PI / 180));
        }
        this.setLineString(geomBuilder.toLineString());
    }

    public void addPoint(int n, int n2) {
        this.mPoints.add(new GeoPoint(n, n2));
        this.updatePoints();
    }

    public void addPoint(GeoPoint geoPoint) {
        this.mPoints.add(geoPoint);
        this.updatePoints();
    }

    public void addPoints(Collection<? extends GeoPoint> collection) {
        this.mPoints.addAll(collection);
        this.updatePoints();
    }

    public void clearPath() {
        if (!this.mPoints.isEmpty()) {
            this.mPoints.clear();
        }
        this.updatePoints();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(float f, float f2) {
        synchronized (this) {
            PathLayer pathLayer;
            double d;
            double d2 = Math.max(CanvasAdapter.getScale() * 10.0f, this.mStyle.strokeWidth);
            int n = 0;
            do {
                pathLayer = this;
                if (n >= pathLayer.mPoints.size() - 1) {
                    return false;
                }
                if (n == 0) {
                    pathLayer.mMap.viewport().toScreenPoint(pathLayer.mPoints.get(n), false, pathLayer.mPoint1);
                } else {
                    pathLayer.mPoint1.x = pathLayer.mPoint2.x;
                    pathLayer.mPoint1.y = pathLayer.mPoint2.y;
                }
                ViewController viewController = pathLayer.mMap.viewport();
                ArrayList<GeoPoint> arrayList = pathLayer.mPoints;
                viewController.toScreenPoint(arrayList.get(++n), false, pathLayer.mPoint2);
            } while (!((d = GeoPointUtils.distanceSegmentPoint(pathLayer.mPoint1.x, pathLayer.mPoint1.y, pathLayer.mPoint2.x, pathLayer.mPoint2.y, f, f2)) <= d2));
            return true;
        }
    }

    public List<GeoPoint> getPoints() {
        return this.mPoints;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLineString(LineString lineString) {
        synchronized (this) {
            Object object = this.mDrawable;
            if (object != null) {
                this.remove((Drawable)object);
            }
            object = new LineDrawable((Geometry)lineString, this.mStyle);
            this.mDrawable = object;
            this.add((Drawable)object);
            this.mPoints.clear();
            int n = 0;
            while (true) {
                if (n >= lineString.getNumPoints()) {
                    // MONITOREXIT @DISABLED, blocks:[3, 4, 5] lbl12 : MonitorExitStatement: MONITOREXIT : this
                    this.mWorker.submit(0L);
                    return;
                }
                Coordinate coordinate = lineString.getCoordinateN(n);
                ArrayList<GeoPoint> arrayList = this.mPoints;
                object = new GeoPoint(coordinate.y, coordinate.x);
                arrayList.add((GeoPoint)object);
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLineString(double[] dArray) {
        synchronized (this) {
            Object object = this.mDrawable;
            if (object != null) {
                this.remove((Drawable)object);
            }
            object = new LineDrawable(dArray, this.mStyle);
            this.mDrawable = object;
            this.add((Drawable)object);
            this.mPoints.clear();
            int n = 0;
            while (true) {
                if (n >= dArray.length) {
                    // MONITOREXIT @DISABLED, blocks:[3, 4, 5] lbl12 : MonitorExitStatement: MONITOREXIT : this
                    this.mWorker.submit(0L);
                    return;
                }
                object = this.mPoints;
                GeoPoint geoPoint = new GeoPoint(dArray[n + 1], dArray[n]);
                ((ArrayList)object).add(geoPoint);
                n += 2;
            }
        }
    }

    public void setPoints(Collection<? extends GeoPoint> collection) {
        this.mPoints.clear();
        this.mPoints.addAll(collection);
        this.updatePoints();
    }

    public void setStyle(Style style2) {
        this.mStyle = style2;
    }
}

