/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.vector;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.oscim.backend.canvas.Color;
import org.oscim.core.Box;
import org.oscim.core.GeoPoint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tile;
import org.oscim.event.Gesture;
import org.oscim.event.GestureListener;
import org.oscim.event.MotionEvent;
import org.oscim.layers.vector.AbstractVectorLayer;
import org.oscim.layers.vector.JtsConverter;
import org.oscim.layers.vector.geometries.Drawable;
import org.oscim.layers.vector.geometries.LineDrawable;
import org.oscim.layers.vector.geometries.PointDrawable;
import org.oscim.layers.vector.geometries.Style;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.MeshBucket;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.utils.FastMath;
import org.oscim.utils.QuadTree;
import org.oscim.utils.SpatialIndex;
import org.oscim.utils.geom.GeomBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorLayer
extends AbstractVectorLayer<Drawable>
implements GestureListener {
    public static final Logger log = LoggerFactory.getLogger(VectorLayer.class);
    protected final JtsConverter mConverter;
    protected final SpatialIndex<Drawable> mDrawables = new QuadTree<Drawable>(0x40000000, 18);
    protected Polygon mEnvelope;
    protected double mMinX;
    protected double mMinY;
    protected final List<Drawable> tmpDrawables = new ArrayList<Drawable>(128);

    public VectorLayer(Map map) {
        super(map);
        this.mConverter = new JtsConverter((double)Tile.SIZE / 4.0);
    }

    public VectorLayer(Map map, SpatialIndex<Drawable> spatialIndex) {
        this(map);
    }

    private static Box bbox(Geometry object, Style style2) {
        object = object.getEnvelopeInternal();
        object = new Box(object.getMinX(), object.getMinY(), object.getMaxX(), object.getMaxY());
        ((Box)object).scale(1000000.0);
        return object;
    }

    public void add(Geometry geometry, Style style2) {
        synchronized (this) {
            SpatialIndex<Drawable> spatialIndex = this.mDrawables;
            Box box = VectorLayer.bbox(geometry, style2);
            GeometryWithStyle geometryWithStyle = new GeometryWithStyle(geometry, style2);
            spatialIndex.insert(box, geometryWithStyle);
            return;
        }
    }

    public void add(Drawable drawable2) {
        this.mDrawables.insert(VectorLayer.bbox(drawable2.getGeometry(), drawable2.getStyle()), drawable2);
    }

    protected void addCircle(GeometryBuffer geometryBuffer, MapPosition mapPosition, double d, double d2, Style style2) {
        double d3 = mapPosition.scale * (double)Tile.SIZE / 4.0;
        double d4 = MercatorProjection.longitudeToX(d);
        double d5 = mapPosition.x;
        double d6 = MercatorProjection.latitudeToY(d2);
        double d7 = mapPosition.y;
        int n = style2.scalingZoomLevel;
        d2 = style2.buffer;
        double d8 = mapPosition.scale;
        double d9 = 1 << n;
        d = d2;
        if (d8 > d9) {
            d = d2 * 0.01 / d9 * (d3 - d9);
        }
        int n2 = FastMath.clamp((int)(Math.sqrt(d) * 8.0), 4, 32);
        d8 = Math.PI * 2 / (double)n2;
        geometryBuffer.startPolygon();
        for (n = 0; n < n2; ++n) {
            d2 = (double)n * d8;
            geometryBuffer.addPoint((float)(Math.cos(d2) * d + (d4 - d5) * d3), (float)(Math.sin(d2) * d + (d6 - d7) * d3));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(float f, float f2) {
        synchronized (this) {
            boolean bl;
            GeoPoint geoPoint = this.mMap.viewport().fromScreenPoint(f, f2);
            Object object = new GeomBuilder();
            geoPoint = ((GeomBuilder)object).point(geoPoint.getLongitude(), geoPoint.getLatitude()).toPoint();
            object = this.tmpDrawables.iterator();
            do {
                if (object.hasNext()) continue;
                return false;
            } while (!(bl = ((Drawable)object.next()).getGeometry().contains((Geometry)geoPoint)));
            return true;
        }
    }

    protected void draw(AbstractVectorLayer.Task task, int n, Drawable drawable2, Style style2) {
        Geometry geometry = drawable2.getGeometry();
        if (drawable2 instanceof LineDrawable) {
            this.drawLine(task, n, geometry, style2);
        } else if (drawable2 instanceof PointDrawable) {
            this.drawPoint(task, n, geometry, style2);
        } else {
            this.drawPolygon(task, n, geometry, style2);
        }
    }

    protected void drawLine(AbstractVectorLayer.Task object, int n, Geometry geometry, Style style2) {
        object = style2.stipple == 0 && style2.texture == null ? ((AbstractVectorLayer.Task)object).buckets.getLineBucket(n) : ((AbstractVectorLayer.Task)object).buckets.getLineTexBucket(n);
        LineStyle lineStyle = ((LineBucket)object).line;
        int n2 = 0;
        if (lineStyle == null) {
            ((LineBucket)object).line = ((LineStyle.LineBuilder)((LineStyle.LineBuilder)((RenderStyle.StyleBuilder)((LineStyle.LineBuilder)((LineStyle.LineBuilder)((LineStyle.LineBuilder)((LineStyle.LineBuilder)((RenderStyle.StyleBuilder)((LineStyle.LineBuilder)((LineStyle.LineBuilder)((RenderStyle.StyleBuilder)((LineStyle.LineBuilder)LineStyle.builder().reset()).cap(style2.cap)).color(style2.strokeColor)).fixed(style2.fixed)).heightOffset(style2.heightOffset)).level(0)).randomOffset(style2.randomOffset)).stipple(style2.stipple)).stippleColor(style2.stippleColor)).stippleWidth(style2.stippleWidth)).strokeWidth(style2.strokeWidth)).texture(style2.texture)).build();
        }
        n = n2;
        lineStyle = geometry;
        if (style2.generalization != 0) {
            lineStyle = DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)(this.mMinX * (double)style2.generalization));
            n = n2;
        }
        while (n < lineStyle.getNumGeometries()) {
            this.mConverter.transformLineString(this.mGeom.clear(), (LineString)lineStyle.getGeometryN(n));
            if (this.mClipper.clip(this.mGeom)) {
                ((LineBucket)object).addLine(this.mGeom);
            }
            ++n;
        }
    }

    protected void drawPoint(AbstractVectorLayer.Task task, int n, Geometry geometry, Style style2) {
        MeshBucket meshBucket = task.buckets.getMeshBucket(n);
        if (meshBucket.area == null) {
            meshBucket.area = new AreaStyle(Color.fade(style2.fillColor, style2.fillAlpha));
        }
        LineBucket lineBucket = task.buckets.getLineBucket(n + 1);
        if (lineBucket.line == null) {
            lineBucket.line = new LineStyle(2, style2.strokeColor, style2.strokeWidth);
        }
        for (n = 0; n < geometry.getNumGeometries(); ++n) {
            Point point = (Point)geometry.getGeometryN(n);
            this.addCircle(this.mGeom.clear(), task.position, point.getX(), point.getY(), style2);
            if (!this.mClipper.clip(this.mGeom)) continue;
            meshBucket.addConvexMesh(this.mGeom);
            lineBucket.addLine(this.mGeom);
        }
    }

    protected void drawPolygon(AbstractVectorLayer.Task task, int n, Geometry geometry, Style style2) {
        MeshBucket meshBucket = task.buckets.getMeshBucket(n);
        if (meshBucket.area == null) {
            meshBucket.area = new AreaStyle(Color.fade(style2.fillColor, style2.fillAlpha));
        }
        LineBucket lineBucket = task.buckets.getLineBucket(n + 1);
        if (lineBucket.line == null) {
            lineBucket.line = new LineStyle(2, style2.strokeColor, style2.strokeWidth);
        }
        task = geometry;
        if (style2.generalization != 0) {
            task = DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)(this.mMinX * (double)style2.generalization));
        }
        for (n = 0; n < task.getNumGeometries(); ++n) {
            this.mConverter.transformPolygon(this.mGeom.clear(), (Polygon)task.getGeometryN(n));
            if (this.mGeom.getNumPoints() < 3 || !this.mClipper.clip(this.mGeom)) continue;
            meshBucket.addMesh(this.mGeom);
            lineBucket.addLine(this.mGeom);
        }
    }

    @Override
    public boolean onGesture(Gesture gesture, MotionEvent motionEvent) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void processFeatures(AbstractVectorLayer.Task task, Box object) {
        if (Double.isNaN(((Box)object).xmin)) {
            return;
        }
        this.mMinX = (((Box)object).xmax - ((Box)object).xmin) / (double)this.mMap.getWidth();
        this.mMinY = (((Box)object).ymax - ((Box)object).ymin) / (double)this.mMap.getHeight();
        this.mConverter.setPosition(task.position.x, task.position.y, task.position.scale);
        ((Box)object).scale(1000000.0);
        int n = 0;
        Style style2 = null;
        synchronized (this) {
            this.tmpDrawables.clear();
            this.mDrawables.search((Box)object, this.tmpDrawables);
            Iterator<Drawable> iterator2 = this.tmpDrawables.iterator();
            object = style2;
            while (iterator2.hasNext()) {
                Drawable drawable2 = iterator2.next();
                style2 = drawable2.getStyle();
                this.draw(task, n, drawable2, style2);
                int n2 = n;
                if (style2 != object) {
                    n2 = n + 2;
                }
                object = style2;
                n = n2;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void remove(Geometry geometry) {
        // MONITORENTER : this
        Drawable drawable2 = null;
        Box box = VectorLayer.bbox(geometry, null);
        // MONITORENTER : this
        this.tmpDrawables.clear();
        this.mDrawables.search(box, this.tmpDrawables);
        for (Drawable drawable3 : this.tmpDrawables) {
            if (drawable3.getGeometry() != geometry) continue;
            drawable2 = drawable3;
        }
        // MONITOREXIT : this
        if (drawable2 == null) {
            log.error("Can't find geometry to remove.");
            // MONITOREXIT : this
            return;
        }
        this.mDrawables.remove(box, drawable2);
        // MONITOREXIT : this
    }

    public void remove(Drawable drawable2) {
        synchronized (this) {
            this.mDrawables.remove(VectorLayer.bbox(drawable2.getGeometry(), drawable2.getStyle()), drawable2);
            return;
        }
    }

    private static class GeometryWithStyle
    implements Drawable {
        final Geometry geometry;
        final Style style;

        GeometryWithStyle(Geometry geometry, Style style2) {
            this.geometry = geometry;
            this.style = style2;
        }

        @Override
        public Geometry getGeometry() {
            return this.geometry;
        }

        @Override
        public Style getStyle() {
            return this.style;
        }
    }
}

