/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.vector.geometries;

import org.oscim.core.GeoPoint;
import org.oscim.layers.vector.geometries.JtsDrawable;
import org.oscim.layers.vector.geometries.Style;
import org.oscim.utils.geom.GeomBuilder;

public class CircleDrawable
extends JtsDrawable {
    public static int HIGH_QUALITY = 64;
    public static int MEDIUM_QUALITY = 32;

    public CircleDrawable(GeoPoint geoPoint, double d) {
        super(Style.DEFAULT_STYLE);
        int n;
        GeomBuilder geomBuilder = new GeomBuilder();
        for (int i = 0; i < (n = MEDIUM_QUALITY); ++i) {
            GeoPoint geoPoint2 = CircleDrawable.findGeoPointWithGivenDistance(geoPoint, (double)i * Math.PI / (double)n * 2.0, d);
            geomBuilder.points(geoPoint2.getLongitude(), geoPoint2.getLatitude());
        }
        this.geometry = geomBuilder.toPolygon();
    }

    public CircleDrawable(GeoPoint geoPoint, double d, int n, Style object) {
        super((Style)object);
        object = new GeomBuilder();
        for (int i = 0; i < n; ++i) {
            GeoPoint geoPoint2 = CircleDrawable.findGeoPointWithGivenDistance(geoPoint, (double)i * Math.PI / (double)n * 2.0, d);
            ((GeomBuilder)object).points(geoPoint2.getLongitude(), geoPoint2.getLatitude());
        }
        this.geometry = ((GeomBuilder)object).toPolygon();
    }

    public CircleDrawable(GeoPoint geoPoint, double d, Style object) {
        super((Style)object);
        int n;
        object = new GeomBuilder();
        for (int i = 0; i < (n = MEDIUM_QUALITY); ++i) {
            GeoPoint geoPoint2 = CircleDrawable.findGeoPointWithGivenDistance(geoPoint, (double)i * Math.PI / (double)n * 2.0, d);
            ((GeomBuilder)object).points(geoPoint2.getLongitude(), geoPoint2.getLatitude());
        }
        this.geometry = ((GeomBuilder)object).toPolygon();
    }

    private static double degreesToRadians(double d) {
        return d * (Math.PI / 180);
    }

    private static GeoPoint findGeoPointWithGivenDistance(GeoPoint geoPoint, double d, double d2) {
        double d3 = d2 / 6371.01;
        d2 = Math.sin(d3);
        double d4 = Math.cos(d3);
        double d5 = CircleDrawable.degreesToRadians(geoPoint.getLatitude());
        d3 = CircleDrawable.degreesToRadians(geoPoint.getLongitude());
        double d6 = Math.cos(d5);
        double d7 = Math.sin(d5);
        d5 = Math.asin(d7 * d4 + d6 * d2 * Math.cos(d));
        d = Math.atan2(Math.sin(d) * d2 * d6, d4 - d7 * Math.sin(d5));
        return new GeoPoint(CircleDrawable.radiansToDegrees(d5), CircleDrawable.radiansToDegrees(d3 + d));
    }

    private static double radiansToDegrees(double d) {
        return d * 57.29577951308232;
    }
}

