/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.vector.geometries;

import org.oscim.core.GeoPoint;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.layers.vector.geometries.JtsDrawable;
import org.oscim.layers.vector.geometries.Style;
import org.oscim.utils.geom.GeomBuilder;

public class HexagonDrawable
extends JtsDrawable {
    public HexagonDrawable(GeoPoint geoPoint, double d) {
        super(Style.DEFAULT_STYLE);
        GeomBuilder geomBuilder = new GeomBuilder();
        for (int i = 0; i < 6; ++i) {
            GeoPoint geoPoint2 = HexagonDrawable.findGeoPointWithGivenDistance(geoPoint, (double)i * Math.PI / 3.0, d);
            geomBuilder.points(geoPoint2.getLongitude(), geoPoint2.getLatitude());
        }
        this.geometry = geomBuilder.toPolygon();
    }

    public HexagonDrawable(GeoPoint geoPoint, double d, double d2, Style object) {
        super((Style)object);
        GeomBuilder geomBuilder = new GeomBuilder();
        object = new Point();
        for (int i = 0; i < 6; ++i) {
            MercatorProjection.project(HexagonDrawable.findGeoPointWithGivenDistance(geoPoint, (double)i * Math.PI / 3.0 + d2, d), (Point)object);
            geomBuilder.points(((Point)object).x, ((Point)object).y);
        }
        this.geometry = geomBuilder.toPolygon();
    }

    private static GeoPoint findGeoPointWithGivenDistance(GeoPoint geoPoint, double d, double d2) {
        double d3 = d2 / 6371.01;
        d2 = Math.sin(d3);
        double d4 = Math.cos(d3);
        double d5 = Math.toRadians(geoPoint.getLatitude());
        d3 = Math.toRadians(geoPoint.getLongitude());
        double d6 = Math.cos(d5);
        double d7 = Math.sin(d5);
        d5 = Math.asin(d7 * d4 + d6 * d2 * Math.cos(d));
        d = Math.atan2(Math.sin(d) * d2 * d6, d4 - d7 * Math.sin(d5));
        return new GeoPoint(Math.toDegrees(d5), Math.toDegrees(d3 + d));
    }
}

