/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.vector.geometries;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import java.util.List;
import org.oscim.core.GeoPoint;
import org.oscim.layers.vector.geometries.JtsDrawable;
import org.oscim.layers.vector.geometries.Style;

public class LineDrawable
extends JtsDrawable {
    public LineDrawable(Geometry geometry, Style style2) {
        super(style2);
        if (geometry.getDimension() == 1) {
            this.geometry = geometry;
            return;
        }
        throw new IllegalArgumentException("Geometry not a Line");
    }

    public LineDrawable(List<GeoPoint> list) {
        this(list, Style.defaultStyle());
    }

    public LineDrawable(List<GeoPoint> object, Style object2) {
        super((Style)object2);
        if (object.size() < 2) {
            return;
        }
        object2 = new double[object.size() * 2];
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            GeoPoint geoPoint = (GeoPoint)object.next();
            int n2 = n + 1;
            object2[n] = geoPoint.getLongitude();
            n = n2 + 1;
            object2[n2] = geoPoint.getLatitude();
        }
        this.geometry = new LineString(coordFactory.create((double[])object2, 2), geomFactory);
    }

    public LineDrawable(double[] dArray, Style style2) {
        this((Geometry)new LineString(coordFactory.create(dArray, 2), geomFactory), style2);
    }
}

