/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.vector.geometries;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Arrays;
import java.util.List;
import org.oscim.core.GeoPoint;
import org.oscim.layers.vector.geometries.JtsDrawable;
import org.oscim.layers.vector.geometries.Style;
import org.oscim.utils.geom.GeomBuilder;

public class PolygonDrawable
extends JtsDrawable {
    public PolygonDrawable(Geometry geometry, Style style2) {
        super(style2);
        if (geometry.getDimension() == 2) {
            this.geometry = geometry;
            return;
        }
        throw new IllegalArgumentException("Geometry not a Polygon");
    }

    public PolygonDrawable(List<GeoPoint> list) {
        this(list, Style.defaultStyle());
    }

    public PolygonDrawable(List<GeoPoint> list, List<GeoPoint> list2, float f, int n, int n2, float f2) {
        this(list, list2, new Style.Builder().strokeWidth(f).strokeColor(n).fillColor(n2).fillAlpha(f2).build());
    }

    public PolygonDrawable(List<GeoPoint> list, List<GeoPoint> list2, Style style2) {
        super(style2);
        GeomBuilder geomBuilder = new GeomBuilder();
        PolygonDrawable.loadPoints(geomBuilder, list).ring();
        PolygonDrawable.loadPoints(geomBuilder, list2).ring();
        this.geometry = geomBuilder.toPolygon();
        this.style = style2;
    }

    public PolygonDrawable(List<GeoPoint> list, Style style2) {
        this((Geometry)PolygonDrawable.loadPoints(new GeomBuilder(), list).toPolygon(), style2);
    }

    public PolygonDrawable(Style style2, GeoPoint ... geoPointArray) {
        this(Arrays.asList(geoPointArray), style2);
    }

    public PolygonDrawable(GeoPoint[] geoPointArray, GeoPoint[] geoPointArray2, float f, int n, int n2, float f2) {
        this(Arrays.asList(geoPointArray), Arrays.asList(geoPointArray2), f, n, n2, f2);
    }
}

