/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.vector.geometries;

import org.oscim.backend.canvas.Color;
import org.oscim.backend.canvas.Paint;
import org.oscim.renderer.bucket.TextureItem;

public class Style {
    static final Style DEFAULT_STYLE = new Builder().fillColor(-858993460).fillAlpha(1.0f).build();
    public static final int GENERALIZATION_HIGH = 8;
    public static final int GENERALIZATION_MEDIUM = 4;
    public static final int GENERALIZATION_NONE = 0;
    public static final int GENERALIZATION_SMALL = 1;
    public final double buffer;
    public final Paint.Cap cap;
    public final float fillAlpha;
    public final int fillColor;
    public final boolean fixed;
    public final int generalization;
    public final float heightOffset;
    public final boolean randomOffset;
    public final int scalingZoomLevel;
    public final int stipple;
    public final int stippleColor;
    public final float stippleWidth;
    public final int strokeColor;
    public final float strokeWidth;
    public final TextureItem texture;

    private Style(Builder builder) {
        this.strokeWidth = builder.strokeWidth;
        this.strokeColor = builder.strokeColor;
        this.fillColor = builder.fillColor;
        this.fillAlpha = builder.fillAlpha;
        this.buffer = builder.buffer;
        this.scalingZoomLevel = builder.scalingZoomLevel;
        this.generalization = builder.generalization;
        this.cap = builder.cap;
        this.fixed = builder.fixed;
        this.stipple = builder.stipple;
        this.stippleColor = builder.stippleColor;
        this.stippleWidth = builder.stippleWidth;
        this.texture = builder.texture;
        this.heightOffset = builder.heightOffset;
        this.randomOffset = builder.randomOffset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Style defaultStyle() {
        return DEFAULT_STYLE;
    }

    public static class Builder {
        private double buffer = 1.0;
        public Paint.Cap cap = Paint.Cap.ROUND;
        private float fillAlpha = 0.25f;
        private int fillColor = -7829368;
        public boolean fixed = false;
        private int generalization = 0;
        public float heightOffset = 0.0f;
        public boolean randomOffset = true;
        private int scalingZoomLevel = 1;
        public int stipple = 0;
        public int stippleColor = -7829368;
        public float stippleWidth = 1.0f;
        private int strokeColor = -7829368;
        private float strokeWidth = 1.0f;
        public TextureItem texture = null;

        protected Builder() {
        }

        public Builder buffer(double d) {
            this.buffer = d;
            return this;
        }

        public Style build() {
            return new Style(this);
        }

        public Builder cap(Paint.Cap cap) {
            this.cap = cap;
            return this;
        }

        public Builder fillAlpha(float f) {
            this.fillAlpha = f;
            return this;
        }

        public Builder fillColor(int n) {
            this.fillColor = n;
            return this;
        }

        public Builder fillColor(String string2) {
            this.fillColor = Color.parseColor(string2);
            return this;
        }

        public Builder fixed(boolean bl) {
            this.fixed = bl;
            return this;
        }

        public Builder generalization(int n) {
            this.generalization = n;
            return this;
        }

        public Builder heightOffset(float f) {
            this.heightOffset = f;
            return this;
        }

        public Builder randomOffset(boolean bl) {
            this.randomOffset = bl;
            return this;
        }

        public Builder scaleZoomLevel(int n) {
            this.scalingZoomLevel = n;
            return this;
        }

        public Builder stipple(int n) {
            this.stipple = n;
            return this;
        }

        public Builder stippleColor(int n) {
            this.stippleColor = n;
            return this;
        }

        public Builder stippleColor(String string2) {
            this.stippleColor = Color.parseColor(string2);
            return this;
        }

        public Builder stippleWidth(float f) {
            this.stippleWidth = f;
            return this;
        }

        public Builder strokeColor(int n) {
            this.strokeColor = n;
            return this;
        }

        public Builder strokeColor(String string2) {
            this.strokeColor = Color.parseColor(string2);
            return this;
        }

        public Builder strokeWidth(float f) {
            this.strokeWidth = f;
            return this;
        }

        public Builder texture(TextureItem textureItem) {
            this.texture = textureItem;
            return this;
        }
    }
}

