/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.map;

import org.oscim.backend.CanvasAdapter;
import org.oscim.core.BoundingBox;
import org.oscim.core.GeoPoint;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.map.Map;
import org.oscim.map.ViewController;
import org.oscim.renderer.MapRenderer;
import org.oscim.utils.Easing;
import org.oscim.utils.FastMath;
import org.oscim.utils.ThreadUtils;
import org.oscim.utils.async.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Animator {
    public static final int ANIM_FLING = 16;
    public static final int ANIM_MOVE = 1;
    public static final int ANIM_NONE = 0;
    public static final int ANIM_ROTATE = 4;
    public static final int ANIM_SCALE = 2;
    public static final int ANIM_TILT = 8;
    static final Logger log = LoggerFactory.getLogger(Animator.class);
    private long mAnimEnd = -1L;
    private final MapPosition mCurPos = new MapPosition();
    private final MapPosition mDeltaPos;
    private float mDuration = 500.0f;
    private Easing.Type mEasingType;
    private final Map mMap;
    private final Point mPivot;
    private final Point mScroll;
    private final MapPosition mStartPos = new MapPosition();
    private int mState = 0;
    private final Point mVelocity;
    private Task updateTask;

    public Animator(Map map) {
        this.mDeltaPos = new MapPosition();
        this.mScroll = new Point();
        this.mPivot = new Point();
        this.mVelocity = new Point();
        this.mEasingType = Easing.Type.LINEAR;
        this.updateTask = new Task(){

            @Override
            public int go(boolean bl) {
                if (!bl) {
                    Animator.this.updateAnimation();
                }
                return 2;
            }
        };
        this.mMap = map;
    }

    private void animStart(float f, int n, Easing.Type type) {
        if (!this.isActive()) {
            this.mMap.events.fire(Map.ANIM_START, this.mMap.mMapPosition);
        }
        this.mCurPos.copy(this.mStartPos);
        this.mState = n;
        this.mDuration = f;
        this.mAnimEnd = System.currentTimeMillis() + (long)f;
        this.mEasingType = type;
        this.mMap.render();
    }

    private double doScale(ViewController viewController, float f) {
        double d = this.mStartPos.scale + this.mDeltaPos.scale * Math.sqrt(f);
        viewController.scaleMap((float)(d / this.mCurPos.scale), (float)this.mPivot.x, (float)this.mPivot.y);
        return d / (this.mStartPos.scale + this.mDeltaPos.scale);
    }

    public void animateFling(float f, float f2, int n, int n2, int n3, int n4) {
        ThreadUtils.assertMainThread();
        if (f * f + f2 * f2 < 2048.0f) {
            return;
        }
        this.mMap.getMapPosition(this.mStartPos);
        this.mScroll.x = 0.0;
        this.mScroll.y = 0.0;
        float f3 = 160.0f / CanvasAdapter.dpi;
        this.mVelocity.x = f * f3;
        this.mVelocity.y = f2 * f3;
        Point point = this.mVelocity;
        point.x = FastMath.clamp(point.x, (double)n, (double)n2);
        point = this.mVelocity;
        point.y = FastMath.clamp(point.y, (double)n3, (double)n4);
        if (!Double.isNaN(this.mVelocity.x) && !Double.isNaN(this.mVelocity.y)) {
            this.animStart(500.0f, 16, Easing.Type.LINEAR);
            return;
        }
        log.debug("fling NaN!");
    }

    public void animateTo(long l, BoundingBox boundingBox) {
        synchronized (this) {
            this.animateTo(l, boundingBox, Easing.Type.LINEAR);
            return;
        }
    }

    public void animateTo(long l, BoundingBox boundingBox, Easing.Type type) {
        synchronized (this) {
            this.animateTo(l, boundingBox, type, 15);
            return;
        }
    }

    public void animateTo(long l, BoundingBox object, Easing.Type type, int n) {
        synchronized (this) {
            ThreadUtils.assertMainThread();
            this.mMap.getMapPosition(this.mStartPos);
            double d = Math.abs(MercatorProjection.longitudeToX(((BoundingBox)object).getMaxLongitude()) - MercatorProjection.longitudeToX(((BoundingBox)object).getMinLongitude()));
            double d2 = Math.abs(MercatorProjection.latitudeToY(((BoundingBox)object).getMinLatitude()) - MercatorProjection.latitudeToY(((BoundingBox)object).getMaxLatitude()));
            Logger logger = log;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("anim bbox ");
            stringBuilder.append(object);
            logger.debug(stringBuilder.toString());
            d = Math.min((double)this.mMap.getWidth() / (d * (double)Tile.SIZE), (double)this.mMap.getHeight() / (d2 * (double)Tile.SIZE));
            object = ((BoundingBox)object).getCenterPoint();
            this.mDeltaPos.set(MercatorProjection.longitudeToX(((GeoPoint)object).getLongitude()) - this.mStartPos.x, MercatorProjection.latitudeToY(((GeoPoint)object).getLatitude()) - this.mStartPos.y, d - this.mStartPos.scale, -this.mStartPos.bearing, -this.mStartPos.tilt);
            this.animStart(l, n, type);
            return;
        }
    }

    public void animateTo(long l, GeoPoint geoPoint, double d, boolean bl) {
        this.animateTo(l, geoPoint, d, bl, Easing.Type.LINEAR);
    }

    public void animateTo(long l, GeoPoint geoPoint, double d, boolean bl, Easing.Type type) {
        this.animateTo(l, geoPoint, d, bl, type, 3);
    }

    public void animateTo(long l, GeoPoint geoPoint, double d, boolean bl, Easing.Type type, int n) {
        ThreadUtils.assertMainThread();
        this.mMap.getMapPosition(this.mStartPos);
        if (bl) {
            d = this.mStartPos.scale * d;
        }
        d = this.mMap.viewport().limitScale(d);
        this.mDeltaPos.set(MercatorProjection.longitudeToX(geoPoint.getLongitude()) - this.mStartPos.x, MercatorProjection.latitudeToY(geoPoint.getLatitude()) - this.mStartPos.y, d - this.mStartPos.scale, 0.0f, 0.0f);
        this.animStart(l, n, type);
    }

    public void animateTo(long l, MapPosition mapPosition) {
        this.animateTo(l, mapPosition, Easing.Type.LINEAR);
    }

    public void animateTo(long l, MapPosition mapPosition, Easing.Type type) {
        this.animateTo(l, mapPosition, type, 15);
    }

    public void animateTo(long l, MapPosition mapPosition, Easing.Type type, int n) {
        ThreadUtils.assertMainThread();
        this.mMap.getMapPosition(this.mStartPos);
        mapPosition.scale = this.mMap.viewport().limitScale(mapPosition.scale);
        this.mDeltaPos.set(mapPosition.x - this.mStartPos.x, mapPosition.y - this.mStartPos.y, mapPosition.scale - this.mStartPos.scale, mapPosition.bearing - this.mStartPos.bearing, this.mMap.viewport().limitTilt(mapPosition.tilt) - this.mStartPos.tilt);
        this.animStart(l, n, type);
    }

    public void animateTo(BoundingBox boundingBox) {
        this.animateTo(1000L, boundingBox, Easing.Type.LINEAR);
    }

    public void animateTo(GeoPoint geoPoint) {
        this.animateTo(500L, geoPoint, 1.0, true, Easing.Type.LINEAR);
    }

    public void animateZoom(long l, double d, float f, float f2) {
        this.animateZoom(l, d, f, f2, Easing.Type.LINEAR);
    }

    public void animateZoom(long l, double d, float f, float f2, Easing.Type type) {
        ThreadUtils.assertMainThread();
        this.mMap.getMapPosition(this.mCurPos);
        double d2 = this.mState == 2 ? this.mStartPos.scale + this.mDeltaPos.scale : this.mCurPos.scale;
        this.mStartPos.copy(this.mCurPos);
        d = this.mMap.viewport().limitScale(d2 * d);
        if (d == 0.0) {
            return;
        }
        this.mDeltaPos.scale = d - this.mStartPos.scale;
        this.mPivot.x = f;
        this.mPivot.y = f2;
        this.animStart(l, 2, type);
    }

    public void cancel() {
        this.mState = 0;
        this.mPivot.x = 0.0;
        this.mPivot.y = 0.0;
        this.mMap.events.fire(Map.ANIM_END, this.mMap.mMapPosition);
    }

    public MapPosition getEndPosition() {
        return this.mDeltaPos;
    }

    public boolean isActive() {
        boolean bl = this.mState != 0;
        return bl;
    }

    void updateAnimation() {
        float f;
        ViewController viewController;
        long l;
        block13: {
            double d;
            double d2;
            float f2;
            block14: {
                if (this.mState == 0) {
                    return;
                }
                l = this.mAnimEnd - MapRenderer.frametime;
                viewController = this.mMap.viewport();
                if (viewController.getMapPosition(this.mCurPos)) {
                    log.debug("cancel anim - changed");
                    this.cancel();
                    return;
                }
                f2 = f = FastMath.clamp(1.0f - (float)l / this.mDuration, 1.0E-6f, 1.0f);
                if (this.mEasingType != Easing.Type.LINEAR) {
                    f2 = FastMath.clamp(Easing.ease(0L, (long)(f * 9.223372E18f), 9.223372E18f, this.mEasingType), 0.0f, 1.0f);
                }
                d2 = 1.0;
                if ((this.mState & 2) != 0) {
                    d2 = this.doScale(viewController, f2);
                }
                if ((this.mState & 1) != 0) {
                    d = this.mStartPos.x;
                    double d3 = this.mDeltaPos.x;
                    d2 = (double)f2 / d2;
                    viewController.moveTo(d + d3 * d2, this.mStartPos.y + this.mDeltaPos.y * d2);
                }
                f = f2;
                if ((this.mState & 0x10) == 0) break block13;
                f2 = (float)Math.sqrt(f2);
                d = this.mVelocity.x;
                d2 = f2;
                d *= d2;
                d2 = this.mVelocity.y * d2;
                if (d - this.mScroll.x != 0.0) break block14;
                f = f2;
                if (d2 - this.mScroll.y == 0.0) break block13;
            }
            viewController.moveMap((float)(d - this.mScroll.x), (float)(d2 - this.mScroll.y));
            this.mScroll.x = d;
            this.mScroll.y = d2;
            f = f2;
        }
        if ((this.mState & 4) != 0) {
            viewController.setRotation(this.mStartPos.bearing + this.mDeltaPos.bearing * f);
        }
        if ((this.mState & 8) != 0) {
            viewController.setTilt(this.mStartPos.tilt + this.mDeltaPos.tilt * f);
        }
        if (l <= 0L) {
            this.cancel();
        }
        if (viewController.getMapPosition(this.mCurPos)) {
            this.mMap.updateMap(true);
        } else {
            this.mMap.postDelayed(this.updateTask, 10L);
        }
    }
}

