/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.map;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.oscim.event.Gesture;
import org.oscim.event.GestureListener;
import org.oscim.event.MotionEvent;
import org.oscim.layers.GroupLayer;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.renderer.LayerRenderer;

public final class Layers
extends AbstractList<Layer> {
    private boolean mDirtyLayers;
    private final Layer.EnableHandler mEnableHandler;
    private final java.util.Map<Integer, Integer> mGroupIndex;
    private final List<Integer> mGroupList;
    private final List<Layer> mLayerList = new CopyOnWriteArrayList<Layer>();
    private LayerRenderer[] mLayerRenderer;
    private Layer[] mLayers;
    private final Map mMap;

    Layers(Map map) {
        this.mGroupList = new ArrayList<Integer>();
        this.mGroupIndex = new HashMap<Integer, Integer>();
        this.mMap = map;
        this.mEnableHandler = new Layer.EnableHandler(){

            @Override
            public void changed(boolean bl) {
                Layers.access$002(Layers.this, true);
            }
        };
    }

    static /* synthetic */ boolean access$002(Layers layers, boolean bl) {
        layers.mDirtyLayers = bl;
        return bl;
    }

    private void updateLayers() {
        synchronized (this) {
            Object object;
            Object object2;
            int n;
            Layer layer;
            int n2;
            this.mLayers = new Layer[this.mLayerList.size()];
            int n3 = this.mLayerList.size();
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                block22: {
                    block21: {
                        layer = this.mLayerList.get(n2);
                        n = n4;
                        if (!layer.isEnabled()) break block21;
                        n = n4;
                        if (layer.getRenderer() == null) break block21;
                        n = n4 + 1;
                    }
                    n4 = n;
                    if (!(layer instanceof GroupLayer)) break block22;
                    object2 = ((GroupLayer)layer).layers.iterator();
                    while (true) {
                        n4 = n++;
                        if (!object2.hasNext()) break;
                        object = object2.next();
                        if (!((Layer)object).isEnabled() || ((Layer)object).getRenderer() == null) continue;
                        continue;
                        break;
                    }
                }
                this.mLayers[n3 - n2 - 1] = layer;
                continue;
            }
            this.mLayerRenderer = new LayerRenderer[n4];
            n3 = this.mLayerList.size();
            n4 = 0;
            block19: for (n2 = 0; n2 < n3; ++n2) {
                block23: {
                    layer = this.mLayerList.get(n2);
                    object = layer.getRenderer();
                    n = n4;
                    if (!layer.isEnabled()) break block23;
                    n = n4;
                    if (object == null) break block23;
                    this.mLayerRenderer[n4] = object;
                    n = n4 + 1;
                }
                n4 = n;
                if (!(layer instanceof GroupLayer)) continue;
                object = ((GroupLayer)layer).layers.iterator();
                while (true) {
                    n4 = ++n;
                    if (!object.hasNext()) continue block19;
                    layer = object.next();
                    object2 = layer.getRenderer();
                    if (!layer.isEnabled() || object2 == null) continue;
                    this.mLayerRenderer[n] = object2;
                    continue;
                    break;
                }
            }
            this.mDirtyLayers = false;
            return;
        }
    }

    @Override
    public void add(int n, Layer object) {
        synchronized (this) {
            if (!this.mLayerList.contains(object)) {
                if (object instanceof Map.UpdateListener) {
                    this.mMap.events.bind((Map.UpdateListener)object);
                }
                if (object instanceof Map.InputListener) {
                    this.mMap.input.bind((Map.InputListener)object);
                }
                if (object instanceof GroupLayer) {
                    for (Layer layer : ((GroupLayer)object).layers) {
                        if (layer instanceof Map.UpdateListener) {
                            this.mMap.events.bind((Map.UpdateListener)((Object)layer));
                        }
                        if (!(layer instanceof Map.InputListener)) continue;
                        this.mMap.input.bind((Map.InputListener)((Object)layer));
                    }
                }
                ((Layer)object).setEnableHandler(this.mEnableHandler);
                this.mLayerList.add(n, (Layer)object);
                this.mDirtyLayers = true;
                return;
            }
            object = new IllegalArgumentException("layer added twice");
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(Layer object, int n) {
        synchronized (this) {
            int n2;
            n2 = this.mGroupList.indexOf(n2);
            if (n2 < 0) {
                object = new IllegalArgumentException("unknown layer group");
                throw object;
            }
            if (this.mLayerList.contains(object)) {
                object = new IllegalArgumentException("layer added twice");
                throw object;
            }
            if (++n2 == this.mGroupList.size()) {
                this.add(object);
            } else {
                this.add((int)this.mGroupIndex.get(this.mGroupList.get(n2)), (Layer)object);
                while (n2 < this.mGroupList.size()) {
                    int n3 = this.mGroupList.get(n2);
                    this.mGroupIndex.put(n3, this.mGroupIndex.get(n3) + 1);
                    ++n2;
                }
            }
            return;
        }
    }

    public void addGroup(int n) {
        synchronized (this) {
            if (!this.mGroupList.contains(n)) {
                this.mGroupList.add(n);
                this.mGroupIndex.put(n, this.mLayerList.size());
                return;
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("group added twice");
            throw illegalArgumentException;
        }
    }

    void destroy() {
        if (this.mDirtyLayers) {
            this.updateLayers();
        }
        Layer[] layerArray = this.mLayers;
        int n = layerArray.length;
        for (int i = 0; i < n; ++i) {
            layerArray[i].onDetach();
        }
    }

    @Override
    public Layer get(int n) {
        synchronized (this) {
            Layer layer = this.mLayerList.get(n);
            return layer;
        }
    }

    public LayerRenderer[] getLayerRenderer() {
        if (this.mDirtyLayers) {
            this.updateLayers();
        }
        return this.mLayerRenderer;
    }

    boolean handleGesture(Gesture gesture, MotionEvent motionEvent) {
        if (this.mDirtyLayers) {
            this.updateLayers();
        }
        for (Layer layer2 : this.mLayers) {
            if (layer2 instanceof GestureListener && ((GestureListener)((Object)layer2)).onGesture(gesture, motionEvent)) {
                return true;
            }
            if (!(layer2 instanceof GroupLayer)) continue;
            for (Layer layer2 : ((GroupLayer)layer2).layers) {
                if (!(layer2 instanceof GestureListener) || !((GestureListener)((Object)layer2)).onGesture(gesture, motionEvent)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Layer remove(int n) {
        synchronized (this) {
            this.mDirtyLayers = true;
            Layer layer = this.mLayerList.remove(n);
            if (layer instanceof Map.UpdateListener) {
                this.mMap.events.unbind((Map.UpdateListener)((Object)layer));
            }
            if (layer instanceof Map.InputListener) {
                this.mMap.input.unbind((Map.InputListener)((Object)layer));
            }
            if (layer instanceof GroupLayer) {
                for (Layer layer2 : ((GroupLayer)layer).layers) {
                    if (layer2 instanceof Map.UpdateListener) {
                        this.mMap.events.unbind((Map.UpdateListener)((Object)layer2));
                    }
                    if (!(layer2 instanceof Map.InputListener)) continue;
                    this.mMap.input.unbind((Map.InputListener)((Object)layer2));
                }
            }
            Iterator<Object> iterator2 = this.mGroupIndex.keySet().iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    layer.setEnableHandler(null);
                    return layer;
                }
                Integer n2 = (Integer)iterator2.next();
                int n3 = this.mGroupIndex.get(n2);
                if (n3 <= n) continue;
                this.mGroupIndex.put(n2, n3 - 1);
            }
        }
    }

    @Override
    public Layer set(int n, Layer object) {
        synchronized (this) {
            block9: {
                if (this.mLayerList.contains(object)) break block9;
                this.mDirtyLayers = true;
                if ((object = this.mLayerList.set(n, (Layer)object)) instanceof Map.UpdateListener) {
                    this.mMap.events.unbind((Map.UpdateListener)object);
                }
                if (object instanceof Map.InputListener) {
                    this.mMap.input.unbind((Map.InputListener)object);
                }
                if (object instanceof GroupLayer) {
                    for (Layer layer : ((GroupLayer)object).layers) {
                        if (layer instanceof Map.UpdateListener) {
                            this.mMap.events.unbind((Map.UpdateListener)((Object)layer));
                        }
                        if (!(layer instanceof Map.InputListener)) continue;
                        this.mMap.input.unbind((Map.InputListener)((Object)layer));
                    }
                }
                ((Layer)object).setEnableHandler(null);
                return object;
            }
            object = new IllegalArgumentException("layer added twice");
            throw object;
        }
    }

    @Override
    public int size() {
        synchronized (this) {
            int n = this.mLayerList.size();
            return n;
        }
    }
}

