/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.map;

import java.util.Iterator;
import org.oscim.core.BoundingBox;
import org.oscim.core.Box;
import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.event.EventDispatcher;
import org.oscim.event.EventListener;
import org.oscim.event.Gesture;
import org.oscim.event.MotionEvent;
import org.oscim.layers.AbstractMapEventLayer;
import org.oscim.layers.Layer;
import org.oscim.layers.MapEventLayer;
import org.oscim.layers.MapEventLayer2;
import org.oscim.layers.tile.TileLayer;
import org.oscim.layers.tile.vector.OsmTileLayer;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.map.Animator;
import org.oscim.map.Layers;
import org.oscim.map.ViewController;
import org.oscim.renderer.MapRenderer;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.ThemeLoader;
import org.oscim.tiling.TileSource;
import org.oscim.utils.Parameters;
import org.oscim.utils.ThreadUtils;
import org.oscim.utils.async.AsyncExecutor;
import org.oscim.utils.async.TaskQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Map
implements TaskQueue {
    public static final Event ANIM_END;
    public static final Event ANIM_START;
    public static final Event CLEAR_EVENT;
    public static final Event MOVE_EVENT;
    public static final Event POSITION_EVENT;
    public static final Event ROTATE_EVENT;
    public static final Event SCALE_EVENT;
    public static final Event TILT_EVENT;
    public static final Event UPDATE_EVENT;
    private static final Logger log;
    public final EventDispatcher<UpdateListener, MapPosition> events;
    public final EventDispatcher<InputListener, MotionEvent> input;
    protected final Animator mAnimator;
    private final AsyncExecutor mAsyncExecutor;
    protected boolean mClearMap = true;
    protected final AbstractMapEventLayer mEventLayer;
    private final Layers mLayers;
    protected final MapPosition mMapPosition;
    private final ViewController mViewport;

    static {
        log = LoggerFactory.getLogger(Map.class);
        POSITION_EVENT = new Event();
        MOVE_EVENT = new Event();
        SCALE_EVENT = new Event();
        ROTATE_EVENT = new Event();
        TILT_EVENT = new Event();
        UPDATE_EVENT = new Event();
        CLEAR_EVENT = new Event();
        ANIM_END = new Event();
        ANIM_START = new Event();
    }

    public Map() {
        Layers layers;
        ThreadUtils.init();
        this.mViewport = new ViewController();
        this.mAnimator = new Animator(this);
        this.mLayers = layers = new Layers(this);
        this.input = new EventDispatcher<InputListener, MotionEvent>(){

            @Override
            public void tell(InputListener inputListener, Event event, MotionEvent motionEvent) {
                inputListener.onInputEvent(event, motionEvent);
            }
        };
        this.events = new EventDispatcher<UpdateListener, MapPosition>(){

            @Override
            public void tell(UpdateListener updateListener, Event event, MapPosition mapPosition) {
                updateListener.onMapEvent(event, mapPosition);
            }
        };
        this.mAsyncExecutor = new AsyncExecutor(4, this);
        this.mMapPosition = new MapPosition();
        this.mEventLayer = Parameters.MAP_EVENT_LAYER2 ? new MapEventLayer2(this) : new MapEventLayer(this);
        layers.add(0, this.mEventLayer);
    }

    @Override
    public void addTask(Runnable runnable) {
        this.mAsyncExecutor.post(runnable);
    }

    public Animator animator() {
        return this.mAnimator;
    }

    public abstract void beginFrame();

    public void clearMap() {
        this.mClearMap = true;
        this.updateMap(true);
    }

    public void destroy() {
        this.mLayers.destroy();
        this.mAsyncExecutor.dispose();
    }

    public abstract void doneFrame(boolean var1);

    public BoundingBox getBoundingBox(int n) {
        Box box = new Box();
        this.mViewport.getBBox(box, n);
        box.map2mercator();
        return new BoundingBox(box.ymin, box.xmin, box.ymax, box.xmax);
    }

    public AbstractMapEventLayer getEventLayer() {
        return this.mEventLayer;
    }

    public abstract int getHeight();

    public MapPosition getMapPosition() {
        MapPosition mapPosition = new MapPosition();
        this.mViewport.getMapPosition(mapPosition);
        return mapPosition;
    }

    public boolean getMapPosition(MapPosition mapPosition) {
        return this.getMapPosition(false, mapPosition);
    }

    public boolean getMapPosition(boolean bl, MapPosition mapPosition) {
        if (bl && this.animator().isActive()) {
            mapPosition.copy(this.animator().getEndPosition());
            return true;
        }
        if (!ThreadUtils.isMainThread()) {
            return this.mViewport.getSyncMapPosition(mapPosition);
        }
        return this.mViewport.getMapPosition(mapPosition);
    }

    public abstract int getWidth();

    public boolean handleGesture(Gesture gesture, MotionEvent motionEvent) {
        return this.mLayers.handleGesture(gesture, motionEvent);
    }

    public Layers layers() {
        return this.mLayers;
    }

    @Override
    public abstract boolean post(Runnable var1);

    public abstract boolean postDelayed(Runnable var1, long var2);

    protected void prepareFrame() {
        ThreadUtils.assertMainThread();
        MapPosition mapPosition = this.mMapPosition;
        this.mAnimator.updateAnimation();
        boolean bl = this.mViewport.getMapPosition(mapPosition);
        boolean bl2 = this.mViewport.sizeChanged();
        if (this.mClearMap) {
            this.events.fire(CLEAR_EVENT, mapPosition);
        } else if (!bl && !bl2) {
            this.events.fire(UPDATE_EVENT, mapPosition);
        } else {
            this.events.fire(POSITION_EVENT, mapPosition);
        }
        this.mClearMap = false;
        this.mAnimator.updateAnimation();
        this.mViewport.syncViewport();
    }

    public abstract void render();

    public TileLayer setBaseMap(TileLayer tileLayer) {
        this.mLayers.add(1, tileLayer);
        return tileLayer;
    }

    public VectorTileLayer setBaseMap(TileSource tileSource) {
        OsmTileLayer osmTileLayer = new OsmTileLayer(this);
        osmTileLayer.setTileSource(tileSource);
        this.setBaseMap(osmTileLayer);
        return osmTileLayer;
    }

    public void setMapPosition(double d, double d2, double d3) {
        this.mViewport.setMapPosition(new MapPosition(d, d2, d3));
        this.updateMap(true);
    }

    public void setMapPosition(final MapPosition mapPosition) {
        if (!ThreadUtils.isMainThread()) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    Map.this.mViewport.setMapPosition(mapPosition);
                    Map.this.updateMap(true);
                }
            });
        } else {
            this.mViewport.setMapPosition(mapPosition);
            this.updateMap(true);
        }
    }

    public void setTheme(IRenderTheme iRenderTheme) {
        this.setTheme(iRenderTheme, false);
    }

    public void setTheme(IRenderTheme iRenderTheme, boolean bl) {
        if (iRenderTheme != null) {
            boolean bl2;
            boolean bl3 = false;
            Iterator iterator2 = this.mLayers.iterator();
            while (true) {
                bl2 = bl3;
                if (!iterator2.hasNext()) break;
                Layer layer = (Layer)iterator2.next();
                if (!(layer instanceof VectorTileLayer)) continue;
                ((VectorTileLayer)layer).setRenderTheme(iRenderTheme);
                bl2 = true;
                bl3 = true;
                if (!bl) break;
            }
            if (bl2) {
                MapRenderer.setBackgroundColor(iRenderTheme.getMapBackground());
                this.clearMap();
                return;
            }
            log.error("No vector layers set");
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException("Theme cannot be null.");
    }

    public void setTheme(ThemeFile themeFile) {
        this.setTheme(themeFile, false);
    }

    public void setTheme(ThemeFile themeFile, boolean bl) {
        this.setTheme(ThemeLoader.load(themeFile), bl);
    }

    public abstract void updateMap(boolean var1);

    public ViewController viewport() {
        return this.mViewport;
    }

    public static interface InputListener
    extends EventListener {
        public void onInputEvent(Event var1, MotionEvent var2);
    }

    public static interface UpdateListener
    extends EventListener {
        public void onMapEvent(Event var1, MapPosition var2);
    }
}

