/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.map;

import org.oscim.core.MapPosition;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.map.Viewport;
import org.oscim.renderer.GLMatrix;
import org.oscim.utils.FastMath;
import org.oscim.utils.ThreadUtils;

public class ViewController
extends Viewport {
    public final Viewport mNextFrame;
    protected float mPivotY = 0.0f;
    private final float[] mat = new float[16];

    public ViewController() {
        this.mNextFrame = new Viewport();
    }

    private Point applyRotation(double d, double d2) {
        synchronized (this) {
            if (this.mPos.bearing == 0.0f) {
                this.mMovePoint.x = d;
                this.mMovePoint.y = d2;
            } else {
                double d3 = Math.toRadians(this.mPos.bearing);
                double d4 = Math.cos(d3);
                d3 = Math.sin(d3);
                this.mMovePoint.x = d * d4 + d2 * d3;
                this.mMovePoint.y = d * -d3 + d2 * d4;
            }
            Point point = this.mMovePoint;
            return point;
        }
    }

    private void updateMatrices() {
        this.mRotationMatrix.setRotation(this.mPos.bearing, 0.0f, 0.0f, 1.0f);
        this.mTmpMatrix.setRotation(this.mPos.tilt, 1.0f, 0.0f, 0.0f);
        this.mRotationMatrix.multiplyLhs(this.mTmpMatrix);
        this.mViewMatrix.copy(this.mRotationMatrix);
        this.mTmpMatrix.setTranslation(0.0f, this.mPivotY * this.mHeight, 0.0f);
        this.mViewMatrix.multiplyLhs(this.mTmpMatrix);
        this.mViewProjMatrix.multiplyMM(this.mProjMatrix, this.mViewMatrix);
        this.mViewProjMatrix.get(this.mat);
        float[] fArray = this.mat;
        GLMatrix.invertM(fArray, 0, fArray, 0);
        this.mUnprojMatrix.set(this.mat);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getSyncMapPosition(MapPosition mapPosition) {
        Viewport viewport = this.mNextFrame;
        synchronized (viewport) {
            return this.mNextFrame.getMapPosition(mapPosition);
        }
    }

    public final Viewport getSyncViewport() {
        return this.mNextFrame;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getSyncViewport(Viewport viewport) {
        Viewport viewport2 = this.mNextFrame;
        synchronized (viewport2) {
            return viewport.copy(this.mNextFrame);
        }
    }

    public void moveMap(float f, float f2) {
        ThreadUtils.assertMainThread();
        Point point = this.applyRotation(f, f2);
        double d = this.mPos.scale * (double)Tile.SIZE;
        this.moveTo(this.mPos.x - point.x / d, this.mPos.y - point.y / d);
    }

    void moveTo(double d, double d2) {
        MapPosition mapPosition;
        this.mPos.x = d;
        this.mPos.y = d2;
        this.mPos.y = FastMath.clamp(this.mPos.y, 0.0, 1.0);
        while (this.mPos.x > 1.0) {
            mapPosition = this.mPos;
            mapPosition.x -= 1.0;
        }
        while (this.mPos.x < 0.0) {
            mapPosition = this.mPos;
            mapPosition.x += 1.0;
        }
        if (this.mPos.x > this.mMaxX) {
            this.mPos.x = this.mMaxX;
        } else if (this.mPos.x < this.mMinX) {
            this.mPos.x = this.mMinX;
        }
        if (this.mPos.y > this.mMaxY) {
            this.mPos.y = this.mMaxY;
        } else if (this.mPos.y < this.mMinY) {
            this.mPos.y = this.mMinY;
        }
    }

    public void rotateMap(double d, float f, float f2) {
        ThreadUtils.assertMainThread();
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        float f3 = this.mHeight;
        float f4 = this.mPivotY;
        double d4 = f;
        double d5 = f2 - f3 * f4;
        this.moveMap((float)(d4 - d4 * d3 + d5 * d2), (float)(d5 - d4 * d2 - d5 * d3));
        this.setRotation((double)this.mPos.bearing + Math.toDegrees(d));
    }

    public boolean scaleMap(float f, float f2, float f3) {
        ThreadUtils.assertMainThread();
        double d = f;
        if (d < 1.0E-6) {
            return false;
        }
        if ((d = FastMath.clamp(this.mPos.scale * d, this.mMinScale, this.mMaxScale)) == this.mPos.scale) {
            return false;
        }
        float f4 = (float)(d / this.mPos.scale);
        this.mPos.scale = d;
        if (f2 != 0.0f || f3 != 0.0f) {
            f = this.mHeight;
            float f5 = this.mPivotY;
            f4 = 1.0f - f4;
            this.moveMap(f2 * f4, (f3 - f * f5) * f4);
        }
        return true;
    }

    public void setMapPosition(MapPosition mapPosition) {
        ThreadUtils.assertMainThread();
        this.mPos.copy(mapPosition);
        this.limitPosition(this.mPos);
        this.updateMatrices();
    }

    public void setMapScreenCenter(float f) {
        this.mPivotY = FastMath.clamp(f, -1.0f, 1.0f) * 0.5f;
    }

    public void setRotation(double d) {
        double d2;
        ThreadUtils.assertMainThread();
        while (true) {
            if (!(d > 180.0)) break;
            d -= 360.0;
        }
        for (d2 = d; d2 < -180.0; d2 += 360.0) {
        }
        this.mPos.bearing = (float)d2;
        this.updateMatrices();
    }

    public void setScreenSize(int n, int n2) {
        ThreadUtils.assertMainThread();
        this.mHeight = n2;
        this.mWidth = n;
        float f = this.mHeight / this.mWidth * 0.16666667f;
        GLMatrix.frustumM(this.mat, 0, -0.16666667f, 0.16666667f, f, -f, 1.0f, 8.0f);
        this.mProjMatrix.set(this.mat);
        this.mTmpMatrix.setTranslation(0.0f, 0.0f, -3.0f);
        this.mProjMatrix.multiplyRhs(this.mTmpMatrix);
        this.mProjMatrix.get(this.mat);
        float[] fArray = this.mat;
        GLMatrix.invertM(fArray, 0, fArray, 0);
        this.mProjMatrixInverse.set(this.mat);
        this.mProjMatrixUnscaled.copy(this.mProjMatrix);
        this.mTmpMatrix.setScale(1.0f / this.mWidth, 1.0f / this.mWidth, 1.0f / this.mWidth);
        this.mProjMatrix.multiplyRhs(this.mTmpMatrix);
        this.updateMatrices();
    }

    public boolean setTilt(float f) {
        ThreadUtils.assertMainThread();
        f = this.limitTilt(f);
        if (f == this.mPos.tilt) {
            return false;
        }
        this.mPos.tilt = f;
        this.updateMatrices();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean sizeChanged() {
        Viewport viewport = this.mNextFrame;
        synchronized (viewport) {
            return this.mNextFrame.sizeChanged(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void syncViewport() {
        Viewport viewport = this.mNextFrame;
        synchronized (viewport) {
            this.mNextFrame.copy(this);
            return;
        }
    }

    public boolean tiltMap(float f) {
        return this.setTilt(this.mPos.tilt + f);
    }
}

