/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.map;

import org.oscim.core.BoundingBox;
import org.oscim.core.Box;
import org.oscim.core.GeoPoint;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.renderer.GLMatrix;
import org.oscim.utils.FastMath;

public class Viewport {
    public static final float MAX_TILT = 65.0f;
    public static final int MAX_ZOOMLEVEL = 20;
    public static final float MIN_TILT = 0.0f;
    public static final int MIN_ZOOMLEVEL = 2;
    public static final float VIEW_DISTANCE = 3.0f;
    public static final float VIEW_FAR = 8.0f;
    public static final float VIEW_NEAR = 1.0f;
    public static final float VIEW_SCALE = 0.16666667f;
    protected float mHeight;
    protected float mMaxBearing = 180.0f;
    protected double mMaxScale = 1048576.0;
    protected float mMaxTilt = 65.0f;
    protected double mMaxX = 1.0;
    protected double mMaxY = 1.0;
    protected float mMinBearing = -180.0f;
    protected double mMinScale = 4.0;
    protected float mMinTilt = 0.0f;
    protected double mMinX = 0.0;
    protected double mMinY = 0.0;
    protected final Point mMovePoint;
    protected final MapPosition mPos;
    protected final GLMatrix mProjMatrix;
    protected final GLMatrix mProjMatrixInverse;
    protected final GLMatrix mProjMatrixUnscaled;
    protected final GLMatrix mRotationMatrix;
    protected final GLMatrix mTmpMatrix;
    protected final GLMatrix mUnprojMatrix;
    protected final float[] mViewCoords;
    protected final GLMatrix mViewMatrix;
    protected final GLMatrix mViewProjMatrix;
    protected float mWidth;
    protected final float[] mu;
    protected final float[] mv;

    public Viewport() {
        MapPosition mapPosition;
        this.mPos = mapPosition = new MapPosition();
        this.mProjMatrix = new GLMatrix();
        this.mProjMatrixUnscaled = new GLMatrix();
        this.mProjMatrixInverse = new GLMatrix();
        this.mRotationMatrix = new GLMatrix();
        this.mViewMatrix = new GLMatrix();
        this.mViewProjMatrix = new GLMatrix();
        this.mUnprojMatrix = new GLMatrix();
        this.mTmpMatrix = new GLMatrix();
        this.mMovePoint = new Point();
        this.mv = new float[4];
        this.mu = new float[4];
        this.mViewCoords = new float[8];
        mapPosition.scale = this.mMinScale;
        mapPosition.x = 0.5;
        mapPosition.y = 0.5;
        mapPosition.bearing = 0.0f;
        mapPosition.tilt = 0.0f;
    }

    protected boolean copy(Viewport viewport) {
        boolean bl = this.sizeChanged(viewport);
        this.mHeight = viewport.mHeight;
        this.mWidth = viewport.mWidth;
        this.mProjMatrix.copy(viewport.mProjMatrix);
        this.mProjMatrixUnscaled.copy(viewport.mProjMatrixUnscaled);
        this.mProjMatrixInverse.copy(viewport.mProjMatrixInverse);
        this.mUnprojMatrix.copy(viewport.mUnprojMatrix);
        this.mRotationMatrix.copy(viewport.mRotationMatrix);
        this.mViewMatrix.copy(viewport.mViewMatrix);
        this.mViewProjMatrix.copy(viewport.mViewProjMatrix);
        bl = viewport.getMapPosition(this.mPos) || bl;
        return bl;
    }

    public GeoPoint fromScreenPoint(float f, float f2) {
        synchronized (this) {
            double d = f;
            double d2 = f2;
            this.fromScreenPoint(d, d2, this.mMovePoint);
            GeoPoint geoPoint = new GeoPoint(MercatorProjection.toLatitude(this.mMovePoint.y), MercatorProjection.toLongitude(this.mMovePoint.x));
            return geoPoint;
        }
    }

    public void fromScreenPoint(double d, double d2, Point point) {
        synchronized (this) {
            this.unprojectScreen(d, d2, this.mu);
            d2 = this.mPos.scale * (double)Tile.SIZE;
            d = this.mPos.x;
            double d3 = this.mPos.y;
            float[] fArray = this.mu;
            double d4 = fArray[0];
            double d5 = fArray[1];
            d = (d * d2 + d4) / d2;
            d5 = (d3 * d2 + d5) / d2;
            while (true) {
                if (!(d > 1.0)) break;
                d -= 1.0;
            }
            for (d2 = d; d2 < 0.0; d2 += 1.0) {
            }
            if (d5 > 1.0) {
                d = 1.0;
            } else {
                d = d5;
                if (d5 < 0.0) {
                    d = 0.0;
                }
            }
            point.x = d2;
            point.y = d;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Box getBBox(Box object, int n) {
        synchronized (this) {
            int n2;
            Object object2 = object;
            if (object == null) {
                object2 = new Box();
            }
            object = this.mViewCoords;
            this.getMapExtents((float[])object, n2);
            ((Box)object2).xmin = (double)object[0];
            ((Box)object2).xmax = (double)object[0];
            ((Box)object2).ymin = (double)object[1];
            ((Box)object2).ymax = (double)object[1];
            n2 = 2;
            while (true) {
                double d;
                if (n2 >= 8) {
                    double d2 = this.mPos.scale * (double)Tile.SIZE;
                    double d3 = this.mPos.x * d2;
                    d = this.mPos.y * d2;
                    ((Box)object2).xmin = (((Box)object2).xmin + d3) / d2;
                    ((Box)object2).xmax = (d3 + ((Box)object2).xmax) / d2;
                    ((Box)object2).ymin = (((Box)object2).ymin + d) / d2;
                    ((Box)object2).ymax = (d + ((Box)object2).ymax) / d2;
                    return object2;
                }
                ((Box)object2).xmin = Math.min(((Box)object2).xmin, (double)object[n2]);
                ((Box)object2).xmax = Math.max(((Box)object2).xmax, (double)object[n2]);
                d = ((Box)object2).ymin;
                int n3 = n2 + 1;
                ((Box)object2).ymin = Math.min(d, (double)object[n3]);
                ((Box)object2).ymax = Math.max(((Box)object2).ymax, (double)object[n3]);
                n2 += 2;
            }
        }
    }

    public void getMapExtents(float[] fArray, float f) {
        this.unproject(1.0f, -1.0f, fArray, 0);
        this.unproject(-1.0f, -1.0f, fArray, 2);
        this.unproject(-1.0f, 1.0f, fArray, 4);
        this.unproject(1.0f, 1.0f, fArray, 6);
        if (f == 0.0f) {
            return;
        }
        for (int i = 0; i < 8; i += 2) {
            float f2 = fArray[i];
            int n = i + 1;
            float f3 = fArray[n];
            float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
            int n2 = i + 0;
            fArray[n2] = fArray[n2] + f2 / f4 * f;
            fArray[n] = fArray[n] + f3 / f4 * f;
        }
    }

    public BoundingBox getMapLimit() {
        return new BoundingBox(MercatorProjection.toLatitude(this.mMaxY), MercatorProjection.toLongitude(this.mMinX), MercatorProjection.toLatitude(this.mMinY), MercatorProjection.toLongitude(this.mMaxX));
    }

    public boolean getMapPosition(MapPosition mapPosition) {
        boolean bl = mapPosition.scale != this.mPos.scale || mapPosition.x != this.mPos.x || mapPosition.y != this.mPos.y || mapPosition.bearing != this.mPos.bearing || mapPosition.tilt != this.mPos.tilt;
        mapPosition.bearing = this.mPos.bearing;
        mapPosition.tilt = this.mPos.tilt;
        mapPosition.x = this.mPos.x;
        mapPosition.y = this.mPos.y;
        mapPosition.scale = this.mPos.scale;
        mapPosition.zoomLevel = FastMath.log2((int)this.mPos.scale);
        return bl;
    }

    public float getMaxBearing() {
        return this.mMaxBearing;
    }

    public double getMaxScale() {
        return this.mMaxScale;
    }

    public float getMaxTilt() {
        return this.mMaxTilt;
    }

    public double getMaxX() {
        return this.mMaxX;
    }

    public double getMaxY() {
        return this.mMaxY;
    }

    public int getMaxZoomLevel() {
        return FastMath.log2((int)this.mMaxScale);
    }

    public float getMinBearing() {
        return this.mMinBearing;
    }

    public double getMinScale() {
        return this.mMinScale;
    }

    public float getMinTilt() {
        return this.mMinTilt;
    }

    public double getMinX() {
        return this.mMinX;
    }

    public double getMinY() {
        return this.mMinY;
    }

    public int getMinZoomLevel() {
        return FastMath.log2((int)this.mMinScale);
    }

    /*
     * Unable to fully structure code
     */
    public boolean limitPosition(MapPosition var1_1) {
        block17: {
            block16: {
                var2_2 = var1_1.scale;
                var4_3 = this.mMaxScale;
                var6_4 = true;
                if (var2_2 > var4_3) {
                    var1_1.scale = var4_3;
lbl6:
                    // 2 sources

                    while (true) {
                        var7_5 = true;
                        break;
                    }
                } else {
                    var2_2 = var1_1.scale;
                    var4_3 = this.mMinScale;
                    if (var2_2 < var4_3) {
                        var1_1.scale = var4_3;
                        ** continue;
                    }
                    var7_5 = false;
                }
                var8_6 = var1_1.tilt;
                var9_7 = this.mMaxTilt;
                if (var8_6 > var9_7) {
                    var1_1.tilt = var9_7;
lbl19:
                    // 2 sources

                    while (true) {
                        var7_5 = true;
                        break;
                    }
                } else {
                    var8_6 = var1_1.tilt;
                    var9_7 = this.mMinTilt;
                    if (var8_6 < var9_7) {
                        var1_1.tilt = var9_7;
                        ** continue;
                    }
                }
                var8_6 = var1_1.bearing;
                var9_7 = this.mMaxBearing;
                if (var8_6 > var9_7) {
                    var1_1.bearing = var9_7;
lbl31:
                    // 2 sources

                    while (true) {
                        var7_5 = true;
                        break;
                    }
                } else {
                    var9_7 = var1_1.bearing;
                    var8_6 = this.mMinBearing;
                    if (var9_7 < var8_6) {
                        var1_1.bearing = var8_6;
                        ** continue;
                    }
                }
                var2_2 = var1_1.x;
                var4_3 = this.mMaxX;
                if (var2_2 > var4_3) {
                    var1_1.x = var4_3;
lbl43:
                    // 2 sources

                    while (true) {
                        var7_5 = true;
                        break;
                    }
                } else {
                    var2_2 = var1_1.x;
                    var4_3 = this.mMinX;
                    if (var2_2 < var4_3) {
                        var1_1.x = var4_3;
                        ** continue;
                    }
                }
                var4_3 = var1_1.y;
                var2_2 = this.mMaxY;
                if (!(var4_3 > var2_2)) break block16;
                var1_1.y = var2_2;
                var7_5 = var6_4;
                break block17;
            }
            var4_3 = var1_1.y;
            var2_2 = this.mMinY;
            if (!(var4_3 < var2_2)) break block17;
            var1_1.y = var2_2;
            var7_5 = var6_4;
        }
        return var7_5;
    }

    public double limitScale(double d) {
        double d2 = this.mMaxScale;
        if (d > d2) {
            return d2;
        }
        d2 = this.mMinScale;
        if (d < d2) {
            return d2;
        }
        return d;
    }

    public float limitTilt(float f) {
        float f2 = this.mMaxTilt;
        if (f > f2) {
            return f2;
        }
        f2 = this.mMinTilt;
        if (f < f2) {
            return f2;
        }
        return f;
    }

    public void setMapLimit(double d, double d2, double d3, double d4) {
        this.mMinX = d;
        this.mMinY = d2;
        this.mMaxX = d3;
        this.mMaxY = d4;
    }

    public void setMapLimit(BoundingBox boundingBox) {
        this.mMinX = MercatorProjection.longitudeToX(boundingBox.getMinLongitude());
        this.mMinY = MercatorProjection.latitudeToY(boundingBox.getMaxLatitude());
        this.mMaxX = MercatorProjection.longitudeToX(boundingBox.getMaxLongitude());
        this.mMaxY = MercatorProjection.latitudeToY(boundingBox.getMinLatitude());
    }

    public void setMaxBearing(float f) {
        this.mMaxBearing = f;
    }

    public void setMaxScale(double d) {
        this.mMaxScale = d;
    }

    public void setMaxTilt(float f) {
        this.mMaxTilt = f;
    }

    public void setMaxX(double d) {
        this.mMaxX = d;
    }

    public void setMaxY(double d) {
        this.mMaxY = d;
    }

    public void setMaxZoomLevel(int n) {
        this.mMaxScale = 1 << n;
    }

    public void setMinBearing(float f) {
        this.mMinBearing = f;
    }

    public void setMinScale(double d) {
        this.mMinScale = d;
    }

    public void setMinTilt(float f) {
        this.mMinTilt = f;
    }

    public void setMinX(double d) {
        this.mMinX = d;
    }

    public void setMinY(double d) {
        this.mMinY = d;
    }

    public void setMinZoomLevel(int n) {
        this.mMinScale = 1 << n;
    }

    boolean sizeChanged(Viewport viewport) {
        boolean bl = this.mHeight != viewport.mHeight || this.mWidth != viewport.mWidth;
        return bl;
    }

    public void toScreenPoint(double d, double d2, Point point) {
        this.toScreenPoint(d, d2, true, point);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toScreenPoint(double d, double d2, boolean bl, Point point) {
        synchronized (this) {
            double d3 = this.mPos.scale * (double)Tile.SIZE;
            double d4 = this.mPos.x;
            double d5 = this.mPos.y;
            float[] fArray = this.mv;
            fArray[0] = (float)(d * d3 - d4 * d3);
            fArray[1] = (float)(d2 * d3 - d5 * d3);
            fArray[2] = 0.0f;
            fArray[3] = 1.0f;
            this.mViewProjMatrix.prj(fArray);
            point.x = this.mv[0] * (this.mWidth / 2.0f);
            point.y = -(this.mv[1] * (this.mHeight / 2.0f));
            if (!bl) {
                point.x += (double)(this.mWidth / 2.0f);
                point.y += (double)(this.mHeight / 2.0f);
            }
            return;
        }
    }

    public void toScreenPoint(GeoPoint geoPoint, Point point) {
        this.toScreenPoint(geoPoint, true, point);
    }

    public void toScreenPoint(GeoPoint geoPoint, boolean bl, Point point) {
        MercatorProjection.project(geoPoint, point);
        this.toScreenPoint(point.x, point.y, bl, point);
    }

    protected void unproject(float f, float f2, float[] fArray, int n) {
        synchronized (this) {
            float[] fArray2 = this.mv;
            fArray2[0] = f;
            fArray2[1] = f2;
            fArray2[2] = -1.0f;
            this.mUnprojMatrix.prj(fArray2);
            fArray2 = this.mv;
            double d = fArray2[0];
            double d2 = fArray2[1];
            double d3 = fArray2[2];
            fArray2[0] = f;
            fArray2[1] = f2;
            fArray2[2] = 1.0f;
            this.mUnprojMatrix.prj(fArray2);
            fArray2 = this.mv;
            double d4 = fArray2[0];
            double d5 = fArray2[1];
            double d6 = fArray2[2];
            d6 = -d3 / (d6 - d3);
            fArray[n + 0] = (float)(d + (d4 - d) * d6);
            fArray[n + 1] = (float)(d2 + d6 * (d5 - d2));
            return;
        }
    }

    protected void unprojectScreen(double d, double d2, float[] fArray) {
        float f = (float)(1.0 - d / (double)this.mWidth * 2.0);
        float f2 = (float)(1.0 - d2 / (double)this.mHeight * 2.0);
        this.unproject(-f, f2, fArray, 0);
    }
}

