/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.BitmapBucket;
import org.oscim.renderer.bucket.RenderBucket;

public class BitmapRenderer
extends BucketRenderer {
    private boolean initialized;
    private Bitmap mBitmap;
    private int mHeight;
    private boolean mUpdateBitmap;
    private int mWidth;
    private GLViewport.Position position = GLViewport.Position.TOP_LEFT;
    private float xOffset;
    private float yOffset;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void compile() {
        synchronized (this) {
            Bitmap bitmap = this.mBitmap;
            if (bitmap == null) {
                return;
            }
            synchronized (bitmap) {
                super.compile();
                return;
            }
        }
    }

    @Override
    public void render(GLViewport gLViewport) {
        synchronized (this) {
            gLViewport.useScreenCoordinates(this.mWidth, this.mHeight, this.position, this.xOffset, this.yOffset, MapRenderer.COORD_SCALE);
            BitmapBucket.Renderer.draw(this.buckets.get(), gLViewport, 1.0f, 1.0f);
            return;
        }
    }

    public void setBitmap(Bitmap bitmap, int n, int n2) {
        synchronized (this) {
            this.mBitmap = bitmap;
            this.mWidth = n;
            this.mHeight = n2;
            this.initialized = false;
            return;
        }
    }

    public void setOffset(float f, float f2) {
        synchronized (this) {
            this.xOffset = f;
            this.yOffset = f2;
            return;
        }
    }

    public void setPosition(GLViewport.Position position) {
        synchronized (this) {
            this.position = position;
            return;
        }
    }

    @Override
    public void update(GLViewport object) {
        synchronized (this) {
            if (!this.initialized) {
                this.buckets.clear();
                object = new BitmapBucket(true);
                ((BitmapBucket)object).setBitmap(this.mBitmap, this.mWidth, this.mHeight);
                this.buckets.set((RenderBucket)object);
                this.mUpdateBitmap = true;
            }
            if (this.mUpdateBitmap) {
                this.mUpdateBitmap = false;
                this.compile();
            }
            return;
        }
    }

    public void updateBitmap() {
        synchronized (this) {
            this.mUpdateBitmap = true;
            return;
        }
    }
}

