/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.core.MapPosition;
import org.oscim.core.Tile;
import org.oscim.renderer.GLMatrix;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.BitmapBucket;
import org.oscim.renderer.bucket.CircleBucket;
import org.oscim.renderer.bucket.HairLineBucket;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.LineTexBucket;
import org.oscim.renderer.bucket.MeshBucket;
import org.oscim.renderer.bucket.PolygonBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.TextureBucket;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketRenderer
extends LayerRenderer {
    public static final Logger log = LoggerFactory.getLogger(BucketRenderer.class);
    public final RenderBuckets buckets = new RenderBuckets();
    protected boolean mFlipOnDateLine = true;
    protected boolean mInititialzed;
    protected MapPosition mMapPosition = new MapPosition();

    protected void compile() {
        synchronized (this) {
            this.setReady(this.buckets.compile(true));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void render(GLViewport gLViewport) {
        synchronized (this) {
            MapPosition mapPosition = this.mMapPosition;
            GLState.test(false, false);
            GLState.blend(true);
            float f = (float)(gLViewport.pos.scale / mapPosition.scale);
            this.setMatrix(gLViewport, true);
            RenderBucket renderBucket = this.buckets.get();
            boolean bl = true;
            block12: while (renderBucket != null) {
                Logger logger;
                this.buckets.bind();
                boolean bl2 = bl;
                if (!bl) {
                    bl2 = bl;
                    if (renderBucket.type != 6) {
                        this.setMatrix(gLViewport, true);
                        bl2 = true;
                    }
                }
                switch (renderBucket.type) {
                    default: {
                        logger = log;
                        break;
                    }
                    case 8: {
                        renderBucket = CircleBucket.Renderer.draw(renderBucket, gLViewport);
                        bl = bl2;
                        continue block12;
                    }
                    case 7: {
                        renderBucket = BitmapBucket.Renderer.draw(renderBucket, gLViewport, 1.0f, 1.0f);
                        bl = bl2;
                        continue block12;
                    }
                    case 6: {
                        bl = bl2;
                        if (bl2) {
                            this.setMatrix(gLViewport, false);
                            bl = false;
                        }
                        renderBucket = TextureBucket.Renderer.draw(renderBucket, gLViewport, f);
                        continue block12;
                    }
                    case 5: {
                        renderBucket = HairLineBucket.Renderer.draw(renderBucket, gLViewport);
                        bl = bl2;
                        continue block12;
                    }
                    case 3: {
                        renderBucket = MeshBucket.Renderer.draw(renderBucket, gLViewport);
                        bl = bl2;
                        continue block12;
                    }
                    case 2: {
                        renderBucket = PolygonBucket.Renderer.draw(renderBucket, gLViewport, 1.0f, true);
                        bl = bl2;
                        continue block12;
                    }
                    case 1: {
                        renderBucket = LineTexBucket.Renderer.draw(renderBucket, gLViewport, FastMath.pow(mapPosition.zoomLevel - gLViewport.pos.zoomLevel) * (float)mapPosition.getZoomScale(), this.buckets);
                        bl = bl2;
                        continue block12;
                    }
                    case 0: {
                        renderBucket = LineBucket.Renderer.draw(renderBucket, gLViewport, f, this.buckets);
                        bl = bl2;
                        continue block12;
                    }
                }
                logger.error("invalid bucket {}", (Object)renderBucket.type);
                renderBucket = (RenderBucket)renderBucket.next;
                bl = bl2;
            }
            return;
        }
    }

    protected void setMatrix(GLMatrix gLMatrix, GLViewport object, boolean bl, float f) {
        MapPosition mapPosition = this.mMapPosition;
        double d = (double)Tile.SIZE * ((GLViewport)object).pos.scale;
        double d2 = mapPosition.x - ((GLViewport)object).pos.x;
        double d3 = mapPosition.y;
        double d4 = ((GLViewport)object).pos.y;
        double d5 = d2;
        if (this.mFlipOnDateLine) {
            d5 = d2;
            while (true) {
                d2 = d5;
                if (!(d5 < 0.5)) break;
                d5 += 1.0;
            }
            while (true) {
                d5 = d2;
                if (!(d2 > 0.5)) break;
                d2 -= 1.0;
            }
        }
        gLMatrix.setTransScale((float)(d5 * d), (float)((d3 - d4) * d), (float)(((GLViewport)object).pos.scale / mapPosition.scale) / f);
        object = bl ? ((GLViewport)object).viewproj : ((GLViewport)object).view;
        gLMatrix.multiplyLhs((GLMatrix)object);
    }

    protected void setMatrix(GLViewport gLViewport) {
        this.setMatrix(gLViewport, true);
    }

    protected void setMatrix(GLViewport gLViewport, boolean bl) {
        this.setMatrix(gLViewport, bl, MapRenderer.COORD_SCALE);
    }

    protected void setMatrix(GLViewport gLViewport, boolean bl, float f) {
        this.setMatrix(gLViewport.mvp, gLViewport, bl, f);
    }

    @Override
    public void update(GLViewport gLViewport) {
        if (!this.mInititialzed) {
            this.mMapPosition.copy(gLViewport.pos);
            this.mInititialzed = true;
            this.compile();
        }
    }
}

