/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.Buffer;
import javax.annotation.CheckReturnValue;
import org.oscim.backend.GLAdapter;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.utils.pool.Inlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferObject
extends Inlist<BufferObject> {
    private static final int LIMIT_BUFFERS = 0x1000000;
    private static final int MB = 0x100000;
    private static final int[] counter;
    static final Logger log;
    private static int mBufferMemoryUsage;
    private static final BufferObject[] pool;
    private int id;
    private int size;
    private int target;

    static {
        log = LoggerFactory.getLogger(BufferObject.class);
        pool = new BufferObject[2];
        counter = new int[2];
    }

    private BufferObject(int n, int n2) {
        this.id = n2;
        this.target = n;
    }

    public static void checkBufferUsage(boolean bl) {
        if (mBufferMemoryUsage < 0x1000000) {
            return;
        }
        Logger logger = log;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("use: ");
        stringBuilder.append(mBufferMemoryUsage / 0x100000);
        stringBuilder.append("MB");
        logger.debug(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("now: ");
        stringBuilder.append((mBufferMemoryUsage -= BufferObject.limitUsage(0x100000)) / 0x100000);
        stringBuilder.append("MB");
        logger.debug(stringBuilder.toString());
    }

    static void clear() {
        synchronized (BufferObject.class) {
            mBufferMemoryUsage = 0;
            Object[] objectArray = pool;
            objectArray[0] = null;
            objectArray[1] = null;
            objectArray = counter;
            objectArray[0] = (BufferObject)false;
            objectArray[1] = (BufferObject)false;
            return;
        }
    }

    static void createBuffers(int n, int n2) {
        int[] nArray = GLUtils.glGenBuffers(n2);
        int n3 = n == 34962 ? 0 : 1;
        for (int i = 0; i < n2; ++i) {
            BufferObject bufferObject = new BufferObject(n, nArray[i]);
            BufferObject[] bufferObjectArray = pool;
            bufferObject.next = bufferObjectArray[n3];
            bufferObjectArray[n3] = bufferObject;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferObject get(int n, int n2) {
        synchronized (BufferObject.class) {
            int n3;
            block15: {
                void var5_20;
                void var4_13;
                Object var5_19;
                n3 = n == 34962 ? 0 : 1;
                BufferObject[] bufferObjectArray = pool;
                if (bufferObjectArray[n3] == null) {
                    int[] nArray = counter;
                    if (nArray[n3] != 0) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("lost objects: ");
                        stringBuilder.append(nArray[n3]);
                        IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
                        throw illegalStateException;
                    }
                    BufferObject.createBuffers(n, 10);
                    nArray[n3] = nArray[n3] + 10;
                }
                int[] nArray = counter;
                nArray[n3] = nArray[n3] - 1;
                if (n2 == 0) break block15;
                BufferObject bufferObject = bufferObjectArray[n3];
                Object var3_5 = var5_19 = null;
                while (var4_13 != null) {
                    void var6_23;
                    block16: {
                        void var3_6;
                        block17: {
                            void var6_24 = var5_20;
                            if (var4_13.size <= n2) break block16;
                            if (var5_20 == null) break block17;
                            void var6_25 = var5_20;
                            if (((BufferObject)var5_20.next).size <= var4_13.size) break block16;
                        }
                        void var6_27 = var3_6;
                    }
                    BufferObject bufferObject2 = (BufferObject)var4_13.next;
                    void var3_7 = var4_13;
                    BufferObject bufferObject3 = bufferObject2;
                    void var5_22 = var6_23;
                }
                if (var5_20 != null && var5_20 != pool[n3]) {
                    BufferObject bufferObject4 = (BufferObject)var5_20.next;
                    var5_20.next = bufferObject4.next;
                    bufferObject4.next = null;
                    return bufferObject4;
                }
            }
            BufferObject[] bufferObjectArray = pool;
            BufferObject bufferObject = bufferObjectArray[n3];
            bufferObjectArray[n3] = (BufferObject)bufferObjectArray[n3].next;
            bufferObject.next = null;
            return bufferObject;
        }
    }

    static void init(int n) {
        synchronized (BufferObject.class) {
            BufferObject.createBuffers(34962, n);
            int[] nArray = counter;
            nArray[0] = nArray[0] + n;
            return;
        }
    }

    public static boolean isMaxFill() {
        boolean bl = mBufferMemoryUsage > 0x1000000;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int limitUsage(int n) {
        synchronized (BufferObject.class) {
            int[] nArray = new int[10];
            int n2 = 0;
            int n3 = 0;
            while (n2 < 2) {
                Object object = pool;
                Object object2 = object[n2];
                if (object2 == null) {
                    log.debug("nothing to free");
                } else {
                    int n4;
                    object = (BufferObject)object[n2].next;
                    int n5 = 0;
                    int n6 = n3;
                    block4: while (true) {
                        block10: {
                            Object object3 = object2;
                            n3 = n5;
                            object2 = object;
                            while (true) {
                                n5 = n6;
                                n4 = n3;
                                if (object2 == null) break block4;
                                n5 = object2.size;
                                if (n5 <= 0) break block10;
                                n6 += n5;
                                object2.size = 0;
                                n4 = n3 + 1;
                                nArray[n3] = object2.id;
                                object3.next = object2.next;
                                object2 = (BufferObject)object2.next;
                                if (n4 == 10 || n < n6) break;
                                n3 = n4;
                            }
                            n5 = n6;
                            break;
                        }
                        object = (BufferObject)object2.next;
                        n5 = n3;
                    }
                    n3 = n5;
                    if (n4 > 0) {
                        GLUtils.glDeleteBuffers(n4, nArray);
                        object = counter;
                        object[n2] = object[n2] - n4;
                        n3 = n5;
                    }
                }
                ++n2;
            }
            return n3;
        }
    }

    @CheckReturnValue
    public static BufferObject release(BufferObject object) {
        synchronized (BufferObject.class) {
            if (object == null) {
                return null;
            }
            int n = ((BufferObject)object).target == 34962 ? 0 : 1;
            BufferObject[] bufferObjectArray = pool;
            ((BufferObject)object).next = bufferObjectArray[n];
            bufferObjectArray[n] = object;
            object = counter;
            object[n] = object[n] + true;
            return null;
        }
    }

    public void bind() {
        GLState.bindBuffer(this.target, this.id);
    }

    public void loadBufferData(Buffer buffer, int n) {
        int n2;
        if (buffer.position() != 0) {
            log.debug("flip your buffer!");
            buffer.flip();
        }
        GLState.bindBuffer(this.target, this.id);
        if (!GLAdapter.NO_BUFFER_SUB_DATA && (n2 = this.size) > n && n2 < n * 4) {
            GLAdapter.gl.bufferSubData(this.target, 0, n, buffer);
        } else {
            mBufferMemoryUsage += n - this.size;
            this.size = n;
            GLAdapter.gl.bufferData(this.target, this.size, buffer, 35044);
        }
    }

    public void unbind() {
        GLState.bindBuffer(this.target, 0);
    }
}

