/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.backend.GLAdapter;
import org.oscim.core.Tile;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.ExtrusionBucket;
import org.oscim.renderer.bucket.ExtrusionBuckets;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtrusionRenderer
extends LayerRenderer {
    static final Logger log = LoggerFactory.getLogger(ExtrusionRenderer.class);
    protected float mAlpha = 1.0f;
    protected int mBucketsCnt;
    protected ExtrusionBuckets[] mExtrusionBucketSet = new ExtrusionBuckets[0];
    private final int mMode;
    private Shader mShader;
    private final boolean mTranslucent;
    private float mZLimit = Float.MAX_VALUE;

    public ExtrusionRenderer(boolean bl, boolean bl2) {
        this.mMode = bl ? 1 : 0;
        this.mTranslucent = bl2;
    }

    private float getFade(ExtrusionBuckets extrusionBuckets) {
        if (extrusionBuckets.animTime == 0L) {
            extrusionBuckets.animTime = MapRenderer.frametime - 50L;
        }
        return FastMath.clamp((float)(MapRenderer.frametime - extrusionBuckets.animTime) / 300.0f, 0.0f, 1.0f);
    }

    private void renderCombined(int n, ExtrusionBuckets inlist) {
        for (inlist = ((ExtrusionBuckets)inlist).buckets(); inlist != null; inlist = ((ExtrusionBucket)inlist).next()) {
            GLAdapter.gl.vertexAttribPointer(n, 3, 5122, false, 8, ((RenderBucket)inlist).getVertexOffset());
            int n2 = ((ExtrusionBucket)inlist).idx[0] + ((ExtrusionBucket)inlist).idx[1] + ((ExtrusionBucket)inlist).idx[2];
            if (n2 > 0) {
                GLAdapter.gl.drawElements(4, n2, 5123, ((ExtrusionBucket)inlist).off[0]);
            }
            if (((ExtrusionBucket)inlist).idx[4] <= 0) continue;
            GLAdapter.gl.drawElements(4, ((ExtrusionBucket)inlist).idx[4], 5123, ((ExtrusionBucket)inlist).off[4]);
        }
    }

    private void setMatrix(Shader shader, GLViewport gLViewport, ExtrusionBuckets extrusionBuckets) {
        int n = extrusionBuckets.zoomLevel;
        double d = (double)Tile.SIZE * gLViewport.pos.scale;
        double d2 = gLViewport.pos.scale;
        double d3 = 1 << n;
        float f = (float)(d2 / d3);
        float f2 = (float)((extrusionBuckets.x - gLViewport.pos.x) * d);
        float f3 = (float)((extrusionBuckets.y - gLViewport.pos.y) * d);
        gLViewport.mvp.setTransScale(f2, f3, f / MapRenderer.COORD_SCALE);
        gLViewport.mvp.setValue(10, f / 10.0f);
        gLViewport.mvp.multiplyLhs(gLViewport.viewproj);
        if (this.mTranslucent) {
            n = (int)(extrusionBuckets.x * d3);
            int n2 = (int)(extrusionBuckets.y * d3);
            gLViewport.mvp.addDepthOffset(n % 4 + n2 % 4 * 4);
        }
        gLViewport.mvp.setAsUniform(shader.uMVP);
    }

    @Override
    public void render(GLViewport gLViewport) {
        float f;
        int n;
        GLAdapter.gl.depthMask(true);
        GLAdapter.gl.clear(256);
        GLState.test(true, false);
        Shader shader = this.mShader;
        shader.useProgram();
        GLState.enableVertexArrays(shader.aPos, -1);
        if (gLViewport.pos.zoomLevel < 18) {
            GLAdapter.gl.enable(2884);
        }
        GLAdapter.gl.depthFunc(513);
        GLAdapter.gl.uniform1f(shader.uAlpha, this.mAlpha);
        GLAdapter.gl.uniform1f(shader.uZLimit, this.mZLimit);
        ExtrusionBuckets[] extrusionBucketsArray = this.mExtrusionBucketSet;
        boolean bl = this.mTranslucent;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (bl) {
            GLState.blend(false);
            GLAdapter.gl.colorMask(false, false, false, false);
            GLAdapter.gl.uniform1i(shader.uMode, -1);
            f2 = f3;
            for (n = 0; n < this.mBucketsCnt; ++n) {
                if (extrusionBucketsArray[n].ibo == null) {
                    return;
                }
                extrusionBucketsArray[n].ibo.bind();
                extrusionBucketsArray[n].vbo.bind();
                this.setMatrix(shader, gLViewport, extrusionBucketsArray[n]);
                f = this.mAlpha * this.getFade(extrusionBucketsArray[n]);
                f3 = f2;
                if (f != f2) {
                    GLAdapter.gl.uniform1f(shader.uAlpha, f);
                    f3 = f;
                }
                this.renderCombined(shader.aPos, extrusionBucketsArray[n]);
                f2 = f3;
            }
            GLAdapter.gl.colorMask(true, true, true, true);
            GLAdapter.gl.depthMask(false);
            GLAdapter.gl.depthFunc(514);
        }
        GLState.blend(true);
        GLState.enableVertexArrays(shader.aPos, shader.aLight);
        float[] fArray = null;
        f3 = f2;
        for (n = 0; n < this.mBucketsCnt; ++n) {
            if (extrusionBucketsArray[n].ibo == null) {
                f2 = f3;
            } else {
                extrusionBucketsArray[n].ibo.bind();
                extrusionBucketsArray[n].vbo.bind();
                if (!this.mTranslucent) {
                    this.setMatrix(shader, gLViewport, extrusionBucketsArray[n]);
                }
                f = this.mAlpha * this.getFade(extrusionBucketsArray[n]);
                f2 = f3;
                if (f != f3) {
                    GLAdapter.gl.uniform1f(shader.uAlpha, f);
                    f2 = f;
                }
                for (ExtrusionBucket extrusionBucket = extrusionBucketsArray[n].buckets(); extrusionBucket != null; extrusionBucket = extrusionBucket.next()) {
                    float[] fArray2 = fArray;
                    if (extrusionBucket.getColors() != fArray) {
                        fArray2 = extrusionBucket.getColors();
                        int n2 = shader.uColor;
                        int n3 = this.mMode == 0 ? 4 : 1;
                        GLUtils.glUniform4fv(n2, n3, fArray2);
                    }
                    GLAdapter.gl.vertexAttribPointer(shader.aPos, 3, 5122, false, 8, extrusionBucket.getVertexOffset());
                    GLAdapter.gl.vertexAttribPointer(shader.aLight, 2, 5121, false, 8, extrusionBucket.getVertexOffset() + 6);
                    if (extrusionBucket.idx[0] > 0) {
                        if (this.mTranslucent) {
                            GLAdapter.gl.depthFunc(514);
                            this.setMatrix(shader, gLViewport, extrusionBucketsArray[n]);
                        }
                        GLAdapter.gl.uniform1i(shader.uMode, 0);
                        GLAdapter.gl.drawElements(4, extrusionBucket.idx[2], 5123, extrusionBucket.off[2]);
                        GLAdapter.gl.uniform1i(shader.uMode, 1);
                        GLAdapter.gl.drawElements(4, extrusionBucket.idx[0], 5123, extrusionBucket.off[0]);
                        GLAdapter.gl.uniform1i(shader.uMode, 2);
                        GLAdapter.gl.drawElements(4, extrusionBucket.idx[1], 5123, extrusionBucket.off[1]);
                        if (this.mTranslucent) {
                            GLAdapter.gl.depthFunc(515);
                            gLViewport.mvp.addDepthOffset(100);
                            gLViewport.mvp.setAsUniform(shader.uMVP);
                        }
                        GLAdapter.gl.uniform1i(shader.uMode, 3);
                        GLAdapter.gl.drawElements(1, extrusionBucket.idx[3], 5123, extrusionBucket.off[3]);
                    }
                    if (extrusionBucket.idx[4] > 0) {
                        GLAdapter.gl.drawElements(4, extrusionBucket.idx[4], 5123, extrusionBucket.off[4]);
                    }
                    fArray = fArray2;
                }
                extrusionBucketsArray[n] = null;
            }
            f3 = f2;
        }
        if (!this.mTranslucent) {
            GLAdapter.gl.depthMask(false);
        }
        if (gLViewport.pos.zoomLevel < 18) {
            GLAdapter.gl.disable(2884);
        }
    }

    public void setZLimit(float f) {
        this.mZLimit = f;
    }

    @Override
    public boolean setup() {
        this.mShader = this.mMode == 0 ? new Shader("extrusion_layer_ext") : new Shader("extrusion_layer_mesh");
        return true;
    }

    public static class Shader
    extends GLShader {
        int aLight;
        int aPos;
        int uAlpha;
        int uColor;
        int uMVP;
        int uMode;
        int uZLimit;

        public Shader(String string2) {
            if (!this.create(string2)) {
                return;
            }
            this.uMVP = this.getUniform("u_mvp");
            this.uColor = this.getUniform("u_color");
            this.uAlpha = this.getUniform("u_alpha");
            this.uMode = this.getUniform("u_mode");
            this.uZLimit = this.getUniform("u_zlimit");
            this.aPos = this.getAttrib("a_pos");
            this.aLight = this.getAttrib("a_light");
        }
    }
}

