/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.oscim.backend.GLAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GLMatrix {
    private static final String INVALID_INPUT = "Bad Array!";
    private static final boolean dbg = false;
    static final Logger log = LoggerFactory.getLogger(GLMatrix.class);
    private final FloatBuffer buffer;
    private final long pointer;

    public GLMatrix() {
        long l;
        this.pointer = l = GLMatrix.alloc();
        this.buffer = GLMatrix.getBuffer(l).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    private static native void addDepthOffset(long var0, int var2);

    private static native long alloc();

    private static native void copy(long var0, long var2);

    private static native void delete(long var0);

    public static void frustumM(float[] fArray, int n, float f, float f2, float f3, float f4, float f5, float f6) {
        if (f != f2) {
            if (f4 != f3) {
                if (f5 != f6) {
                    if (!(f5 <= 0.0f)) {
                        if (!(f6 <= 0.0f)) {
                            float f7 = 1.0f / (f2 - f);
                            float f8 = 1.0f / (f4 - f3);
                            float f9 = 1.0f / (f5 - f6);
                            fArray[n + 0] = f5 * f7 * 2.0f;
                            fArray[n + 5] = f5 * f8 * 2.0f;
                            fArray[n + 8] = (f2 + f) * f7;
                            fArray[n + 9] = (f4 + f3) * f8;
                            fArray[n + 10] = (f6 + f5) * f9;
                            fArray[n + 14] = f6 * f5 * f9 * 2.0f;
                            fArray[n + 11] = -1.0f;
                            fArray[n + 1] = 0.0f;
                            fArray[n + 2] = 0.0f;
                            fArray[n + 3] = 0.0f;
                            fArray[n + 4] = 0.0f;
                            fArray[n + 6] = 0.0f;
                            fArray[n + 7] = 0.0f;
                            fArray[n + 12] = 0.0f;
                            fArray[n + 13] = 0.0f;
                            fArray[n + 15] = 0.0f;
                            return;
                        }
                        throw new IllegalArgumentException("far <= 0.0f");
                    }
                    throw new IllegalArgumentException("near <= 0.0f");
                }
                throw new IllegalArgumentException("near == far");
            }
            throw new IllegalArgumentException("top == bottom");
        }
        throw new IllegalArgumentException("left == right");
    }

    private static native void get(long var0, float[] var2);

    private static native ByteBuffer getBuffer(long var0);

    private static native void identity(long var0);

    public static boolean invertM(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 0];
        float f2 = fArray2[n2 + 1];
        float f3 = fArray2[n2 + 2];
        float f4 = fArray2[n2 + 3];
        float f5 = fArray2[n2 + 4];
        float f6 = fArray2[n2 + 5];
        float f7 = fArray2[n2 + 6];
        float f8 = fArray2[n2 + 7];
        float f9 = fArray2[n2 + 8];
        float f10 = fArray2[n2 + 9];
        float f11 = fArray2[n2 + 10];
        float f12 = fArray2[n2 + 11];
        float f13 = fArray2[n2 + 12];
        float f14 = fArray2[n2 + 13];
        float f15 = fArray2[n2 + 14];
        float f16 = fArray2[n2 + 15];
        float f17 = f11 * f16;
        float f18 = f15 * f12;
        float f19 = f7 * f16;
        float f20 = f15 * f8;
        float f21 = f7 * f12;
        float f22 = f11 * f8;
        float f23 = f3 * f16;
        float f24 = f15 * f4;
        float f25 = f3 * f12;
        float f26 = f11 * f4;
        float f27 = f3 * f8;
        float f28 = f7 * f4;
        float f29 = f17 * f6 + f20 * f10 + f21 * f14 - (f18 * f6 + f19 * f10 + f22 * f14);
        float f30 = f18 * f2 + f23 * f10 + f26 * f14 - (f17 * f2 + f24 * f10 + f25 * f14);
        float f31 = f19 * f2 + f24 * f6 + f27 * f14 - (f20 * f2 + f23 * f6 + f28 * f14);
        float f32 = f22 * f2 + f25 * f6 + f28 * f10 - (f21 * f2 + f26 * f6 + f27 * f10);
        float f33 = f9 * f14;
        float f34 = f13 * f10;
        float f35 = f5 * f14;
        float f36 = f13 * f6;
        float f37 = f5 * f10;
        float f38 = f9 * f6;
        float f39 = f14 * f;
        f14 = f13 * f2;
        float f40 = f10 * f;
        f10 = f9 * f2;
        f6 *= f;
        f2 *= f5;
        float f41 = f * f29 + f5 * f30 + f9 * f31 + f13 * f32;
        if (f41 == 0.0f) {
            return false;
        }
        f41 = 1.0f / f41;
        fArray[n] = f29 * f41;
        fArray[n + 1] = f30 * f41;
        fArray[n + 2] = f31 * f41;
        fArray[n + 3] = f32 * f41;
        fArray[n + 4] = (f18 * f5 + f19 * f9 + f22 * f13 - (f17 * f5 + f20 * f9 + f21 * f13)) * f41;
        fArray[n + 5] = (f17 * f + f24 * f9 + f25 * f13 - (f18 * f + f23 * f9 + f26 * f13)) * f41;
        fArray[n + 6] = (f20 * f + f23 * f5 + f28 * f13 - (f19 * f + f24 * f5 + f27 * f13)) * f41;
        fArray[n + 7] = (f21 * f + f26 * f5 + f27 * f9 - (f22 * f + f25 * f5 + f28 * f9)) * f41;
        fArray[n + 8] = (f33 * f8 + f36 * f12 + f37 * f16 - (f34 * f8 + f35 * f12 + f38 * f16)) * f41;
        fArray[n + 9] = (f34 * f4 + f39 * f12 + f10 * f16 - (f33 * f4 + f14 * f12 + f40 * f16)) * f41;
        fArray[n + 10] = (f35 * f4 + f14 * f8 + f6 * f16 - (f36 * f4 + f39 * f8 + f16 * f2)) * f41;
        fArray[n + 11] = (f38 * f4 + f40 * f8 + f2 * f12 - (f4 * f37 + f8 * f10 + f12 * f6)) * f41;
        fArray[n + 12] = (f35 * f11 + f38 * f15 + f34 * f7 - (f37 * f15 + f33 * f7 + f36 * f11)) * f41;
        fArray[n + 13] = (f40 * f15 + f33 * f3 + f14 * f11 - (f39 * f11 + f10 * f15 + f34 * f3)) * f41;
        fArray[n + 14] = (f39 * f7 + f2 * f15 + f36 * f3 - (f15 * f6 + f35 * f3 + f14 * f7)) * f41;
        fArray[n + 15] = (f6 * f11 + f37 * f3 + f10 * f7 - (f40 * f7 + f2 * f11 + f38 * f3)) * f41;
        return true;
    }

    private static native void mul(long var0, long var2);

    private static native void prj(long var0, float[] var2);

    private static native void prj2D(long var0, float[] var2, int var3, int var4);

    private static native void prj2D2(long var0, float[] var2, int var3, float[] var4, int var5, int var6);

    private static native void prj3D(long var0, float[] var2, int var3, int var4);

    private static native void set(long var0, float[] var2);

    private static native void setRotation(long var0, float var2, float var3, float var4, float var5);

    private static native void setScale(long var0, float var2, float var3, float var4);

    private static native void setTransScale(long var0, float var2, float var3, float var4);

    private static native void setTranslation(long var0, float var2, float var3, float var4);

    private static native void setValueAt(long var0, int var2, float var3);

    private static native void smul(long var0, long var2, long var4);

    private static native void smullhs(long var0, long var2);

    private static native void smulrhs(long var0, long var2);

    private static native void strans(long var0, long var2);

    public void addDepthOffset(int n) {
        GLMatrix.addDepthOffset(this.pointer, n);
    }

    public void copy(GLMatrix gLMatrix) {
        GLMatrix.copy(this.pointer, gLMatrix.pointer);
    }

    public void finalize() {
        long l = this.pointer;
        if (l != 0L) {
            GLMatrix.delete(l);
        }
    }

    public void get(float[] fArray) {
        if (fArray != null && fArray.length == 16) {
            GLMatrix.get(this.pointer, fArray);
            return;
        }
        throw new IllegalArgumentException(INVALID_INPUT);
    }

    public void multiplyLhs(GLMatrix gLMatrix) {
        GLMatrix.smullhs(this.pointer, gLMatrix.pointer);
    }

    public void multiplyMM(GLMatrix gLMatrix, GLMatrix gLMatrix2) {
        GLMatrix.smul(this.pointer, gLMatrix.pointer, gLMatrix2.pointer);
    }

    public void multiplyRhs(GLMatrix gLMatrix) {
        GLMatrix.smulrhs(this.pointer, gLMatrix.pointer);
    }

    public void prj(float[] fArray) {
        if (fArray != null && fArray.length >= 3) {
            GLMatrix.prj(this.pointer, fArray);
            return;
        }
        throw new IllegalArgumentException(INVALID_INPUT);
    }

    public void prj2D(float[] fArray, int n, int n2) {
        if (fArray != null && n >= 0 && (n2 + n) * 2 <= fArray.length) {
            GLMatrix.prj2D(this.pointer, fArray, n, n2);
            return;
        }
        throw new IllegalArgumentException(INVALID_INPUT);
    }

    public void prj2D(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray != null && n >= 0 && n * 2 + n3 <= fArray.length) {
            GLMatrix.prj2D2(this.pointer, fArray, n, fArray2, n2, n3);
            return;
        }
        throw new IllegalArgumentException(INVALID_INPUT);
    }

    public void prj3D(float[] fArray, int n, int n2) {
        if (fArray != null && fArray.length / (n + n2) >= 1) {
            GLMatrix.prj3D(this.pointer, fArray, n, n2);
            return;
        }
        throw new IllegalArgumentException(INVALID_INPUT);
    }

    public void set(float[] fArray) {
        if (fArray != null && fArray.length == 16) {
            GLMatrix.set(this.pointer, fArray);
            return;
        }
        throw new IllegalArgumentException(INVALID_INPUT);
    }

    public void setAsUniform(int n) {
        GLAdapter.gl.uniformMatrix4fv(n, 1, false, this.buffer);
    }

    public void setIdentity() {
        GLMatrix.identity(this.pointer);
    }

    public void setRotation(float f, float f2, float f3, float f4) {
        GLMatrix.setRotation(this.pointer, f, f2, f3, f4);
    }

    public void setScale(float f, float f2, float f3) {
        GLMatrix.setScale(this.pointer, f, f2, f3);
    }

    public void setTransScale(float f, float f2, float f3) {
        GLMatrix.setTransScale(this.pointer, f, f2, f3);
    }

    public void setTranslation(float f, float f2, float f3) {
        GLMatrix.setTranslation(this.pointer, f, f2, f3);
    }

    public void setValue(int n, float f) {
        GLMatrix.setValueAt(this.pointer, n, f);
    }

    public void transposeM(GLMatrix gLMatrix) {
        GLMatrix.strans(this.pointer, gLMatrix.pointer);
    }
}

