/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.io.PrintStream;
import java.nio.IntBuffer;
import org.oscim.backend.AssetAdapter;
import org.oscim.backend.GLAdapter;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.MapRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GLShader {
    static final Logger log = LoggerFactory.getLogger(GLShader.class);
    public int program;

    public static int createProgram(String string2, String string3) {
        return GLShader.createProgramVersioned(string2, string3, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int createProgramVersioned(String object, String string2, String charSequence) {
        CharSequence charSequence2 = "";
        if (charSequence != null) {
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append("");
            ((StringBuilder)charSequence2).append("#version ");
            ((StringBuilder)charSequence2).append((String)charSequence);
            ((StringBuilder)charSequence2).append("\n");
            charSequence2 = ((StringBuilder)charSequence2).toString();
        }
        if (GLAdapter.GDX_DESKTOP_QUIRKS) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append("#define DESKTOP_QUIRKS 1\n");
            charSequence = ((StringBuilder)charSequence).toString();
        } else {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append("#define GLES 1\n");
            charSequence = ((StringBuilder)charSequence).toString();
        }
        charSequence2 = new StringBuilder();
        ((StringBuilder)charSequence2).append((String)charSequence);
        ((StringBuilder)charSequence2).append((String)object);
        int n = GLShader.loadShader(35633, ((StringBuilder)charSequence2).toString());
        int n2 = 0;
        if (n == 0) {
            return 0;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append((String)charSequence);
        ((StringBuilder)object).append(string2);
        int n3 = GLShader.loadShader(35632, ((StringBuilder)object).toString());
        if (n3 == 0) {
            return 0;
        }
        int n4 = GLAdapter.gl.createProgram();
        if (n4 == 0) return n4;
        GLUtils.checkGlError("glCreateProgram");
        GLAdapter.gl.attachShader(n4, n);
        GLUtils.checkGlError("glAttachShader");
        GLAdapter.gl.attachShader(n4, n3);
        GLUtils.checkGlError("glAttachShader");
        GLAdapter.gl.linkProgram(n4);
        object = MapRenderer.getIntBuffer(1);
        GLAdapter.gl.getProgramiv(n4, 35714, (IntBuffer)object);
        ((IntBuffer)object).position(0);
        if (((IntBuffer)object).get() == 1) return n4;
        object = log;
        object.error("Could not link program: ");
        object.error(GLAdapter.gl.getProgramInfoLog(n4));
        GLAdapter.gl.deleteProgram(n4);
        return n2;
    }

    public static int loadShader(int n, String object) {
        int n2;
        int n3 = n2 = GLAdapter.gl.createShader(n);
        if (n2 != 0) {
            GLAdapter.gl.shaderSource(n2, (String)object);
            GLAdapter.gl.compileShader(n2);
            object = MapRenderer.getIntBuffer(1);
            GLAdapter.gl.getShaderiv(n2, 35713, (IntBuffer)object);
            ((IntBuffer)object).position(0);
            n3 = n2;
            if (((IntBuffer)object).get() == 0) {
                Logger logger = log;
                object = new StringBuilder();
                ((StringBuilder)object).append("Could not compile shader ");
                ((StringBuilder)object).append(n);
                ((StringBuilder)object).append(":");
                logger.error(((StringBuilder)object).toString());
                logger.error(GLAdapter.gl.getShaderInfoLog(n2));
                GLAdapter.gl.deleteShader(n2);
                n3 = 0;
            }
        }
        return n3;
    }

    public static int loadShader(String string2) {
        return GLShader.loadShaderVersioned(string2, null);
    }

    public static int loadShaderVersioned(String string2, String object) {
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("shaders/");
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(".glsl");
        string2 = ((StringBuilder)charSequence).toString();
        charSequence = AssetAdapter.readTextFile(string2);
        if (charSequence != null) {
            int n = ((String)charSequence).indexOf(36);
            if (n >= 0 && ((String)charSequence).charAt(n + 1) == '$') {
                string2 = ((String)charSequence).substring(n + 2);
                if ((n = GLShader.createProgramVersioned((String)(charSequence = ((String)charSequence).substring(0, n)), string2, (String)object)) == 0) {
                    object = System.out;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((String)charSequence);
                    stringBuilder.append(" \n\n");
                    stringBuilder.append(string2);
                    ((PrintStream)object).println(stringBuilder.toString());
                }
                return n;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("not a shader file ");
            ((StringBuilder)object).append(string2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("shader file not found: ");
        ((StringBuilder)object).append(string2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    protected boolean create(String string2) {
        return this.createVersioned(string2, null);
    }

    protected boolean create(String string2, String string3) {
        return this.createVersioned(string2, string3, null);
    }

    protected boolean createVersioned(String string2, String string3) {
        int n;
        this.program = n = GLShader.loadShaderVersioned(string2, string3);
        boolean bl = n != 0;
        return bl;
    }

    protected boolean createVersioned(String string2, String string3, String string4) {
        int n;
        this.program = n = GLShader.createProgramVersioned(string2, string3, string4);
        boolean bl = n != 0;
        return bl;
    }

    protected int getAttrib(String string2) {
        int n = GLAdapter.gl.getAttribLocation(this.program, string2);
        if (n < 0) {
            log.debug("missing attribute: {}", (Object)string2);
        }
        return n;
    }

    protected int getUniform(String string2) {
        int n = GLAdapter.gl.getUniformLocation(this.program, string2);
        if (n < 0) {
            log.debug("missing uniform: {}", (Object)string2);
        }
        return n;
    }

    public boolean useProgram() {
        return GLState.useProgram(this.program);
    }
}

