/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.backend.GLAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GLState {
    private static boolean blend;
    private static float[] clearColor;
    private static int currentTexId;
    private static boolean depth;
    private static int glIndexBuffer;
    private static int glVertexBuffer;
    static final Logger log;
    private static int shader;
    private static boolean stencil;
    private static final boolean[] vertexArray;

    static {
        log = LoggerFactory.getLogger(GLState.class);
        vertexArray = new boolean[]{false, false};
        blend = false;
        depth = false;
        stencil = false;
    }

    public static void bindBuffer(int n, int n2) {
        block8: {
            block7: {
                block6: {
                    if (n != 34962) break block6;
                    if (glVertexBuffer == n2) {
                        return;
                    }
                    glVertexBuffer = n2;
                    break block7;
                }
                if (n != 34963) break block8;
                if (glIndexBuffer == n2) {
                    return;
                }
                glIndexBuffer = n2;
            }
            if (n2 >= 0) {
                GLAdapter.gl.bindBuffer(n, n2);
            }
            return;
        }
        log.debug("invalid target {}", (Object)n);
    }

    public static void bindElementBuffer(int n) {
        if (glIndexBuffer == n) {
            return;
        }
        glIndexBuffer = n;
        if (n >= 0) {
            GLAdapter.gl.bindBuffer(34963, n);
        }
    }

    public static void bindTex2D(int n) {
        if (n < 0) {
            GLAdapter.gl.bindTexture(3553, 0);
            currentTexId = 0;
        } else if (currentTexId != n) {
            GLAdapter.gl.bindTexture(3553, n);
            currentTexId = n;
        }
    }

    public static void bindVertexBuffer(int n) {
        if (glVertexBuffer == n) {
            return;
        }
        glVertexBuffer = n;
        if (n >= 0) {
            GLAdapter.gl.bindBuffer(34962, n);
        }
    }

    public static void blend(boolean bl) {
        if (blend == bl) {
            return;
        }
        if (bl) {
            GLAdapter.gl.enable(3042);
        } else {
            GLAdapter.gl.disable(3042);
        }
        blend = bl;
    }

    public static void enableVertexArrays(int n, int n2) {
        boolean[] blArray;
        if (n > 1 || n2 > 1) {
            log.debug("FIXME: enableVertexArrays...");
        }
        if (n != 0 && n2 != 0) {
            blArray = vertexArray;
            if (blArray[0]) {
                GLAdapter.gl.disableVertexAttribArray(0);
                blArray[0] = false;
            }
        } else {
            blArray = vertexArray;
            if (!blArray[0]) {
                GLAdapter.gl.enableVertexAttribArray(0);
                blArray[0] = true;
            }
        }
        if (n != 1 && n2 != 1) {
            blArray = vertexArray;
            if (blArray[1]) {
                GLAdapter.gl.disableVertexAttribArray(1);
                blArray[1] = false;
            }
        } else {
            blArray = vertexArray;
            if (!blArray[1]) {
                GLAdapter.gl.enableVertexAttribArray(1);
                blArray[1] = true;
            }
        }
    }

    static void init() {
        boolean[] blArray = vertexArray;
        blArray[0] = false;
        blArray[1] = false;
        blend = false;
        depth = false;
        stencil = false;
        shader = -1;
        currentTexId = -1;
        glVertexBuffer = -1;
        glIndexBuffer = -1;
        clearColor = null;
        GLAdapter.gl.disable(2960);
        GLAdapter.gl.disable(2929);
        GLAdapter.gl.disable(3042);
    }

    public static void setClearColor(float[] fArray) {
        float[] fArray2;
        if (!GLAdapter.GDX_DESKTOP_QUIRKS && (fArray2 = clearColor) != null && fArray[0] == fArray2[0] && fArray[1] == fArray2[1] && fArray[2] == fArray2[2] && fArray[3] == fArray2[3]) {
            return;
        }
        clearColor = fArray;
        GLAdapter.gl.clearColor(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public static void test(boolean bl, boolean bl2) {
        if (depth != bl) {
            if (bl) {
                GLAdapter.gl.enable(2929);
            } else {
                GLAdapter.gl.disable(2929);
            }
            depth = bl;
        }
        if (stencil != bl2) {
            if (bl2) {
                GLAdapter.gl.enable(2960);
            } else {
                GLAdapter.gl.disable(2960);
            }
            stencil = bl2;
        }
    }

    public static void testDepth(boolean bl) {
        if (depth != bl) {
            if (bl) {
                GLAdapter.gl.enable(2929);
            } else {
                GLAdapter.gl.disable(2929);
            }
            depth = bl;
        }
    }

    public static boolean useProgram(int n) {
        if (n < 0) {
            shader = -1;
        } else if (n != shader) {
            GLAdapter.gl.useProgram(n);
            shader = n;
            return true;
        }
        return false;
    }
}

