/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.oscim.backend.GLAdapter;
import org.oscim.renderer.GLState;
import org.oscim.renderer.MapRenderer;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GLUtils {
    static final Logger log = LoggerFactory.getLogger(GLUtils.class);

    public static void changeSaturation(float[] fArray, float f) {
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        double d = Math.sqrt(f2 * f2 * 0.299f + f3 * f3 * 0.587f + f4 * f4 * 0.114f);
        double d2 = f2;
        double d3 = f;
        fArray[0] = FastMath.clampN((float)((d2 - d) * d3 + d));
        fArray[1] = FastMath.clampN((float)(((double)f3 - d) * d3 + d));
        fArray[2] = FastMath.clampN((float)(d + ((double)f4 - d) * d3));
    }

    public static void checkGlError(String string2) {
        int n;
        while ((n = GLAdapter.gl.getError()) != 0) {
            Logger logger = log;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(": glError ");
            stringBuilder.append(n);
            logger.error(stringBuilder.toString());
        }
    }

    public static boolean checkGlOutOfMemory(String string2) {
        int n;
        boolean bl = false;
        while ((n = GLAdapter.gl.getError()) != 0) {
            Logger logger = log;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(": glError ");
            stringBuilder.append(n);
            logger.error(stringBuilder.toString());
            if (n != 1285) continue;
            bl = true;
        }
        return bl;
    }

    public static float[] colorToFloat(int n) {
        float f = (float)(n >> 24 & 0xFF) / 255.0f;
        return new float[]{(float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n >> 0 & 0xFF) / 255.0f, f};
    }

    public static float[] colorToFloatP(int n) {
        float[] fArray = new float[4];
        fArray[3] = (float)(n >> 24 & 0xFF) / 255.0f;
        fArray[0] = (float)(n >> 16 & 0xFF) / 255.0f * fArray[3];
        fArray[1] = (float)(n >> 8 & 0xFF) / 255.0f * fArray[3];
        fArray[2] = (float)(n >> 0 & 0xFF) / 255.0f * fArray[3];
        return fArray;
    }

    public static void glDeleteBuffers(int n, int[] nArray) {
        IntBuffer intBuffer = MapRenderer.getIntBuffer(n);
        intBuffer.put(nArray, 0, n);
        intBuffer.flip();
        GLAdapter.gl.deleteBuffers(n, intBuffer);
    }

    public static void glDeleteTextures(int n, int[] nArray) {
        IntBuffer intBuffer = MapRenderer.getIntBuffer(n);
        intBuffer.put(nArray, 0, n);
        intBuffer.flip();
        GLAdapter.gl.deleteTextures(n, intBuffer);
    }

    public static int[] glGenBuffers(int n) {
        IntBuffer intBuffer = MapRenderer.getIntBuffer(n);
        intBuffer.position(0);
        intBuffer.limit(n);
        GLAdapter.gl.genBuffers(n, intBuffer);
        int[] nArray = new int[n];
        intBuffer.position(0);
        intBuffer.limit(n);
        intBuffer.get(nArray);
        return nArray;
    }

    public static int[] glGenTextures(int n) {
        if (n <= 0) {
            return null;
        }
        int[] nArray = new int[n];
        IntBuffer intBuffer = GLAdapter.GDX_DESKTOP_QUIRKS ? ByteBuffer.allocateDirect(n * 4).order(ByteOrder.nativeOrder()).asIntBuffer() : MapRenderer.getIntBuffer(n);
        if (GLAdapter.GDX_WEBGL_QUIRKS) {
            for (int i = 0; i < n; ++i) {
                GLAdapter.gl.genTextures(n, intBuffer);
                intBuffer.position(0);
                nArray[i] = intBuffer.get();
                intBuffer.position(0);
            }
        } else {
            GLAdapter.gl.genTextures(n, intBuffer);
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
        return nArray;
    }

    public static void glUniform4fv(int n, int n2, float[] fArray) {
        FloatBuffer floatBuffer = MapRenderer.getFloatBuffer(n2 * 4);
        floatBuffer.put(fArray);
        floatBuffer.flip();
        GLAdapter.gl.uniform4fv(n, n2, floatBuffer);
    }

    public static int loadTexture(byte[] object, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray = GLUtils.glGenTextures(1);
        GLState.bindTex2D(nArray[0]);
        GLUtils.setTextureParameter(n4, n5, n6, n7);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2).order(ByteOrder.nativeOrder());
        byteBuffer.put((byte[])object);
        byteBuffer.position(0);
        object = byteBuffer.asIntBuffer();
        GLAdapter.gl.texImage2D(3553, 0, n3, n, n2, 0, n3, 5121, (Buffer)object);
        GLState.bindTex2D(0);
        return nArray[0];
    }

    public static void setColor(int n, int n2, float f) {
        f = f >= 1.0f ? (float)(n2 >>> 24 & 0xFF) / 255.0f : (f < 0.0f ? 0.0f : (float)(n2 >>> 24 & 0xFF) / 255.0f * f);
        if (f == 1.0f) {
            GLAdapter.gl.uniform4f(n, (float)(n2 >>> 16 & 0xFF) / 255.0f, (float)(n2 >>> 8 & 0xFF) / 255.0f, (float)(n2 >>> 0 & 0xFF) / 255.0f, f);
        } else {
            GLAdapter.gl.uniform4f(n, (float)(n2 >>> 16 & 0xFF) / 255.0f * f, (float)(n2 >>> 8 & 0xFF) / 255.0f * f, (float)(n2 >>> 0 & 0xFF) / 255.0f * f, f);
        }
    }

    public static void setColor(int n, float[] fArray, float f) {
        if (f >= 1.0f) {
            GLAdapter.gl.uniform4f(n, fArray[0], fArray[1], fArray[2], fArray[3]);
        } else {
            float f2 = f;
            if (f < 0.0f) {
                Logger logger = log;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("setColor: ");
                stringBuilder.append(f);
                logger.debug(stringBuilder.toString());
                GLAdapter.gl.uniform4f(n, 0.0f, 0.0f, 0.0f, 0.0f);
                f2 = 0.0f;
            }
            GLAdapter.gl.uniform4f(n, fArray[0] * f2, fArray[1] * f2, fArray[2] * f2, fArray[3] * f2);
        }
    }

    public static void setColorBlend(int n, int n2, int n3, float f) {
        float f2 = (float)(n2 >>> 24 & 0xFF) / 255.0f * (1.0f - f);
        f = (float)(n3 >>> 24 & 0xFF) / 255.0f * f;
        GLAdapter.gl.uniform4f(n, (float)(n2 >>> 16 & 0xFF) / 255.0f * f2 + (float)(n3 >>> 16 & 0xFF) / 255.0f * f, (float)(n2 >>> 8 & 0xFF) / 255.0f * f2 + (float)(n3 >>> 8 & 0xFF) / 255.0f * f, (float)(n2 >>> 0 & 0xFF) / 255.0f * f2 + (float)(n3 >>> 0 & 0xFF) / 255.0f * f, f2 + f);
    }

    public static void setTextureParameter(int n, int n2, int n3, int n4) {
        GLAdapter.gl.texParameterf(3553, 10241, n);
        GLAdapter.gl.texParameterf(3553, 10240, n2);
        GLAdapter.gl.texParameterf(3553, 10242, n3);
        GLAdapter.gl.texParameterf(3553, 10243, n4);
    }
}

