/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.backend.canvas.Paint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.Tile;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.TextBucket;
import org.oscim.renderer.bucket.TextItem;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.TextStyle;

public class GridRenderer
extends BucketRenderer {
    private int mCurX;
    private int mCurY;
    private int mCurZ;
    private final LineBucket mLineBucket;
    private final GeometryBuffer mLines;
    private final StringBuilder mStringBuffer;
    private final TextStyle mText;
    private final TextBucket mTextBucket;

    public GridRenderer() {
        this(1.0f);
    }

    public GridRenderer(float f) {
        this(1, new LineStyle(-7829368, 1.2f * f, Paint.Cap.BUTT), (TextStyle)((TextStyle.TextBuilder)((RenderStyle.StyleBuilder)((TextStyle.TextBuilder)TextStyle.builder().fontSize(f * 12.0f)).fontStyle(Paint.FontStyle.BOLD)).color(-65536)).build());
    }

    public GridRenderer(int n, LineStyle object, TextStyle textStyle) {
        LineBucket lineBucket;
        float f;
        int n2;
        int n3;
        int n4 = Tile.SIZE;
        this.mLines = new GeometryBuffer(32, 16);
        float f2 = -n4 * 4;
        for (n3 = 0; n3 < (n2 = n * 8); ++n3) {
            f = (float)(n3 * n4 / n) + f2;
            this.mLines.startLine();
            this.mLines.addPoint(f, f2);
            this.mLines.addPoint(f, (float)(n4 * 8) + f2);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            f = (float)(n3 * n4 / n) + f2;
            this.mLines.startLine();
            this.mLines.addPoint(f2, f);
            this.mLines.addPoint((float)(n4 * 8) + f2, f);
        }
        this.mText = textStyle;
        this.mLineBucket = lineBucket = new LineBucket(0);
        lineBucket.line = object;
        if (textStyle != null) {
            this.mTextBucket = object = new TextBucket();
            ((TextBucket)object).next = lineBucket;
        } else {
            this.mTextBucket = null;
            lineBucket.addLine(this.mLines);
            this.buckets.set(lineBucket);
        }
        this.mStringBuffer = new StringBuilder(32);
    }

    private void addLabels(int n, int n2, int n3) {
        int n4 = Tile.SIZE;
        TextBucket textBucket = this.mTextBucket;
        textBucket.clear();
        StringBuilder stringBuilder = this.mStringBuffer;
        for (int i = -2; i < 2; ++i) {
            for (int j = -2; j < 2; ++j) {
                stringBuilder.setLength(0);
                stringBuilder.append(n3);
                stringBuilder.append(" / ");
                stringBuilder.append(n + j);
                stringBuilder.append(" / ");
                stringBuilder.append(n2 + i);
                TextItem textItem = TextItem.pool.get();
                int n5 = n4 / 2;
                textItem.set(n4 * j + n5, n4 * i + n5, stringBuilder.toString(), this.mText);
                textBucket.addText(textItem);
            }
        }
    }

    @Override
    public void update(GLViewport gLViewport) {
        int n = 1 << gLViewport.pos.zoomLevel;
        double d = gLViewport.pos.x;
        double d2 = n;
        int n2 = (int)(d * d2);
        int n3 = (int)(gLViewport.pos.y * d2);
        if (n2 == this.mCurX && n3 == this.mCurY && n == this.mCurZ) {
            return;
        }
        this.mCurX = n2;
        this.mCurY = n3;
        this.mCurZ = n;
        this.mMapPosition.copy(gLViewport.pos);
        this.mMapPosition.x = (double)n2 / d2;
        this.mMapPosition.y = (double)n3 / d2;
        this.mMapPosition.scale = d2;
        if (this.mText != null) {
            this.buckets.set(this.mTextBucket);
            this.addLabels(n2, n3, gLViewport.pos.zoomLevel);
            this.mLineBucket.addLine(this.mLines);
            this.buckets.prepare();
            this.setReady(false);
        }
        if (!this.isReady()) {
            this.compile();
        }
    }
}

