/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.GLAdapter;
import org.oscim.backend.canvas.Color;
import org.oscim.core.Box;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.MapRenderer;
import org.oscim.utils.FastMath;
import org.oscim.utils.math.Interpolation;

public class LocationRenderer
extends LayerRenderer {
    private static final long ANIM_RATE = 50L;
    private static final float CIRCLE_SIZE = 30.0f;
    private static final int COLOR = -13421620;
    private static final long INTERVAL = 2000L;
    private static final int SHOW_ACCURACY_ZOOM = 16;
    private int hDirection;
    private int hMatrixPosition;
    private int hPhase;
    private int hScale;
    private int hVertexPosition;
    private long mAnimStart;
    private final Box mBBox;
    private Callback mCallback;
    private final float[] mColors;
    private final Point mIndicatorPosition = new Point();
    private boolean mInitialized;
    private final Layer mLayer;
    private final Point mLocation;
    private boolean mLocationIsVisible;
    private final Map mMap;
    private double mRadius;
    private boolean mRunAnim;
    private final float mScale;
    private final Point mScreenPoint = new Point();
    private String mShaderFile;
    private int mShaderProgram;
    private int mShowAccuracyZoom;
    private int uColor;
    private int uMode;

    public LocationRenderer(Map map, Layer layer) {
        this(map, layer, CanvasAdapter.getScale());
    }

    public LocationRenderer(Map map, Layer layer, float f) {
        this.mBBox = new Box();
        float[] fArray = new float[4];
        this.mColors = fArray;
        this.mLocation = new Point(Double.NaN, Double.NaN);
        this.mShowAccuracyZoom = 16;
        this.mMap = map;
        this.mLayer = layer;
        this.mScale = f;
        f = Color.aToFloat(-13421620);
        fArray[0] = Color.rToFloat(-13421620) * f;
        fArray[1] = Color.gToFloat(-13421620) * f;
        fArray[2] = Color.bToFloat(-13421620) * f;
        fArray[3] = f;
    }

    private float animPhase() {
        return (float)((MapRenderer.frametime - this.mAnimStart) % 2000L) / 2000.0f;
    }

    private boolean init() {
        String string2 = this.mShaderFile;
        if (string2 == null) {
            string2 = "location_1";
        }
        int n = GLShader.loadShader(string2);
        if (n == 0) {
            return false;
        }
        this.mShaderProgram = n;
        this.hVertexPosition = GLAdapter.gl.getAttribLocation(n, "a_pos");
        this.hMatrixPosition = GLAdapter.gl.getUniformLocation(n, "u_mvp");
        this.hPhase = GLAdapter.gl.getUniformLocation(n, "u_phase");
        this.hScale = GLAdapter.gl.getUniformLocation(n, "u_scale");
        this.hDirection = GLAdapter.gl.getUniformLocation(n, "u_dir");
        this.uColor = GLAdapter.gl.getUniformLocation(n, "u_color");
        this.uMode = GLAdapter.gl.getUniformLocation(n, "u_mode");
        return true;
    }

    public void animate(boolean bl) {
        if (this.mRunAnim == bl) {
            return;
        }
        this.mRunAnim = bl;
        if (!bl) {
            return;
        }
        Runnable runnable = new Runnable(){
            private long lastRun;

            @Override
            public void run() {
                if (!LocationRenderer.this.mRunAnim) {
                    return;
                }
                long l = System.currentTimeMillis();
                long l2 = this.lastRun;
                LocationRenderer.this.mMap.postDelayed(this, Math.min(50L, l - l2));
                if (!LocationRenderer.this.mLocationIsVisible) {
                    LocationRenderer.this.mMap.render();
                }
                this.lastRun = System.currentTimeMillis();
            }
        };
        this.mAnimStart = System.currentTimeMillis();
        this.mMap.postDelayed(runnable, 50L);
    }

    @Override
    public void render(GLViewport object) {
        int n;
        GLState.useProgram(this.mShaderProgram);
        GLState.blend(true);
        GLState.test(false, false);
        GLState.enableVertexArrays(this.hVertexPosition, -1);
        MapRenderer.bindQuadVertexVBO(this.hVertexPosition);
        float f = this.mScale * 30.0f;
        this.animate(true);
        if (!this.mLocationIsVisible) {
            n = 0;
        } else {
            if (((GLViewport)object).pos.zoomLevel >= this.mShowAccuracyZoom) {
                f = (float)(this.mRadius * ((GLViewport)object).pos.scale);
            }
            f = Math.max(this.mScale * 30.0f, f);
            n = 1;
        }
        GLAdapter.gl.uniform1f(this.hScale, f);
        double d = this.mIndicatorPosition.x;
        double d2 = ((GLViewport)object).pos.x;
        double d3 = this.mIndicatorPosition.y;
        double d4 = ((GLViewport)object).pos.y;
        double d5 = (double)Tile.SIZE * ((GLViewport)object).pos.scale;
        ((GLViewport)object).mvp.setTransScale((float)((d - d2) * d5), (float)((d3 - d4) * d5), 1.0f);
        ((GLViewport)object).mvp.multiplyMM(((GLViewport)object).viewproj, ((GLViewport)object).mvp);
        ((GLViewport)object).mvp.setAsUniform(this.hMatrixPosition);
        if (n == 0) {
            f = Math.abs(this.animPhase() - 0.5f);
            f = Interpolation.swing.apply(f * 2.0f);
            GLAdapter.gl.uniform1f(this.hPhase, f * 0.2f + 0.8f);
        } else {
            GLAdapter.gl.uniform1f(this.hPhase, 1.0f);
        }
        if (n != 0 && this.mLocationIsVisible) {
            object = this.mCallback;
            if (object != null && object.hasRotation()) {
                f = this.mCallback.getRotation();
                object = GLAdapter.gl;
                n = this.hDirection;
                d = f - 90.0f;
                object.uniform2f(n, (float)Math.cos(Math.toRadians(d)), (float)Math.sin(Math.toRadians(d)));
                GLAdapter.gl.uniform1i(this.uMode, 1);
            } else {
                GLAdapter.gl.uniform2f(this.hDirection, 0.0f, 0.0f);
                GLAdapter.gl.uniform1i(this.uMode, 0);
            }
        } else {
            GLAdapter.gl.uniform1i(this.uMode, -1);
        }
        GLUtils.glUniform4fv(this.uColor, 1, this.mColors);
        GLAdapter.gl.drawArrays(5, 0, 4);
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setColor(int n) {
        float f = Color.aToFloat(n);
        this.mColors[0] = Color.rToFloat(n) * f;
        this.mColors[1] = Color.gToFloat(n) * f;
        this.mColors[2] = Color.bToFloat(n) * f;
        this.mColors[3] = f;
    }

    public void setLocation(double d, double d2, double d3) {
        this.mLocation.x = d;
        this.mLocation.y = d2;
        this.mRadius = d3;
    }

    public void setShader(String string2) {
        this.mShaderFile = string2;
        this.mInitialized = false;
    }

    public void setShowAccuracyZoom(int n) {
        this.mShowAccuracyZoom = n;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(GLViewport var1_1) {
        var2_2 = this.mInitialized;
        var3_3 = true;
        if (!var2_2) {
            this.init();
            this.mInitialized = true;
        }
        if (!this.mLayer.isEnabled()) {
            this.setReady(false);
            return;
        }
        this.setReady(true);
        var4_4 = this.mMap.getWidth();
        var5_5 = this.mMap.getHeight();
        var1_1.getBBox(this.mBBox, 0);
        var6_6 = this.mLocation.x;
        var8_7 = this.mLocation.y;
        if (!this.mBBox.contains(this.mLocation)) {
            var6_6 = FastMath.clamp(var6_6, this.mBBox.xmin, this.mBBox.xmax);
            var8_7 = FastMath.clamp(var8_7, this.mBBox.ymin, this.mBBox.ymax);
        }
        var1_1.toScreenPoint(var6_6, var8_7, this.mScreenPoint);
        var8_7 = this.mScreenPoint.x + (double)(var4_4 / 2);
        var10_8 = this.mScreenPoint.y + (double)(var5_5 / 2);
        if (var8_7 > (double)(var4_4 - 5)) {
            var6_6 = var4_4;
lbl25:
            // 2 sources

            while (true) {
                var4_4 = 0;
                var8_7 = var6_6;
                break;
            }
        } else {
            if (var8_7 < 5.0) {
                var6_6 = 0.0;
                ** continue;
            }
            var4_4 = 1;
        }
        if (var10_8 > (double)(var5_5 - 5)) {
            var6_6 = var5_5;
        } else if (var10_8 < 5.0) {
            var6_6 = 0.0;
        } else {
            ++var4_4;
            var6_6 = var10_8;
        }
        if (var4_4 != 2) {
            var3_3 = false;
        }
        this.mLocationIsVisible = var3_3;
        var1_1.fromScreenPoint(var8_7, var6_6, this.mIndicatorPosition);
    }

    public static interface Callback {
        public float getRotation();

        public boolean hasRotation();
    }
}

